package com.zurrtum.create.client.content.trains.schedule.hat;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_630;

public record TrainHatInfo(String part, int cubeIndex, class_243 offset, float scale) {
    public static final Codec<TrainHatInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        Codec.STRING.optionalFieldOf("model_part", "").forGetter(TrainHatInfo::part),
        Codec.INT.optionalFieldOf("cube_index", 0).forGetter(TrainHatInfo::cubeIndex),
        class_243.field_38277.fieldOf("offset").forGetter(TrainHatInfo::offset),
        Codec.FLOAT.optionalFieldOf("scale", 1.0F).forGetter(TrainHatInfo::scale)
    ).apply(instance, TrainHatInfo::new));

    public static List<class_630> getAdjustedPart(TrainHatInfo info, class_630 root, String defaultPart) {
        List<class_630> finalParts = new ArrayList<>();
        finalParts.add(root);
        class_630 parent = root;
        if (!info.part().isEmpty() && !info.part().equals(defaultPart)) {
            String[] partList = info.part().split("/");
            for (String part : partList) {
                if (parent.field_3661.containsKey(part)) {
                    finalParts.add(parent.field_3661.get(part));
                    parent = parent.field_3661.get(part);
                }
            }
        } else {
            if (parent.field_3661.containsKey(defaultPart)) {
                finalParts.add(parent.field_3661.get(defaultPart));
            }
        }

        return finalParts;
    }
}
