package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.Transform;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour.RenderedTrackOverlayType;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

public class StationRenderer extends SafeBlockEntityRenderer<StationBlockEntity> {

    public StationRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(StationBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        class_2338 pos = be.method_11016();
        TrackTargetingBehaviour<GlobalStation> target = be.edgePoint;
        class_2338 targetPosition = target.getGlobalPosition();
        class_1937 level = be.method_10997();

        DepotRenderer.renderItemsOf(be, partialTicks, ms, buffer, light, overlay, be.depotBehaviour);

        class_2680 trackState = level.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock track))
            return;

        GlobalStation station = be.getStation();
        boolean isAssembling = be.method_11010().method_11654(StationBlock.ASSEMBLING);

        if (!isAssembling || (station == null || station.getPresentTrain() != null) && !be.isVirtual()) {
            renderFlag(
                be.flag.getValue(partialTicks) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF,
                be,
                partialTicks,
                ms,
                buffer,
                light,
                overlay
            );
            TrackBlockRenderer renderer = AllTrackRenders.get(track);
            if (renderer != null) {
                ms.method_22903();
                TransformStack.of(ms).translate(targetPosition.method_10059(pos));
                renderer.render(
                    level,
                    trackState,
                    targetPosition,
                    target.getTargetDirection(),
                    target.getTargetBezier(),
                    ms,
                    buffer,
                    light,
                    overlay,
                    RenderedTrackOverlayType.STATION,
                    1
                );
                ms.method_22909();
            }
            return;
        }

        renderFlag(AllPartialModels.STATION_ASSEMBLE, be, partialTicks, ms, buffer, light, overlay);

        class_2350 direction = be.assemblyDirection;

        if (be.isVirtual() && be.bogeyLocations == null)
            be.refreshAssemblyInfo();

        if (direction == null || be.assemblyLength == 0 || be.bogeyLocations == null)
            return;

        ms.method_22903();
        class_2338 offset = targetPosition.method_10059(pos);
        ms.method_46416(offset.method_10263(), offset.method_10264(), offset.method_10260());

        class_2338.class_2339 currentPos = targetPosition.method_25503();

        PartialModel assemblyOverlay = null;
        TrackBlockRenderer renderer = AllTrackRenders.get(track);
        if (renderer != null) {
            assemblyOverlay = renderer.prepareAssemblyOverlay(level, targetPosition, trackState, direction, ms);
        }
        int colorWhenValid = 0x96B5FF;
        int colorWhenCarriage = 0xCAFF96;
        class_4588 vb = buffer.getBuffer(class_1921.method_23579());

        currentPos.method_10104(direction, 1);
        ms.method_46416(0, 0, 1);

        for (int i = 0; i < be.assemblyLength; i++) {
            int valid = be.isValidBogeyOffset(i) ? colorWhenValid : -1;

            for (int j : be.bogeyLocations)
                if (i == j) {
                    valid = colorWhenCarriage;
                    break;
                }

            if (valid != -1 && assemblyOverlay != null) {
                int lightColor = class_761.method_23794(level, currentPos);
                SuperByteBuffer sbb = CachedBuffers.partial(assemblyOverlay, trackState);
                sbb.color(valid);
                sbb.light(lightColor);
                sbb.renderInto(ms, vb);
            }
            ms.method_46416(0, 0, 1);
            currentPos.method_10098(direction);
        }

        ms.method_22909();
    }

    public static void renderFlag(
        PartialModel flag,
        StationBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        if (!be.resolveFlagAngle())
            return;
        SuperByteBuffer flagBB = CachedBuffers.partial(flag, be.method_11010());
        transformFlag(flagBB, be, partialTicks, be.flagYRot, be.flagFlipped);
        flagBB.translate(0.5f / 16, 0, 0).rotateYDegrees(be.flagFlipped ? 0 : 180).translate(-0.5f / 16, 0, 0).light(light)
            .renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
    }

    public static void transformFlag(Transform<?> flag, StationBlockEntity be, float partialTicks, int yRot, boolean flipped) {
        float value = be.flag.getValue(partialTicks);
        float progress = (float) (Math.pow(Math.min(value * 5, 1), 2));
        if (be.flag.getChaseTarget() > 0 && !be.flag.settled() && progress == 1) {
            float wiggleProgress = (value - .2f) / .8f;
            progress += (Math.sin(wiggleProgress * (2 * class_3532.field_29844) * 4) / 8f) / Math.max(1, 8f * wiggleProgress);
        }

        float nudge = 1 / 512f;
        flag.center().rotateYDegrees(yRot).translate(nudge, 9.5f / 16f, flipped ? 14f / 16f - nudge : 2f / 16f + nudge).uncenter()
            .rotateXDegrees((flipped ? 1 : -1) * (progress * 90 + 270));
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    @Override
    public int method_33893() {
        return 96 * 2;
    }

}
