package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.Affine;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class StandardTrackBlockRenderer implements TrackBlockRenderer {

    @Override
    public PartialModel prepareAssemblyOverlay(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction, class_4587 ms) {
        TransformStack.of(ms).rotateCentered(AngleHelper.rad(AngleHelper.horizontalAngle(direction)), class_2350.field_11036);
        return AllPartialModels.TRACK_ASSEMBLING_OVERLAY;
    }

    @Override
    public <Self extends Affine<Self>> PartialModel prepareTrackOverlay(
        Affine<Self> affine,
        class_1922 world,
        class_2338 pos,
        class_2680 state,
        BezierTrackPointLocation bezierPoint,
        class_2352 direction,
        TrackTargetingBehaviour.RenderedTrackOverlayType type
    ) {
        class_243 axis = null;
        class_243 diff = null;
        class_243 normal = null;
        class_243 offset = null;

        if (bezierPoint != null && world.method_8321(pos) instanceof TrackBlockEntity trackBE) {
            BezierConnection bc = trackBE.getConnections().get(bezierPoint.curveTarget());
            if (bc != null) {
                double length = class_3532.method_15357(bc.getLength() * 2);
                int seg = bezierPoint.segment() + 1;
                double t = seg / length;
                double tpre = (seg - 1) / length;
                double tpost = (seg + 1) / length;

                offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).method_1020(bc.getPosition(tpre)).method_1029();

                affine.translate(offset.method_1020(class_243.method_24955(pos)));
                affine.translate(0, -4 / 16f, 0);
            } else
                return null;
        }

        if (normal == null) {
            axis = state.method_11654(TrackBlock.SHAPE).getAxes().get(0);
            diff = axis.method_1021(direction.method_10181()).method_1029();
            normal = state.method_11654(TrackBlock.SHAPE).getNormal();
        }

        class_243 angles = TrackRenderer.getModelAngles(normal, diff);

        affine.center().rotateY((float) angles.field_1351).rotateX((float) angles.field_1352).uncenter();

        if (axis != null)
            affine.translate(0, axis.field_1351 != 0 ? 7 / 16f : 0, axis.field_1351 != 0 ? direction.method_10181() * 2.5f / 16f : 0);
        else {
            affine.translate(0, 4 / 16f, 0);
            if (direction == class_2352.field_11060)
                affine.rotateCentered(class_3532.field_29844, class_2350.field_11036);
        }

        if (bezierPoint == null && world.method_8321(pos) instanceof TrackBlockEntity trackTE && trackTE.isTilted()) {
            double yOffset = 0;
            for (BezierConnection bc : trackTE.getConnections().values())
                yOffset += bc.starts.getFirst().field_1351 - pos.method_10264();
            affine.center().rotateXDegrees((float) (-direction.method_10181() * trackTE.tilt.smoothingAngle.get())).uncenter().translate(0, yOffset / 2, 0);
        }

        return switch (type) {
            case DUAL_SIGNAL -> AllPartialModels.TRACK_SIGNAL_DUAL_OVERLAY;
            case OBSERVER -> AllPartialModels.TRACK_OBSERVER_OVERLAY;
            case SIGNAL -> AllPartialModels.TRACK_SIGNAL_OVERLAY;
            case STATION -> AllPartialModels.TRACK_STATION_OVERLAY;
        };
    }
}
