package com.zurrtum.create.client.flywheel.api.visualization;

import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.api.internal.FlwApiLink;
import com.zurrtum.create.client.flywheel.api.visual.Effect;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.SortedSet;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3191;

@ApiStatus.NonExtendable
public interface VisualizationManager {
    static boolean supportsVisualization(@Nullable class_1936 level) {
        return FlwApiLink.INSTANCE.supportsVisualization(level);
    }

    static @Nullable VisualizationManager get(@Nullable class_1936 level) {
        return FlwApiLink.INSTANCE.getVisualizationManager(level);
    }

    static VisualizationManager getOrThrow(@Nullable class_1936 level) {
        return FlwApiLink.INSTANCE.getVisualizationManagerOrThrow(level);
    }

    class_2382 renderOrigin();

    VisualManager<class_2586> blockEntities();

    VisualManager<class_1297> entities();

    VisualManager<Effect> effects();

    RenderDispatcher renderDispatcher();

    @ApiStatus.NonExtendable
    public interface RenderDispatcher {
        void onStartLevelRender(RenderContext var1);

        void afterEntities(RenderContext var1);

        void beforeCrumbling(RenderContext var1, Long2ObjectMap<SortedSet<class_3191>> var2);
    }
}
