package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.client.model.LayerBakedModel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10801;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_9801;

final class BakedModelBufferer {
    static final class_11515[] CHUNK_LAYERS = class_11515.values();
    static final Map<class_11515, Integer> CHUNK_LAYERS_INDEX = new HashMap<>();
    static final int CHUNK_LAYER_AMOUNT = CHUNK_LAYERS.length;

    static {
        for (int layerIndex = 0; layerIndex < CHUNK_LAYER_AMOUNT; layerIndex++) {
            CHUNK_LAYERS_INDEX.put(CHUNK_LAYERS[layerIndex], layerIndex);
        }
    }

    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private BakedModelBufferer() {
    }

    public static void bufferModel(
        class_10801 model,
        class_2338 pos,
        class_1920 level,
        class_2680 state,
        @Nullable class_4587 poseStack,
        ResultConsumer resultConsumer
    ) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        MeshEmitter[] emitters = objects.emitters;
        class_778 blockRenderer = class_310.method_1551().method_1541().method_3350();
        class_11515 renderType = LayerBakedModel.getBlockRenderLayer(model, () -> class_4696.method_23679(state));
        MeshEmitter emitter = emitters[CHUNK_LAYERS_INDEX.get(renderType)];

        emitter.prepare(resultConsumer);
        poseStack.method_22903();
        blockRenderer.method_3374(level, List.of(model), state, pos, poseStack, emitter, false, class_4608.field_21444);
        poseStack.method_22909();

        emitter.end();
    }

    public static void bufferModel(
        class_1087 model,
        class_2338 pos,
        class_1920 level,
        class_2680 state,
        @Nullable class_4587 poseStack,
        ResultConsumer resultConsumer
    ) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        class_5819 random = objects.random;
        MeshEmitter[] emitters = objects.emitters;
        class_778 blockRenderer = class_310.method_1551().method_1541().method_3350();
        long seed = state.method_26190(pos);
        random.method_43052(seed);
        List<class_10889> parts = model.method_68512(random);
        int size = parts.size();

        Supplier<class_11515> defaultLayer = Suppliers.memoize(() -> class_4696.method_23679(state));
        class_11515 firstLayer = LayerBakedModel.getBlockRenderLayer(parts.getFirst(), defaultLayer);
        if (size == 1) {
            MeshEmitter emitter = emitters[CHUNK_LAYERS_INDEX.get(firstLayer)];
            emitter.prepare(resultConsumer);
            poseStack.method_22903();
            blockRenderer.method_3374(level, parts, state, pos, poseStack, emitter, false, class_4608.field_21444);
            poseStack.method_22909();
            emitter.end();
        } else {
            class_11515[] renderLayers = new class_11515[size];
            renderLayers[0] = firstLayer;
            boolean simple = true;
            for (int i = 1; i < size; i++) {
                renderLayers[i] = LayerBakedModel.getBlockRenderLayer(parts.get(i), defaultLayer);
                if (simple && renderLayers[i] != firstLayer) {
                    simple = false;
                }
            }
            if (simple) {
                MeshEmitter emitter = emitters[CHUNK_LAYERS_INDEX.get(firstLayer)];
                emitter.prepare(resultConsumer);
                poseStack.method_22903();
                blockRenderer.method_3374(level, parts, state, pos, poseStack, emitter, false, class_4608.field_21444);
                poseStack.method_22909();
                emitter.end();
            } else {
                boolean[] pending = new boolean[size];
                for (int i = 0; i < size; i++) {
                    int index = CHUNK_LAYERS_INDEX.get(renderLayers[i]);
                    MeshEmitter emitter = emitters[index];
                    if (!pending[index]) {
                        pending[index] = true;
                        emitter.prepare(resultConsumer);
                    }
                    poseStack.method_22903();
                    blockRenderer.method_3374(level, List.of(parts.get(i)), state, pos, poseStack, emitter, false, class_4608.field_21444);
                    poseStack.method_22909();
                }
                for (int i = 0; i < size; i++) {
                    if (pending[i]) {
                        emitters[i].end();
                    }
                }
            }
        }
    }

    public static void bufferBlocks(
        Iterator<class_2338> posIterator,
        class_1920 level,
        @Nullable class_4587 poseStack,
        boolean renderFluids,
        ResultConsumer resultConsumer
    ) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        class_5819 random = objects.random;
        MeshEmitter[] emitters = objects.emitters;
        TransformingVertexConsumer transformingWrapper = objects.transformingWrapper;

        for (MeshEmitter emitter : emitters) {
            emitter.prepare(resultConsumer);
        }

        class_776 renderDispatcher = class_310.method_1551().method_1541();

        class_778 blockRenderer = renderDispatcher.method_3350();
        class_778.method_20544();

        while (posIterator.hasNext()) {
            class_2338 pos = posIterator.next();
            class_2680 state = level.method_8320(pos);

            if (renderFluids) {
                class_3610 fluidState = state.method_26227();

                if (!fluidState.method_15769()) {
                    class_11515 renderType = class_4696.method_23680(fluidState);
                    transformingWrapper.prepare(emitters[CHUNK_LAYERS_INDEX.get(renderType)].unwrap(true), poseStack);

                    poseStack.method_22903();
                    poseStack.method_46416(pos.method_10263() - (pos.method_10263() & 0xF), pos.method_10264() - (pos.method_10264() & 0xF), pos.method_10260() - (pos.method_10260() & 0xF));
                    renderDispatcher.method_3352(pos, level, transformingWrapper, state, fluidState);
                    poseStack.method_22909();
                }
            }

            if (state.method_26217() == class_2464.field_11458) {
                long seed = state.method_26190(pos);
                class_1087 model = renderDispatcher.method_3349(state);
                random.method_43052(seed);
                class_11515 renderType = class_4696.method_23679(state);
                int layerIndex = CHUNK_LAYERS_INDEX.get(renderType);
                poseStack.method_22903();
                poseStack.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
                List<class_10889> parts = new ObjectArrayList<>();
                if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
                    wrapper.addPartsWithInfo(level, pos, state, random, parts);
                } else {
                    model.method_68513(random, parts);
                }
                blockRenderer.method_3374(level, parts, state, pos, poseStack, emitters[layerIndex], true, class_4608.field_21444);
                poseStack.method_22909();
            }
        }

        class_778.method_20545();
        transformingWrapper.clear();

        for (MeshEmitter emitter : emitters) {
            emitter.end();
        }
    }

    public interface ResultConsumer {
        void accept(class_11515 renderType, boolean shaded, class_9801 data);
    }

    private static class ThreadLocalObjects {
        public final class_4587 identityPoseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();

        public final MeshEmitter[] emitters = new MeshEmitter[CHUNK_LAYER_AMOUNT];
        public final TransformingVertexConsumer transformingWrapper = new TransformingVertexConsumer();

        {
            for (int layerIndex = 0; layerIndex < CHUNK_LAYER_AMOUNT; layerIndex++) {
                class_11515 renderType = CHUNK_LAYERS[layerIndex];
                emitters[layerIndex] = new MeshEmitter(renderType);
            }
        }
    }
}
