package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.collect.MapMaker;
import org.jetbrains.annotations.UnknownNullability;

import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_10801;
import net.minecraft.class_2960;

/**
 * A helper class for loading and accessing JSON models not directly used by any blocks or items.
 * <br>
 * Creating a PartialModel will make Minecraft automatically load the associated modelLocation.
 * <br>
 * Once Minecraft has finished baking all models, all PartialModels will have their bakedModel fields populated.
 */
public final class PartialModel {
    static final ConcurrentMap<class_2960, PartialModel> ALL = new MapMaker().weakValues().makeMap();
    static boolean populateOnInit = false;

    private final class_2960 modelLocation;
    @UnknownNullability
    class_10801 bakedModel;

    private PartialModel(class_2960 modelLocation) {
        this.modelLocation = modelLocation;
        if (populateOnInit) {
            throw new RuntimeException("Loading new models after resolve models is not supported");
        }
    }

    public static PartialModel of(class_2960 modelLocation) {
        return ALL.computeIfAbsent(modelLocation, PartialModel::new);
    }

    @UnknownNullability
    public class_10801 get() {
        return bakedModel;
    }

    public class_2960 modelLocation() {
        return modelLocation;
    }
}
