package com.zurrtum.create.client.flywheel.lib.visual;

import com.zurrtum.create.client.flywheel.api.visual.*;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import net.minecraft.class_1297;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.FrustumIntersection;
import org.joml.Vector3f;

/**
 * The layer between an {@link class_1297} and the Flywheel backend.
 * <br>
 * <br> There are a few additional features that overriding classes can opt in to:
 * <ul>
 *     <li>{@link DynamicVisual}</li>
 *     <li>{@link TickableVisual}</li>
 *     <li>{@link LightUpdatedVisual}</li>
 *     <li>{@link ShaderLightVisual}</li>
 * </ul>
 * See the interfaces' documentation for more information about each one.
 *
 * <br> Implementing one or more of these will give an {@link AbstractEntityVisual} access
 * to more interesting and regular points within a tick or a frame.
 *
 * @param <T> The type of {@link class_1297}.
 */
public abstract class AbstractEntityVisual<T extends class_1297> extends AbstractVisual implements EntityVisual<T> {
    protected final T entity;
    protected final EntityVisibilityTester visibilityTester;

    public AbstractEntityVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity.method_37908(), partialTick);
        this.entity = entity;
        visibilityTester = new EntityVisibilityTester(entity, ctx.renderOrigin(), 1.5f);
    }

    /**
     * Calculate the distance squared between this visual and the given <em>level</em> position.
     *
     * @param x The x coordinate.
     * @param y The y coordinate.
     * @param z The z coordinate.
     * @return The distance squared between this visual and the given position.
     */
    public double distanceSquared(double x, double y, double z) {
        return entity.method_5649(x, y, z);
    }

    /**
     * In order to accommodate for floating point precision errors at high coordinates,
     * {@link VisualizationManager}s are allowed to arbitrarily adjust the origin, and
     * shift the level matrix provided as a shader uniform accordingly.
     *
     * @return The position this visual should be rendered at to appear in the correct location.
     */
    public Vector3f getVisualPosition() {
        class_243 pos = entity.method_19538();
        var renderOrigin = renderOrigin();
        return new Vector3f((float) (pos.field_1352 - renderOrigin.method_10263()), (float) (pos.field_1351 - renderOrigin.method_10264()), (float) (pos.field_1350 - renderOrigin.method_10260()));
    }

    /**
     * In order to accommodate for floating point precision errors at high coordinates,
     * {@link VisualizationManager}s are allowed to arbitrarily adjust the origin, and
     * shift the level matrix provided as a shader uniform accordingly.
     *
     * @return The position this visual should be rendered at to appear in the correct location.
     */
    public Vector3f getVisualPosition(float partialTick) {
        class_243 pos = entity.method_19538();
        var renderOrigin = renderOrigin();
        return new Vector3f(
            (float) (class_3532.method_16436(partialTick, entity.field_6038, pos.field_1352) - renderOrigin.method_10263()),
            (float) (class_3532.method_16436(partialTick, entity.field_5971, pos.field_1351) - renderOrigin.method_10264()),
            (float) (class_3532.method_16436(partialTick, entity.field_5989, pos.field_1350) - renderOrigin.method_10260())
        );
    }

    public boolean isVisible(FrustumIntersection frustum) {
        return !class_310.method_1551().method_1561().method_3953(entity).method_62406(entity) || visibilityTester.check(frustum);
    }

    protected int computePackedLight(float partialTick) {
        class_2338 pos = class_2338.method_49638(entity.method_31166(partialTick));
        int blockLight = entity.method_5809() ? 15 : level.method_8314(class_1944.field_9282, pos);
        int skyLight = level.method_8314(class_1944.field_9284, pos);
        return class_765.method_23687(blockLight, skyLight);
    }

    protected void relight(float partialTick, @Nullable FlatLit... instances) {
        FlatLit.relight(computePackedLight(partialTick), instances);
    }
}
