package com.zurrtum.create.client.foundation.block.connected;

import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;

public class CTSpriteShiftEntry extends SpriteShiftEntry {

    protected final CTType type;

    public CTSpriteShiftEntry(CTType type) {
        this.type = type;
    }

    public CTType getType() {
        return type;
    }

    public float getTargetU(float localU, int index) {
        float uOffset = (index % type.getSheetSize());
        return getTarget().method_4580((getUnInterpolatedU(getOriginal(), localU) + uOffset) / ((float) type.getSheetSize()));
    }

    public float getTargetV(float localV, int index) {
        float vOffset = (index / type.getSheetSize());
        return getTarget().method_4570((getUnInterpolatedV(getOriginal(), localV) + vOffset) / ((float) type.getSheetSize()));
    }

}
