package com.zurrtum.create.client.foundation.blockEntity.behaviour.audio;

import com.zurrtum.create.client.foundation.sound.SoundScapes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import net.minecraft.class_2248;
import net.minecraft.class_3532;

public class KineticAudioBehaviour<T extends KineticBlockEntity> extends AudioBehaviour<T> {
    public KineticAudioBehaviour(T be) {
        super(be);
    }

    @Override
    public void tickAudio() {
        float componentSpeed = Math.abs(blockEntity.getSpeed());
        if (componentSpeed == 0)
            return;
        float pitch = class_3532.method_15363((componentSpeed / 256f) + .45f, .85f, 1f);

        if (blockEntity.isNoisy()) {
            SoundScapes.play(SoundScapes.AmbienceGroup.KINETIC, blockEntity.method_11016(), pitch);
        }

        class_2248 block = blockEntity.method_11010().method_26204();
        if (ICogWheel.isSmallCog(block) || ICogWheel.isLargeCog(block) || block instanceof GearboxBlock) {
            SoundScapes.play(SoundScapes.AmbienceGroup.COG, blockEntity.method_11016(), pitch);
        }
    }
}
