package com.zurrtum.create.client.foundation.gui.render;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import java.util.List;
import net.minecraft.class_10889;
import net.minecraft.class_11239;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_776;
import net.minecraft.class_7833;

public class MixingBasinRenderer extends class_11239<MixingBasinRenderState> {
    public MixingBasinRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    protected void render(MixingBasinRenderState state, class_4587 matrices) {
        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22905(1, 1, -1);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
        matrices.method_46416(-0.5f, -1.8f, -0.5f);
        matrices.method_22905(1, -1, 1);

        class_2680 blockState;
        List<class_10889> parts;
        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = field_59933.getBuffer(class_4722.method_24074());
        float time = AnimationTickHolder.getRenderTime();
        float angle = getCurrentAngle(time);

        blockState = AllBlocks.MECHANICAL_MIXER.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);

        blockState = class_2246.field_10124.method_9564();
        world.blockState(blockState);
        matrices.method_22903();
        parts = List.of(AllPartialModels.SHAFTLESS_COGWHEEL.get());
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(angle * 2));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        matrices.method_22903();
        matrices.method_46416(0, getAnimatedHeadOffset(time), 0);
        parts = List.of(AllPartialModels.MECHANICAL_MIXER_POLE.get());
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(angle * 4));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        parts = List.of(AllPartialModels.MECHANICAL_MIXER_HEAD.get());
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        matrices.method_46416(0, -1.65f, 0);
        blockState = AllBlocks.BASIN.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
    }

    private static float getCurrentAngle(float time) {
        return (time * 4f) % 360;
    }

    private static float getAnimatedHeadOffset(float time) {
        return -(((class_3532.method_15374(time / 32f) + 1) / 5) + .5f);
    }

    @Override
    protected String method_70906() {
        return "Mixing Basin";
    }

    @Override
    public Class<MixingBasinRenderState> method_70903() {
        return MixingBasinRenderState.class;
    }
}