package com.zurrtum.create.client.foundation.gui.render;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import java.util.List;
import net.minecraft.class_10889;
import net.minecraft.class_11239;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_776;
import net.minecraft.class_7833;

public class PressBasinRenderer extends class_11239<PressBasinRenderState> {
    public PressBasinRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    protected void render(PressBasinRenderState state, class_4587 matrices) {
        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22905(1, 1, -1);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
        matrices.method_46416(-0.5f, -1.8f, -0.5f);
        matrices.method_22905(1, -1, 1);

        class_2680 blockState;
        List<class_10889> parts;
        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = field_59933.getBuffer(class_4722.method_24074());
        float time = AnimationTickHolder.getRenderTime();

        blockState = AllBlocks.MECHANICAL_PRESS.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);

        matrices.method_22903();
        blockState = AllBlocks.SHAFT.method_9564().method_11657(class_2741.field_12496, class_2351.field_11051);
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(getShaftAngle(time)));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        matrices.method_22903();
        blockState = class_2246.field_10124.method_9564();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.MECHANICAL_PRESS_HEAD.get());
        matrices.method_46416(0, getAnimatedHeadOffset(time), 0);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        matrices.method_46416(0, -1.65f, 0);
        blockState = AllBlocks.BASIN.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
    }

    private static float getShaftAngle(float time) {
        return (time * 4f) % 360;
    }

    private static float getAnimatedHeadOffset(float time) {
        float cycle = time % 30;
        if (cycle < 10) {
            float progress = cycle / 10;
            return -(progress * progress * progress);
        }
        if (cycle < 15)
            return -1;
        if (cycle < 20)
            return -1 + (1 - ((20 - cycle) / 5));
        return 0;
    }

    @Override
    protected String method_70906() {
        return "Press Basin";
    }

    @Override
    public Class<PressBasinRenderState> method_70903() {
        return PressBasinRenderState.class;
    }
}