package com.zurrtum.create.client.foundation.render;

import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.client.render.*;

/**
 * Taken from EntityRendererManager
 */
public class ShadowRenderHelper {

    public static final class_1921 SHADOW_LAYER = class_1921.method_23588(class_2960.method_60654("textures/misc/shadow.png"));

    public static void renderShadow(class_4587 matrixStack, class_4597 buffer, float opacity, float radius) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        class_4588 builder = buffer.getBuffer(SHADOW_LAYER);

        opacity /= 2;
        shadowVertex(entry, builder, opacity, -1 * radius, 0, -1 * radius, 0, 0);
        shadowVertex(entry, builder, opacity, -1 * radius, 0, 1 * radius, 0, 1);
        shadowVertex(entry, builder, opacity, 1 * radius, 0, 1 * radius, 1, 1);
        shadowVertex(entry, builder, opacity, 1 * radius, 0, -1 * radius, 1, 0);
    }

    public static void renderShadow(class_4587 matrixStack, class_4597 buffer, class_4538 world, class_243 pos, float opacity, float radius) {
        float f = radius;

        double d2 = pos.method_10216();
        double d0 = pos.method_10214();
        double d1 = pos.method_10215();
        int i = class_3532.method_15357(d2 - (double) f);
        int j = class_3532.method_15357(d2 + (double) f);
        int k = class_3532.method_15357(d0 - (double) f);
        int l = class_3532.method_15357(d0);
        int i1 = class_3532.method_15357(d1 - (double) f);
        int j1 = class_3532.method_15357(d1 + (double) f);
        class_4587.class_4665 entry = matrixStack.method_23760();
        class_4588 builder = buffer.getBuffer(SHADOW_LAYER);

        for (class_2338 blockpos : class_2338.method_10097(new class_2338(i, k, i1), new class_2338(j, l, j1))) {
            renderBlockShadow(entry, builder, world, blockpos, d2, d0, d1, f, opacity);
        }
    }

    private static void renderBlockShadow(
        class_4587.class_4665 entry,
        class_4588 builder,
        class_4538 world,
        class_2338 pos,
        double x,
        double y,
        double z,
        float radius,
        float opacity
    ) {
        class_2338 blockpos = pos.method_10074();
        class_2680 blockstate = world.method_8320(blockpos);
        if (blockstate.method_26217() != class_2464.field_11455 && world.method_22339(pos) > 3) {
            if (blockstate.method_26234(world, blockpos)) {
                class_265 voxelshape = blockstate.method_26218(world, pos.method_10074());
                if (!voxelshape.method_1110()) {
                    float brightness = class_765.method_23284(world.method_8597(), world.method_22339(pos));
                    float f = (float) ((opacity - (y - pos.method_10264()) / 2.0D) * 0.5D * brightness);
                    if (f >= 0.0F) {
                        if (f > 1.0F) {
                            f = 1.0F;
                        }

                        class_238 AABB = voxelshape.method_1107();
                        double d0 = (double) pos.method_10263() + AABB.field_1323;
                        double d1 = (double) pos.method_10263() + AABB.field_1320;
                        double d2 = (double) pos.method_10264() + AABB.field_1322;
                        double d3 = (double) pos.method_10260() + AABB.field_1321;
                        double d4 = (double) pos.method_10260() + AABB.field_1324;
                        float f1 = (float) (d0 - x);
                        float f2 = (float) (d1 - x);
                        float f3 = (float) (d2 - y + 0.015625D);
                        float f4 = (float) (d3 - z);
                        float f5 = (float) (d4 - z);
                        float f6 = -f1 / 2.0F / radius + 0.5F;
                        float f7 = -f2 / 2.0F / radius + 0.5F;
                        float f8 = -f4 / 2.0F / radius + 0.5F;
                        float f9 = -f5 / 2.0F / radius + 0.5F;
                        shadowVertex(entry, builder, f, f1, f3, f4, f6, f8);
                        shadowVertex(entry, builder, f, f1, f3, f5, f6, f9);
                        shadowVertex(entry, builder, f, f2, f3, f5, f7, f9);
                        shadowVertex(entry, builder, f, f2, f3, f4, f7, f8);
                    }
                }
            }
        }
    }

    private static void shadowVertex(class_4587.class_4665 entry, class_4588 builder, float alpha, float x, float y, float z, float u, float v) {
        builder.method_22918(entry.method_23761(), x, y, z).method_22915(1.0F, 1.0F, 1.0F, alpha).method_22913(u, v).method_22922(class_4608.field_21444)
            .method_60803(class_765.field_32767).method_60831(entry.method_56822(), 0.0F, 1.0F, 0.0F);
    }

}
