package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.fan.AirCurrent;
import com.zurrtum.create.content.kinetics.fan.IAirCurrentSource;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.infrastructure.particle.AirFlowParticleData;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_708;
import net.minecraft.class_761;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AirFlowParticle extends class_708 {

    private final IAirCurrentSource source;
    private final Access access = new Access();

    protected AirFlowParticle(class_638 world, IAirCurrentSource source, double x, double y, double z, class_4002 sprite) {
        super(world, x, y, z, sprite, world.field_9229.method_43057() * .5f);
        this.source = source;
        this.field_17867 *= 0.75F;
        this.field_3847 = 40;
        field_3862 = false;
        selectSprite(7);
        class_243 offset = VecHelper.offsetRandomly(class_243.field_1353, field_3840, .25f);
        this.method_3063(x + offset.field_1352, y + offset.field_1351, z + offset.field_1350);
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        method_3093(0xEEEEEE);
        method_3083(.25f);
    }

    @NotNull
    public class_3999 getRenderType() {
        return class_3999.field_17829;
    }

    @Override
    public void method_3070() {
        if (source == null || source.isSourceRemoved()) {
            method_3085();
            return;
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            method_3085();
        } else {
            AirCurrent airCurrent = source.getAirCurrent();
            if (airCurrent == null || !airCurrent.bounds.method_1014(.25f).method_1008(field_3874, field_3854, field_3871)) {
                method_3085();
                return;
            }

            class_243 directionVec = class_243.method_24954(airCurrent.direction.method_62675());
            class_243 motion = directionVec.method_1021(1 / 8f);
            if (!source.getAirCurrent().pushing)
                motion = motion.method_1021(-1);

            double distance = new class_243(field_3874, field_3854, field_3871).method_1020(VecHelper.getCenterOf(source.getAirCurrentPos())).method_18806(directionVec).method_1033() - .5f;
            if (distance > airCurrent.maxDistance + 1 || distance < -.25f) {
                method_3085();
                return;
            }
            motion = motion.method_1021(airCurrent.maxDistance - (distance - 1f)).method_1021(.5f);

            FanProcessingType type = getType(distance);
            if (type == null) {
                method_3093(0xEEEEEE);
                method_3083(.25f);
                selectSprite((int) class_3532.method_15350((distance / airCurrent.maxDistance) * 8 + field_3840.method_43048(4), 0, 7));
            } else {
                type.morphAirFlow(access, field_3840);
                selectSprite(field_3840.method_43048(3));
            }

            field_3852 = motion.field_1352;
            field_3869 = motion.field_1351;
            field_3850 = motion.field_1350;

            if (this.field_3845) {
                this.field_3852 *= 0.7;
                this.field_3850 *= 0.7;
            }
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        }
    }

    @Nullable
    private FanProcessingType getType(double distance) {
        if (source.getAirCurrent() == null)
            return null;
        return source.getAirCurrent().getTypeAt((float) distance);
    }

    @Override
    public int method_3068(float partialTick) {
        class_2338 blockpos = class_2338.method_49637(this.field_3874, this.field_3854, this.field_3871);
        return this.field_3851.method_8477(blockpos) ? class_761.method_23794(field_3851, blockpos) : 0;
    }

    private void selectSprite(int index) {
        method_18141(field_17866.method_18138(index, 8));
    }

    public static class Factory implements class_707<AirFlowParticleData> {
        private final class_4002 spriteSet;

        public Factory(class_4002 animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        @Override
        public class_703 createParticle(
            AirFlowParticleData data,
            class_638 worldIn,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
        ) {
            class_2586 be = worldIn.method_8321(new class_2338(data.posX(), data.posY(), data.posZ()));
            if (!(be instanceof IAirCurrentSource))
                be = null;
            return new AirFlowParticle(worldIn, (IAirCurrentSource) be, x, y, z, this.spriteSet);
        }
    }

    private class Access implements FanProcessingType.AirFlowParticleAccess {
        @Override
        public void setColor(int color) {
            AirFlowParticle.this.method_3093(color);
        }

        @Override
        public void setAlpha(float alpha) {
            AirFlowParticle.this.method_3083(alpha);
        }

        @Override
        public void spawnExtraParticle(class_2394 options, float speedMultiplier) {
            field_3851.method_8406(options, field_3874, field_3854, field_3871, field_3852 * speedMultiplier, field_3869 * speedMultiplier, field_3850 * speedMultiplier);
        }
    }

}