package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.zurrtum.create.content.fluids.pump.PumpBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock.HeatLevel;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class SteamScenes {

    public static void whistle(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("steam_whistle", "Setting up Steam Whistles");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();

        Selection tank = util.select().fromTo(3, 1, 2, 3, 2, 2);
        Selection boiler = util.select().fromTo(2, 2, 2, 2, 3, 2);
        class_2338 leverPos = util.grid().at(1, 3, 2);
        Selection lever = util.select().position(leverPos);
        Selection whistleArea = util.select().fromTo(2, 3, 1, 2, 7, 1);
        class_2338 whistlePos = util.grid().at(2, 3, 1);
        Selection campfire = util.select().position(2, 1, 2);

        scene.idle(15);
        ElementLink<WorldSectionElement> tankElement = scene.world().showIndependentSection(tank, class_2350.field_11033);
        scene.world().moveSection(tankElement, util.vector().of(-1, 0, 0), 0);
        scene.idle(10);
        ElementLink<WorldSectionElement> whistleElement = scene.world().showIndependentSection(whistleArea, class_2350.field_11035);
        scene.world().moveSection(whistleElement, util.vector().of(0, -1, 0), 0);
        scene.idle(15);
        scene.world().moveSection(tankElement, util.vector().of(0, -1000, 0), 0);
        scene.world().hideIndependentSection(tankElement, null);
        ElementLink<WorldSectionElement> boilerElement = scene.world().showIndependentSectionImmediately(boiler);
        scene.world().moveSection(boilerElement, util.vector().of(0, -1, 0), 0);
        scene.effects().indicateSuccess(util.grid().at(2, 1, 2));
        scene.idle(25);

        scene.overlay().showText(70).attachKeyFrame().text("Steam Whistles can be placed on a Fluid Tank")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043)).placeNearTarget();
        scene.idle(60);

        scene.world().moveSection(boilerElement, util.vector().of(0, 1, 0), 15);
        scene.world().moveSection(whistleElement, util.vector().of(0, 1, 0), 15);
        scene.idle(10);
        scene.world().showSection(campfire, class_2350.field_11043);
        scene.idle(15);

        scene.overlay().showText(50).attachKeyFrame().text("If the tank receives sufficient heat...")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 1, 2), class_2350.field_11039)).placeNearTarget();
        scene.idle(40);

        scene.world().showSection(lever, class_2350.field_11033);
        scene.idle(20);
        scene.world().toggleRedstonePower(whistleArea);
        scene.world().toggleRedstonePower(lever);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(10);

        scene.overlay().showText(70).attachKeyFrame().text("...the Whistle will play a note when activated")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11043)).placeNearTarget();

        scene.idle(10);
        scene.world().toggleRedstonePower(whistleArea);
        scene.world().toggleRedstonePower(lever);
        scene.idle(20);
        scene.world().toggleRedstonePower(whistleArea);
        scene.world().toggleRedstonePower(lever);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(20);
        scene.world().toggleRedstonePower(whistleArea);
        scene.world().toggleRedstonePower(lever);
        scene.idle(40);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11034), Pointing.RIGHT, 50)
            .withItem(AllItems.STEAM_WHISTLE.method_7854()).rightClick();
        scene.idle(6);
        class_2680 extension = AllBlocks.STEAM_WHISTLE_EXTENSION.method_9564();
        scene.world().setBlock(whistlePos.method_10084(), extension, false);
        scene.idle(20);

        scene.overlay().showText(70).attachKeyFrame().text("Use a Whistle item on the block to lower its pitch")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11043)).placeNearTarget();

        scene.idle(40);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11034), Pointing.RIGHT, 2)
            .withItem(AllItems.STEAM_WHISTLE.method_7854()).rightClick();
        scene.idle(6);
        scene.world().cycleBlockProperty(whistlePos.method_10084(), WhistleExtenderBlock.SHAPE);
        scene.idle(4);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11034), Pointing.RIGHT, 2)
            .withItem(AllItems.STEAM_WHISTLE.method_7854()).rightClick();
        scene.idle(6);
        scene.world().setBlock(whistlePos.method_10086(2), extension, false);
        scene.world().cycleBlockProperty(whistlePos.method_10084(), WhistleExtenderBlock.SHAPE);
        scene.idle(4);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11034), Pointing.RIGHT, 2)
            .withItem(AllItems.STEAM_WHISTLE.method_7854()).rightClick();
        scene.idle(6);
        scene.world().cycleBlockProperty(whistlePos.method_10086(2), WhistleExtenderBlock.SHAPE);
        scene.idle(4);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11034), Pointing.RIGHT, 2)
            .withItem(AllItems.STEAM_WHISTLE.method_7854()).rightClick();
        scene.idle(6);
        scene.world().cycleBlockProperty(whistlePos.method_10086(2), WhistleExtenderBlock.SHAPE);
        scene.world().setBlock(whistlePos.method_10086(3), extension, false);
        scene.idle(20);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11034), Pointing.RIGHT, 50)
            .withItem(AllItems.WRENCH.method_7854()).rightClick();
        scene.idle(6);
        for (int i = 0; i < 4; i++) {
            scene.world().cycleBlockProperty(whistlePos.method_10086(i), WhistleBlock.SIZE);
            scene.idle(1);
        }
        scene.idle(20);

        scene.overlay().showText(70).attachKeyFrame().text("Cycle between three different octaves using a Wrench")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11043)).placeNearTarget();

        scene.idle(40);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11034), Pointing.RIGHT, 4)
            .withItem(AllItems.WRENCH.method_7854()).rightClick();
        scene.idle(6);
        for (int i = 0; i < 4; i++) {
            scene.world().cycleBlockProperty(whistlePos.method_10086(i), WhistleBlock.SIZE);
            scene.idle(1);
        }

        scene.idle(20);
        scene.world().toggleRedstonePower(whistleArea);
        scene.world().toggleRedstonePower(lever);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(20);
        scene.world().toggleRedstonePower(whistleArea);
        scene.world().toggleRedstonePower(lever);
        scene.idle(20);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11033), Pointing.UP, 80)
            .withItem(AllItems.GOGGLES.method_7854());
        scene.idle(6);

        scene.overlay().showText(70).attachKeyFrame().colored(PonderPalette.BLUE)
            .text("Engineer's Goggles can help to find out the current pitch of a Whistle")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11043)).placeNearTarget();
        scene.idle(40);
    }

    public static void engine(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("steam_engine", "Setting up Steam Engines");
        scene.configureBasePlate(0, 0, 7);
        scene.setSceneOffsetY(-1);
        scene.scaleSceneView(.9f);
        scene.showBasePlate();

        Selection fakeGround = util.select().fromTo(4, 0, 0, 2, 0, 0);
        ElementLink<WorldSectionElement> fakeGroundElement = scene.world().showIndependentSection(fakeGround, class_2350.field_11036);
        scene.world().moveSection(fakeGroundElement, util.vector().of(1, 0, 1), 0);

        Selection campfires = util.select().fromTo(4, 1, 4, 5, 1, 3);
        Selection burners = util.select().fromTo(3, 1, 3, 2, 1, 4);

        Selection tank = util.select().fromTo(4, 2, 3, 5, 2, 4);
        Selection boiler1 = util.select().fromTo(5, 4, 2, 4, 4, 1);
        Selection boiler2 = util.select().fromTo(5, 7, 6, 4, 4, 5);
        Selection boiler3 = util.select().fromTo(5, 4, 3, 4, 11, 4);

        Selection engine = util.select().position(2, 2, 3);
        Selection engine1 = util.select().fromTo(3, 4, 1, 2, 4, 1);
        class_2338 engine1ShaftPos = util.grid().at(1, 4, 1);
        Selection engine1Shaft = util.select().position(1, 4, 1);

        Selection pumpCogs = util.select().fromTo(6, 1, 7, 6, 1, 2);
        Selection largeCog = util.select().position(5, 0, 7);

        Selection pump1 = util.select().fromTo(5, 2, 2, 4, 1, 1);
        Selection pump2 = util.select().fromTo(5, 2, 7, 4, 1, 6);
        Selection pump3 = util.select().fromTo(2, 3, 7, 1, 1, 6);

        scene.world().modifyBlock(util.grid().at(4, 2, 7), s -> s.method_11657(PumpBlock.FACING, class_2350.field_11035), false);
        scene.world().modifyBlock(util.grid().at(1, 2, 7), s -> s.method_11657(PumpBlock.FACING, class_2350.field_11035), false);
        scene.world().modifyBlock(util.grid().at(2, 3, 7), s -> s.method_11657(PumpBlock.FACING, class_2350.field_11035), false);

        scene.idle(15);
        ElementLink<WorldSectionElement> tankElement = scene.world().showIndependentSection(tank, class_2350.field_11033);
        scene.world().moveSection(tankElement, util.vector().of(0, -1, 0), 0);
        scene.idle(10);
        ElementLink<WorldSectionElement> engineElement = scene.world().showIndependentSection(engine, class_2350.field_11034);
        scene.world().moveSection(engineElement, util.vector().of(1, -1, 0), 0);
        scene.idle(15);
        scene.world().moveSection(tankElement, util.vector().of(0, -1000, 0), 0);
        scene.world().hideIndependentSection(tankElement, null);
        ElementLink<WorldSectionElement> boilerElement = scene.world().showIndependentSectionImmediately(boiler1);
        scene.world().moveSection(boilerElement, util.vector().of(0, -3, 2), 0);
        scene.effects().indicateSuccess(util.grid().at(5, 1, 3));
        scene.effects().indicateSuccess(util.grid().at(4, 1, 3));
        scene.effects().indicateSuccess(util.grid().at(5, 1, 4));
        scene.effects().indicateSuccess(util.grid().at(4, 1, 4));
        scene.idle(25);

        scene.overlay().showText(50).attachKeyFrame().text("Steam Engines can be placed on a Fluid Tank")
            .pointAt(util.vector().blockSurface(util.grid().at(3, 1, 3), class_2350.field_11039)).placeNearTarget();
        scene.idle(60);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(3, 1, 3), class_2350.field_11036), Pointing.DOWN, 60)
            .withItem(AllItems.SHAFT.method_7854()).rightClick();
        scene.idle(10);
        scene.world().setBlock(engine1ShaftPos, AllBlocks.SHAFT.method_9564().method_11657(ShaftBlock.AXIS, class_2351.field_11051), false);
        ElementLink<WorldSectionElement> engineShaftElement = scene.world().showIndependentSection(engine1Shaft, null);
        scene.world().moveSection(engineShaftElement, util.vector().of(0, -3, 2), 0);
        scene.idle(5);
        scene.world().moveSection(engineElement, util.vector().of(0, -1000, 0), 0);
        scene.world().hideIndependentSection(engineElement, null);
        engineElement = scene.world().showIndependentSectionImmediately(engine1);
        scene.world().moveSection(engineElement, util.vector().of(0, -3, 2), 0);
        scene.world().setBlock(engine1ShaftPos, AllBlocks.POWERED_SHAFT.method_9564().method_11657(ShaftBlock.AXIS, class_2351.field_11051), false);
        scene.effects().indicateSuccess(util.grid().at(1, 1, 3));
        scene.idle(40);

        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.BLUE).text("Clicking the engine with a Shaft creates the Kinetic Output")
            .pointAt(util.vector().centerOf(util.grid().at(1, 1, 3))).placeNearTarget();
        scene.idle(90);

        scene.world().multiplyKineticSpeed(largeCog, -1);
        scene.world().multiplyKineticSpeed(pumpCogs, -1);
        scene.world().multiplyKineticSpeed(pump1, -1);
        scene.world().multiplyKineticSpeed(pump2, -1);

        scene.world().moveSection(boilerElement, util.vector().of(0, 1, 0), 15);
        scene.world().moveSection(engineElement, util.vector().of(0, 1, 0), 15);
        scene.world().moveSection(engineShaftElement, util.vector().of(0, 1, 0), 15);
        scene.idle(10);
        scene.world().showSection(campfires, class_2350.field_11043);
        scene.idle(10);
        scene.world().hideIndependentSection(fakeGroundElement, class_2350.field_11033);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(pump1, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(pumpCogs, class_2350.field_11039);
        scene.idle(25);

        scene.overlay().showText(60).attachKeyFrame().text("With sufficient Heat, Water and Boiler space...")
            .pointAt(util.vector().blockSurface(util.grid().at(4, 2, 4), class_2350.field_11036)).placeNearTarget();
        scene.idle(30);

        scene.world().setKineticSpeed(engine1Shaft, 16);
        scene.effects().createRedstoneParticles(util.grid().at(3, 2, 3), 0xFFFFFF, 10);
        scene.idle(40);

        scene.overlay().showText(60).text("...they will generate Rotational Force")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 2, 3), class_2350.field_11043)).placeNearTarget();
        scene.idle(70);

        scene.overlay().showOutlineWithText(util.select().fromTo(5, 2, 3, 4, 2, 4), 50).attachKeyFrame()
            .text("The minimal setup requires 4 Fluid Tanks").pointAt(util.vector().blockSurface(util.grid().at(4, 2, 4), class_2350.field_11036))
            .placeNearTarget();
        scene.idle(60);

        scene.world().hideSection(campfires, class_2350.field_11035);
        scene.idle(15);
        ElementLink<WorldSectionElement> burnersElement = scene.world().showIndependentSection(burners, class_2350.field_11035);
        scene.world().moveSection(burnersElement, util.vector().of(2, 0, 0), 0);
        scene.idle(25);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(4, 1, 3), class_2350.field_11034), Pointing.RIGHT, 60)
            .withItem(new class_1799(class_1802.field_8583)).rightClick();
        scene.idle(10);
        scene.world().setBlocks(burners, AllBlocks.BLAZE_BURNER.method_9564().method_11657(BlazeBurnerBlock.HEAT_LEVEL, HeatLevel.KINDLED), false);
        scene.idle(5);

        scene.world().setKineticSpeed(engine1Shaft, 64);
        scene.effects().createRedstoneParticles(util.grid().at(3, 2, 3), 0xFFFFFF, 10);
        scene.idle(40);

        scene.overlay().showText(80).text("With the help of Blaze Burners, the power output can be increased").attachKeyFrame()
            .pointAt(util.vector().blockSurface(util.grid().at(4, 1, 3), class_2350.field_11039)).placeNearTarget();
        scene.idle(90);

        scene.world().hideSection(pump1, class_2350.field_11036);
        scene.idle(5);
        scene.world().hideIndependentSection(boilerElement, class_2350.field_11035);
        scene.idle(10);
        boilerElement = scene.world().showIndependentSection(boiler2, class_2350.field_11035);
        scene.world().moveSection(boilerElement, util.vector().of(0, -2, -2), 0);
        scene.idle(10);
        ElementLink<WorldSectionElement> pumpElement = scene.world().showIndependentSection(pump2, class_2350.field_11033);
        scene.world().moveSection(pumpElement, util.vector().of(0, 0, -5), 0);
        scene.idle(20);

        class_243 target = util.vector().blockSurface(util.grid().at(4, 3, 3), class_2350.field_11039);
        scene.overlay().showText(80).text("Higher power levels require more Water, Size and Heat").attachKeyFrame().pointAt(target).placeNearTarget();
        scene.idle(90);

        scene.overlay().showControls(target.method_1031(0, 0, 0.5), Pointing.DOWN, 60).withItem(AllItems.GOGGLES.method_7854());
        scene.idle(6);
        scene.overlay().showText(80).text("The boiler's current power level can be inspected with Engineer's Goggles").attachKeyFrame()
            .colored(PonderPalette.BLUE).pointAt(target.method_1031(0, 0, 0.5)).placeNearTarget();
        scene.idle(90);

        scene.world().showSectionAndMerge(util.select().fromTo(3, 4, 6, 1, 4, 6), class_2350.field_11034, boilerElement);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().position(1, 4, 6), 64);
        scene.world().showSectionAndMerge(util.select().fromTo(3, 5, 6, 1, 5, 6), class_2350.field_11034, boilerElement);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().position(1, 5, 6), -64);
        scene.world().showSectionAndMerge(util.select().fromTo(3, 5, 5, 1, 5, 5), class_2350.field_11034, boilerElement);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().position(1, 5, 5), -64);
        scene.world().showSectionAndMerge(util.select().fromTo(1, 4, 7, 1, 5, 7), class_2350.field_11043, boilerElement);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().position(1, 5, 7), -64);
        scene.world().setKineticSpeed(util.select().position(1, 4, 7), 64);
        scene.idle(20);

        scene.overlay().showText(100).text("With each added power level, an additional Engine can output at full capacity").attachKeyFrame()
            .colored(PonderPalette.GREEN).pointAt(util.vector().blockSurface(util.grid().at(1, 3, 3), class_2350.field_11043)).placeNearTarget();
        scene.idle(110);

        scene.overlay().showText(30).text("Lvl 4").colored(PonderPalette.BLUE)
            .pointAt(util.vector().blockSurface(util.grid().at(4, 4, 4), class_2350.field_11039)).placeNearTarget();
        scene.idle(40);
        scene.overlay().showOutlineWithText(util.select().fromTo(3, 2, 3, 3, 3, 4), 30).text("4 Engines").colored(PonderPalette.BLUE)
            .pointAt(util.vector().blockSurface(util.grid().at(3, 3, 4), class_2350.field_11036)).placeNearTarget();
        scene.idle(30);

        scene.world().hideIndependentSection(pumpElement, class_2350.field_11036);
        scene.idle(5);
        scene.world().hideIndependentSection(boilerElement, class_2350.field_11035);
        scene.world().hideIndependentSection(engineElement, class_2350.field_11035);
        scene.world().hideIndependentSection(engineShaftElement, class_2350.field_11035);
        scene.idle(20);

        scene.overlay().showControls(util.vector().of(5, 2, 4), Pointing.DOWN, 10).withItem(AllItems.BLAZE_CAKE.method_7854()).rightClick();
        scene.idle(6);
        scene.world().setBlocks(burners, AllBlocks.BLAZE_BURNER.method_9564().method_11657(BlazeBurnerBlock.HEAT_LEVEL, HeatLevel.SEETHING), false);
        scene.idle(15);

        boilerElement = scene.world().showIndependentSection(boiler3, class_2350.field_11035);
        scene.world().moveSection(boilerElement, util.vector().of(0, -2, 0), 0);
        scene.idle(10);
        pumpElement = scene.world().showIndependentSection(pump3, class_2350.field_11033);
        scene.world().moveSection(pumpElement, util.vector().of(3, 0, -5), 0);
        scene.idle(20);

        ElementLink<WorldSectionElement> cogsElement = scene.world().showIndependentSection(util.select().position(1, 1, 7), class_2350.field_11043);
        scene.world().moveSection(cogsElement, util.vector().of(0, -2, -2), 0);

        Selection previous = null;
        boolean previousForward = false;
        for (int y = 4; y < 9; y++) {
            if (y != 6)
                for (boolean left : Iterate.trueAndFalse) {
                    int z = (left ^ y % 2 == 0) ? 3 : 4;
                    if (previous != null)
                        scene.world().setKineticSpeed(previous, previousForward ? 64 : -64);
                    scene.world().showSectionAndMerge(previous = util.select().fromTo(3, y, z, 1, y, z), class_2350.field_11034, boilerElement);
                    previousForward = y % 2 == 0;
                    scene.idle(5);
                }

            scene.world().showSectionAndMerge(util.select().position(1, y, 7), class_2350.field_11043, cogsElement);
            scene.world().setKineticSpeed(util.select().position(1, y, 7), y % 2 == 0 ? 64 : -64);
        }

        scene.world().setKineticSpeed(previous, 64);

        scene.overlay().showText(30).text("Lvl 8").colored(PonderPalette.BLUE)
            .pointAt(util.vector().blockSurface(util.grid().at(4, 4, 3), class_2350.field_11043)).placeNearTarget();
        scene.idle(40);
        scene.overlay().showOutlineWithText(util.select().fromTo(3, 2, 3, 3, 6, 4), 30).text("8 Engines").colored(PonderPalette.BLUE)
            .pointAt(util.vector().blockSurface(util.grid().at(3, 3, 4), class_2350.field_11036)).placeNearTarget();
        scene.idle(30);

    }

}