package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.content.equipment.armor.CardboardRenderState;
import com.zurrtum.create.client.foundation.render.SkyhookRenderState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

import java.util.UUID;
import net.minecraft.class_10055;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5498;
import net.minecraft.class_742;

@Mixin(class_10055.class)
public class PlayerEntityRenderStateMixin implements CardboardRenderState, SkyhookRenderState {
    @Unique
    private boolean flying;
    @Unique
    private boolean skip;
    @Unique
    private boolean onGround;
    @Unique
    private float lastYaw;
    @Unique
    private float yaw;
    @Unique
    private double lastX;
    @Unique
    private double lastY;
    @Unique
    private double lastZ;
    @Unique
    private class_243 pos;
    @Unique
    private float tickProgress;
    @Unique
    private UUID uuid;
    @Unique
    private class_1799 mainStack;

    @Override
    public void create$setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public UUID create$getUuid() {
        return uuid;
    }

    @Override
    public void create$setMainStack(class_1799 stack) {
        mainStack = stack;
    }

    @Override
    public class_1799 create$getMainStack() {
        return mainStack;
    }

    @Override
    public void create$update(class_742 player, float tickProgress) {
        if (player.method_31549().field_7479) {
            flying = true;
            return;
        } else {
            flying = false;
        }
        class_310 mc = class_310.method_1551();
        if (player == mc.field_1724 && mc.field_1690.method_31044() == class_5498.field_26664) {
            skip = true;
            return;
        } else {
            skip = false;
        }
        onGround = player.method_24828();
        lastYaw = player.field_5982;
        yaw = player.method_36454();
        lastX = player.field_6014;
        lastY = player.field_6036;
        lastZ = player.field_5969;
        pos = player.method_19538();
        this.tickProgress = tickProgress;
    }

    @Override
    public boolean create$isFlying() {
        return flying;
    }

    @Override
    public boolean create$isSkip() {
        return skip;
    }

    @Override
    public boolean create$isOnGround() {
        return onGround;
    }

    @Override
    public double create$getMovement() {
        return pos.method_1023(lastX, lastY, lastZ).method_1033();
    }

    @Override
    public float create$getInterpolatedYaw() {
        return class_3532.method_16439(tickProgress, lastYaw, yaw);
    }
}
