package com.zurrtum.create.client.ponder.foundation;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import org.joml.Matrix4fStack;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import net.minecraft.class_1921;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_703;

public class PonderWorldParticles {

    private final Map<class_3999, Queue<class_703>> byType = Maps.newIdentityHashMap();
    private final Queue<class_703> queue = Queues.newArrayDeque();

    PonderLevel world;

    public PonderWorldParticles(PonderLevel world) {
        this.world = world;
    }

    public void addParticle(class_703 p) {
        this.queue.add(p);
    }

    public void tick() {
        this.byType.forEach((p_228347_1_, p_228347_2_) -> this.tickParticleList(p_228347_2_));

        class_703 particle;
        if (queue.isEmpty())
            return;
        while ((particle = this.queue.poll()) != null)
            this.byType.computeIfAbsent(particle.method_18122(), $ -> EvictingQueue.create(16384)).add(particle);
    }

    private void tickParticleList(Collection<class_703> p_187240_1_) {
        if (p_187240_1_.isEmpty())
            return;

        Iterator<class_703> iterator = p_187240_1_.iterator();
        while (iterator.hasNext()) {
            class_703 particle = iterator.next();
            particle.method_3070();
            if (!particle.method_3086())
                iterator.remove();
        }
    }

    public void renderParticles(class_4587 ms, SuperRenderTypeBuffer buffer, class_4184 renderInfo, float pt) {
        buffer.draw();

        Matrix4fStack stack = RenderSystem.getModelViewStack();
        stack.pushMatrix();
        stack.mul(ms.method_23760().method_23761());

        for (class_3999 iparticlerendertype : this.byType.keySet()) {
            if (iparticlerendertype == class_3999.field_17832)
                continue;
            Iterable<class_703> iterable = this.byType.get(iparticlerendertype);
            if (iterable != null) {
                class_1921 layer = iparticlerendertype.comp_3341();
                if (layer != null) {
                    class_4588 vertexConsumer = buffer.getBuffer(layer);
                    for (class_703 particle : iterable)
                        particle.method_3074(vertexConsumer, renderInfo, pt);
                } else {
                    for (class_703 particle : iterable)
                        particle.method_65198(ms, buffer, renderInfo, pt);
                }
            }
        }

        buffer.draw();
        stack.popMatrix();
    }

    public void clearEffects() {
        this.byType.clear();
    }

}