package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.client.catnip.outliner.Outline.OutlineParams;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3341;

public class SelectionImpl {

    public static Selection of(class_3341 bb) {
        return new Simple(bb);
    }

    private static class Compound implements Selection {
        private final Set<class_2338> posSet;
        @Nullable
        private class_243 center;

        public Compound(Simple initial) {
            posSet = new HashSet<>();
            add(initial);
        }

        private Compound(Set<class_2338> template) {
            posSet = new HashSet<>(template);
        }

        @Override
        public boolean test(class_2338 t) {
            return posSet.contains(t);
        }

        @Override
        public Selection add(Selection other) {
            other.forEach(p -> posSet.add(p.method_10062()));
            center = null;
            return this;
        }

        @Override
        public Selection substract(Selection other) {
            other.forEach(p -> posSet.remove(p.method_10062()));
            center = null;
            return this;
        }

        @Override
        public OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showCluster(slot, posSet);
        }

        @Override
        public class_243 getCenter() {
            return center == null ? center = evalCenter() : center;
        }

        private class_243 evalCenter() {
            class_243 center = class_243.field_1353;
            if (posSet.isEmpty())
                return center;
            for (class_2338 blockPos : posSet)
                center = center.method_1019(class_243.method_24954(blockPos));
            center = center.method_1021(1f / posSet.size());
            return center.method_1019(new class_243(.5, .5, .5));
        }

        @Override
        public Selection copy() {
            return new Compound(posSet);
        }

        @Override
        @NotNull
        public Iterator<class_2338> iterator() {
            return posSet.iterator();
        }
    }

    private static class Simple implements Selection {
        private final class_3341 bb;
        private final class_238 aabb;
        private final Iterable<class_2338> iterable;

        public Simple(class_3341 bb) {
            this.bb = bb;
            this.aabb = new class_238(bb.method_35415(), bb.method_35416(), bb.method_35417(), bb.method_35418() + 1, bb.method_35419() + 1, bb.method_35420() + 1);
            iterable = class_2338.method_10094(
                Math.min(bb.method_35415(), bb.method_35418()),
                Math.min(bb.method_35416(), bb.method_35419()),
                Math.min(bb.method_35417(), bb.method_35420()),
                Math.max(bb.method_35415(), bb.method_35418()),
                Math.max(bb.method_35416(), bb.method_35419()),
                Math.max(bb.method_35417(), bb.method_35420())
            );
        }

        @Override
        public boolean test(class_2338 t) {
            return bb.method_14662(t);
        }

        @Override
        public Selection add(Selection other) {
            return new Compound(this).add(other);
        }

        @Override
        public Selection substract(Selection other) {
            return new Compound(this).substract(other);
        }

        @Override
        public class_243 getCenter() {
            return aabb.method_1005();
        }

        @Override
        public OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showAABB(slot, aabb);
        }

        @Override
        public Selection copy() {
            return new Simple(new class_3341(bb.method_35415(), bb.method_35416(), bb.method_35417(), bb.method_35418(), bb.method_35419(), bb.method_35420()));
        }

        @Override
        @NotNull
        public Iterator<class_2338> iterator() {
            return iterable.iterator();
        }
    }

}