package com.zurrtum.create.client.ponder.foundation.element;

import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.client.render.model.BakedModelBufferer;
import com.zurrtum.create.client.catnip.client.render.model.ShadeSeparatedResultConsumer;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.*;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache.Compartment;
import com.zurrtum.create.client.compat.sodium.SodiumCompat;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import net.minecraft.class_1088;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5558;
import net.minecraft.class_761;
import net.minecraft.class_827;
import net.minecraft.class_9801;
import net.minecraft.client.render.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class WorldSectionElementImpl extends AnimatedSceneElementBase implements WorldSectionElement {

    public static final Compartment<Pair<Integer, Integer>> PONDER_WORLD_SECTION = new Compartment<>();

    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    @Nullable List<class_2586> renderedBlockEntities;
    @Nullable List<Pair<class_2586, Consumer<class_1937>>> tickableBlockEntities;
    @Nullable Selection section;
    boolean redraw;

    class_243 prevAnimatedOffset = class_243.field_1353;
    class_243 animatedOffset = class_243.field_1353;
    class_243 prevAnimatedRotation = class_243.field_1353;
    class_243 animatedRotation = class_243.field_1353;
    class_243 centerOfRotation = class_243.field_1353;
    @Nullable class_243 stabilizationAnchor = null;

    @Nullable class_2338 selectedBlock;

    public WorldSectionElementImpl() {
    }

    public WorldSectionElementImpl(Selection section) {
        this.section = section.copy();
        centerOfRotation = section.getCenter();
    }

    @Override
    public void mergeOnto(WorldSectionElement other) {
        setVisible(false);
        if (other.isEmpty())
            other.set(section);
        else
            other.add(section);
    }

    @Override
    public void set(Selection selection) {
        applyNewSelection(selection.copy());
    }

    @Override
    public void add(Selection toAdd) {
        applyNewSelection(this.section.add(toAdd));
    }

    @Override
    public void erase(Selection toErase) {
        applyNewSelection(this.section.substract(toErase));
    }

    private void applyNewSelection(Selection selection) {
        this.section = selection;
        queueRedraw();
    }

    @Override
    public void setCenterOfRotation(class_243 center) {
        centerOfRotation = center;
    }

    @Override
    public void stabilizeRotation(class_243 anchor) {
        stabilizationAnchor = anchor;
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        resetAnimatedTransform();
        resetSelectedBlock();
    }

    @Override
    public void selectBlock(class_2338 pos) {
        selectedBlock = pos;
    }

    @Override
    public void resetSelectedBlock() {
        selectedBlock = null;
    }

    public void resetAnimatedTransform() {
        prevAnimatedOffset = class_243.field_1353;
        animatedOffset = class_243.field_1353;
        prevAnimatedRotation = class_243.field_1353;
        animatedRotation = class_243.field_1353;
    }

    @Override
    public void queueRedraw() {
        redraw = true;
    }

    @Override
    public boolean isEmpty() {
        return section == null;
    }

    @Override
    public void setEmpty() {
        section = null;
    }

    @Override
    public void setAnimatedRotation(class_243 eulerAngles, boolean force) {
        this.animatedRotation = eulerAngles;
        if (force)
            prevAnimatedRotation = animatedRotation;
    }

    @Override
    public class_243 getAnimatedRotation() {
        return animatedRotation;
    }

    @Override
    public void setAnimatedOffset(class_243 offset, boolean force) {
        this.animatedOffset = offset;
        if (force)
            prevAnimatedOffset = animatedOffset;
    }

    @Override
    public class_243 getAnimatedOffset() {
        return animatedOffset;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !isEmpty();
    }

    @Override
    public Pair<class_243, class_3965> rayTrace(PonderLevel world, class_243 source, class_243 target) {
        world.setMask(this.section);
        class_243 transformedTarget = reverseTransformVec(target);
        class_3965 rayTraceBlocks = world.method_17742(new class_3959(
            reverseTransformVec(source),
            transformedTarget,
            class_3959.class_3960.field_17559,
            class_3959.class_242.field_1348,
            class_3726.method_16194()
        ));
        world.clearMask();

        double t = rayTraceBlocks.method_17784().method_1020(transformedTarget).method_1027() / source.method_1020(target).method_1027();
        class_243 actualHit = VecHelper.lerp((float) t, target, source);
        return Pair.of(actualHit, rayTraceBlocks);
    }

    private class_243 reverseTransformVec(class_243 in) {
        float pt = AnimationTickHolder.getPartialTicks();
        in = in.method_1020(VecHelper.lerp(pt, prevAnimatedOffset, animatedOffset));
        if (!animatedRotation.equals(class_243.field_1353) || !prevAnimatedRotation.equals(class_243.field_1353)) {
            double rotX = class_3532.method_16436(pt, prevAnimatedRotation.field_1352, animatedRotation.field_1352);
            double rotZ = class_3532.method_16436(pt, prevAnimatedRotation.field_1350, animatedRotation.field_1350);
            double rotY = class_3532.method_16436(pt, prevAnimatedRotation.field_1351, animatedRotation.field_1351);
            in = in.method_1020(centerOfRotation);
            in = VecHelper.rotate(in, -rotX, class_2351.field_11048);
            in = VecHelper.rotate(in, -rotZ, class_2351.field_11051);
            in = VecHelper.rotate(in, -rotY, class_2351.field_11052);
            in = in.method_1019(centerOfRotation);
            if (stabilizationAnchor != null) {
                in = in.method_1020(stabilizationAnchor);
                in = VecHelper.rotate(in, rotX, class_2351.field_11048);
                in = VecHelper.rotate(in, rotZ, class_2351.field_11051);
                in = VecHelper.rotate(in, rotY, class_2351.field_11052);
                in = in.method_1019(stabilizationAnchor);
            }
        }
        return in;
    }

    public void transformMS(class_4587 ms, float pt) {

        class_243 vec = VecHelper.lerp(pt, prevAnimatedOffset, animatedOffset);
        ms.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
        if (!animatedRotation.equals(class_243.field_1353) || !prevAnimatedRotation.equals(class_243.field_1353)) {
            double rotX = class_3532.method_16436(pt, prevAnimatedRotation.field_1352, animatedRotation.field_1352);
            double rotZ = class_3532.method_16436(pt, prevAnimatedRotation.field_1350, animatedRotation.field_1350);
            double rotY = class_3532.method_16436(pt, prevAnimatedRotation.field_1351, animatedRotation.field_1351);

            TransformStack.of(ms).translate(centerOfRotation).rotateXDegrees((float) rotX).rotateYDegrees((float) rotY).rotateZDegrees((float) rotZ)
                .translateBack(centerOfRotation);

            if (stabilizationAnchor != null) {
                TransformStack.of(ms).translate(stabilizationAnchor).rotateXDegrees((float) -rotX).rotateYDegrees((float) -rotY)
                    .rotateZDegrees((float) -rotZ).translateBack(stabilizationAnchor);
            }
        }
    }

    @Override
    public void tick(PonderScene scene) {
        prevAnimatedOffset = animatedOffset;
        prevAnimatedRotation = animatedRotation;
        if (!isVisible())
            return;
        loadBEsIfMissing(scene.getWorld());
        renderedBlockEntities.removeIf(be -> scene.getWorld().method_8321(be.method_11016()) != be);
        tickableBlockEntities.removeIf(be -> scene.getWorld().method_8321(be.getFirst().method_11016()) != be.getFirst());
        tickableBlockEntities.forEach(be -> be.getSecond().accept(scene.getWorld()));
    }

    @Override
    public void whileSkipping(PonderScene scene) {
        if (redraw) {
            renderedBlockEntities = null;
            tickableBlockEntities = null;
        }
        redraw = false;
    }

    @SuppressWarnings("deprecation")
    protected void loadBEsIfMissing(PonderLevel world) {
        if (renderedBlockEntities != null)
            return;
        tickableBlockEntities = new ArrayList<>();
        renderedBlockEntities = new ArrayList<>();
        section.forEach(pos -> {
            class_2586 blockEntity = world.method_8321(pos);
            class_2680 blockState = world.method_8320(pos);
            class_2248 block = blockState.method_26204();
            if (blockEntity == null)
                return;
            if (!(block instanceof class_2343 provider))
                return;
            blockEntity.method_31664(world.method_8320(pos));
            class_5558<?> ticker = provider.method_31645(world, blockState, blockEntity.method_11017());
            if (ticker != null)
                addTicker(blockEntity, ticker);
            renderedBlockEntities.add(blockEntity);
        });
    }

    @SuppressWarnings("unchecked")
    private <T extends class_2586> void addTicker(T blockEntity, class_5558<?> ticker) {
        tickableBlockEntities.add(Pair.of(
            blockEntity,
            w -> ((class_5558<T>) ticker).tick(w, blockEntity.method_11016(), blockEntity.method_11010(), blockEntity)
        ));
    }

    @Override
    public void renderFirst(PonderLevel world, class_4597 buffer, class_4587 poseStack, float fade, float pt) {
        int light = -1;
        if (fade != 1)
            light = class_3532.method_48781(fade, 5, 15);
        if (redraw) {
            renderedBlockEntities = null;
            tickableBlockEntities = null;
        }

        poseStack.method_22903();
        transformMS(poseStack, pt);
        world.pushFakeLight(light);
        renderBlockEntities(world, poseStack, buffer, pt);
        world.popLight();

        Map<class_2338, Integer> blockBreakingProgressions = world.getBlockBreakingProgressions();
        class_4587 overlayMS = null;

        for (Map.Entry<class_2338, Integer> entry : blockBreakingProgressions.entrySet()) {
            class_2338 pos = entry.getKey();
            if (!section.test(pos))
                continue;

            if (overlayMS == null) {
                overlayMS = new class_4587();
                class_4587.class_4665 matrixEntry = poseStack.method_23760();
                overlayMS.method_23760().method_23761().set(matrixEntry.method_23761());
                overlayMS.method_23760().method_23762().set(matrixEntry.method_23762());
            }

            class_4588 builder = new class_4583(
                buffer.getBuffer(class_1088.field_21772.get(entry.getValue())),
                overlayMS.method_23760(),
                1
            );

            poseStack.method_22903();
            poseStack.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
            class_310.method_1551().method_1541().method_23071(world.method_8320(pos), pos, world, poseStack, builder);
            poseStack.method_22909();
        }

        poseStack.method_22909();
    }

    @Override
    protected void renderLayer(PonderLevel world, class_4597 buffer, class_11515 type, class_4587 poseStack, float fade, float pt) {
        SuperByteBufferCache bufferCache = SuperByteBufferCache.getInstance();

        int code = hashCode() ^ world.hashCode();
        Pair<Integer, Integer> key = Pair.of(code, type.ordinal());

        if (redraw)
            bufferCache.invalidate(PONDER_WORLD_SECTION, key);

        SodiumCompat.markPonderSpriteActive(world, section);
        SuperByteBuffer structureBuffer = bufferCache.get(PONDER_WORLD_SECTION, key, () -> buildStructureBuffer(world, type));
        if (structureBuffer.isEmpty())
            return;

        transformMS(structureBuffer.getTransforms(), pt);

        int light = lightCoordsFromFade(fade);
        class_1921 layer = switch (type) {
            case field_60925 -> class_1921.method_23581();
            case field_60923 -> class_1921.method_23577();
            case field_60924 -> class_1921.method_23579();
            case field_60926 -> PonderRenderTypes.translucent();
            case field_60927 -> class_1921.method_29997();
        };
        structureBuffer.light(light).renderInto(poseStack, buffer.getBuffer(layer));
    }

    @Override
    protected void renderLast(PonderLevel world, class_4597 buffer, class_4587 poseStack, float fade, float pt) {
        redraw = false;
        if (selectedBlock == null)
            return;
        class_2680 blockState = world.method_8320(selectedBlock);
        if (blockState.method_26215())
            return;
        class_310 mc = class_310.method_1551();
        class_265 shape = blockState.method_26172(world, selectedBlock, class_3726.method_16195(mc.field_1724));
        if (shape.method_1110())
            return;

        poseStack.method_22903();
        transformMS(poseStack, pt);
        poseStack.method_46416(selectedBlock.method_10263(), selectedBlock.method_10264(), selectedBlock.method_10260());

        AABBOutline aabbOutline = new AABBOutline(shape.method_1107().method_1014(1 / 128f));
        aabbOutline.getParams().lineWidth(1 / 64f).colored(0xefefef).disableLineNormals();
        aabbOutline.render(mc, poseStack, (SuperRenderTypeBuffer) buffer, class_243.field_1353, pt);

        poseStack.method_22909();
    }

    private void renderBlockEntities(PonderLevel world, class_4587 ms, class_4597 buffer, float pt) {
        loadBEsIfMissing(world);

        Iterator<class_2586> iterator = renderedBlockEntities.iterator();
        class_310 mc = class_310.method_1551();
        class_243 cameraPos = mc.field_1773.method_19418().method_71156();
        while (iterator.hasNext()) {
            class_2586 tile = iterator.next();
            class_827<class_2586> renderer = mc.method_31975().method_3550(tile);
            if (renderer == null) {
                iterator.remove();
                continue;
            }

            class_2338 pos = tile.method_11016();
            ms.method_22903();
            ms.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());

            try {
                renderer.method_3569(tile, pt, ms, buffer, class_761.method_23794(world, pos), class_4608.field_21444, cameraPos);

            } catch (Exception e) {
                iterator.remove();
                String message = "BlockEntity " + RegisteredObjectsHelper.getKeyOrThrow(tile.method_11017()) + " could not be rendered virtually.";
                Ponder.LOGGER.error(message, e);
            }

            ms.method_22909();
        }
    }

    private SuperByteBuffer buildStructureBuffer(PonderLevel world, class_11515 layer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        SbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.prepare(layer);

        world.setMask(section);
        world.pushFakeLight(0);

        BakedModelBufferer.bufferBlocks(section.iterator(), world, null, true, sbbBuilder);

        world.popLight();
        world.clearMask();

        return sbbBuilder.build();
    }

    private static class SbbBuilder extends SuperByteBufferBuilder implements ShadeSeparatedResultConsumer {
        private class_11515 renderType;

        public void prepare(class_11515 renderType) {
            prepare();
            this.renderType = renderType;
        }

        @Override
        public void accept(class_11515 renderType, boolean shaded, class_9801 data) {
            if (renderType != this.renderType) {
                return;
            }

            add(data, shaded);
        }
    }

    private static class ThreadLocalObjects {
        public final SbbBuilder sbbBuilder = new SbbBuilder();
    }

}