package com.zurrtum.create.content.contraptions.actors.roller;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlockEntity.RollingMode;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.pulley.PulleyContraption;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.bogey.StandardBogeyBlock;
import com.zurrtum.create.content.trains.entity.*;
import com.zurrtum.create.content.trains.entity.TravellingPoint.ITrackSelector;
import com.zurrtum.create.content.trains.entity.TravellingPoint.SteerDirection;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.block.*;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3532;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.BiConsumer;

public class RollerMovementBehaviour extends BlockBreakingMovementBehaviour {

    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !(context.contraption instanceof PulleyContraption) && VecHelper.isVecPointingTowards(
            context.relativeMotion,
            context.state.method_11654(RollerBlock.field_11177)
        );
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954(context.state.method_11654(RollerBlock.field_11177).method_62675()).method_1021(.45).method_1023(0, 2, 0);
    }

    @Override
    protected float getBlockBreakingSpeed(MovementContext context) {
        return class_3532.method_15363(super.getBlockBreakingSpeed(context) * 1.5f, 1 / 128f, 16f);
    }

    @Override
    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        for (class_2350 side : Iterate.directions)
            if (world.method_8320(breakingPos.method_10093(side)).method_26164(class_3481.field_21780))
                return false;

        return super.canBreak(world, breakingPos, state) && !state.method_26220(world, breakingPos)
            .method_1110() && !state.method_26164(AllBlockTags.TRACKS);
    }

    @Override
    protected class_1282 getDamageSource(class_1937 level) {
        return AllDamageSources.get(level).roller;
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        class_1937 world = context.world;
        class_2680 stateVisited = world.method_8320(pos);
        if (!stateVisited.method_26212(world, pos))
            damageEntities(context, pos, world);
        if (world.field_9236)
            return;

        List<class_2338> positionsToBreak = getPositionsToBreak(context, pos);
        if (positionsToBreak.isEmpty()) {
            triggerPaver(context, pos);
            return;
        }

        class_2338 argMax = null;
        double max = -1;
        for (class_2338 toBreak : positionsToBreak) {
            float hardness = context.world.method_8320(toBreak).method_26214(world, toBreak);
            if (hardness < max)
                continue;
            max = hardness;
            argMax = toBreak;
        }

        if (argMax == null) {
            triggerPaver(context, pos);
            return;
        }

        context.data.method_67494("ReferencePos", class_2338.field_25064, pos);
        context.data.method_67494("BreakingPos", class_2338.field_25064, argMax);
        context.stall = true;
    }

    @Override
    protected void onBlockBroken(MovementContext context, class_2338 pos, class_2680 brokenState) {
        super.onBlockBroken(context, pos, brokenState);
        if (!context.data.method_10545("ReferencePos"))
            return;

        class_2338 referencePos = context.data.method_67491("ReferencePos", class_2338.field_25064).orElse(class_2338.field_10980);
        for (class_2338 otherPos : getPositionsToBreak(context, referencePos))
            if (!otherPos.equals(pos))
                destroyBlock(context, otherPos);

        triggerPaver(context, referencePos);
        context.data.method_10551("ReferencePos");
    }

    @Override
    protected void destroyBlock(MovementContext context, class_2338 breakingPos) {
        class_2680 blockState = context.world.method_8320(breakingPos);
        boolean noHarvest = blockState.method_26164(class_3481.field_33718) || blockState.method_26164(class_3481.field_33719) || blockState.method_26164(class_3481.field_33717);

        BlockHelper.destroyBlock(
            context.world, breakingPos, 1f, stack -> {
                if (noHarvest || context.world.field_9229.method_43056())
                    return;
                this.dropItem(context, stack);
            }
        );

        super.destroyBlock(context, breakingPos);
    }

    RollerTravellingPoint rollerScout = new RollerTravellingPoint();

    protected List<class_2338> getPositionsToBreak(MovementContext context, class_2338 visitedPos) {
        ArrayList<class_2338> positions = new ArrayList<>();

        RollingMode mode = getMode(context);
        if (mode != RollingMode.TUNNEL_PAVE)
            return positions;

        int startingY = 1;
        if (!getStateToPaveWith(context).method_26215()) {
            FilterItemStack filter = context.getFilterFromBE();
            class_1263 inventory = context.contraption.getStorage().getAllItems();
            class_1799 count = inventory.count(stack -> filter.test(context.world, stack), 1);
            if (!count.method_7960()) {
                startingY = 0;
            }
        }

        // Train
        PaveTask profileForTracks = createHeightProfileForTracks(context);
        if (profileForTracks != null) {
            for (Couple<Integer> coords : profileForTracks.keys()) {
                float height = profileForTracks.get(coords);
                class_2338 targetPosition = class_2338.method_49637(coords.getFirst(), height, coords.getSecond());
                boolean shouldPlaceSlab = height > Math.floor(height) + .45;
                if (startingY == 1 && shouldPlaceSlab && context.world.method_8320(targetPosition.method_10084())
                    .method_61767(class_2482.field_11501, class_2771.field_12682) == class_2771.field_12681)
                    startingY = 2;
                for (int i = startingY; i <= (shouldPlaceSlab ? 3 : 2); i++)
                    if (testBreakerTarget(context, targetPosition.method_10086(i), i))
                        positions.add(targetPosition.method_10086(i));
            }
            return positions;
        }

        // Otherwise
        for (int i = startingY; i <= 2; i++)
            if (testBreakerTarget(context, visitedPos.method_10086(i), i))
                positions.add(visitedPos.method_10086(i));

        return positions;
    }

    protected boolean testBreakerTarget(MovementContext context, class_2338 target, int columnY) {
        class_2680 stateToPaveWith = getStateToPaveWith(context);
        class_2680 stateToPaveWithAsSlab = getStateToPaveWithAsSlab(context);
        class_2680 stateAbove = context.world.method_8320(target);
        if (columnY == 0 && stateAbove.method_27852(stateToPaveWith.method_26204()))
            return false;
        if (stateToPaveWithAsSlab != null && columnY == 1 && stateAbove.method_27852(stateToPaveWithAsSlab.method_26204()))
            return false;
        return canBreak(context.world, target, stateAbove);
    }

    @Nullable
    protected PaveTask createHeightProfileForTracks(MovementContext context) {
        if (context.contraption == null)
            return null;
        if (!(context.contraption.entity instanceof CarriageContraptionEntity cce))
            return null;
        Carriage carriage = cce.getCarriage();
        if (carriage == null)
            return null;
        Train train = carriage.train;
        if (train == null || train.graph == null)
            return null;

        CarriageBogey mainBogey = carriage.bogeys.getFirst();
        TravellingPoint point = mainBogey.trailing();

        rollerScout.node1 = point.node1;
        rollerScout.node2 = point.node2;
        rollerScout.edge = point.edge;
        rollerScout.position = point.position;

        class_2351 axis = class_2351.field_11048;
        class_3501 info = context.contraption.getBlocks().get(class_2338.field_11176);
        if (info != null && info.comp_1342().method_28498(StandardBogeyBlock.AXIS))
            axis = info.comp_1342().method_11654(StandardBogeyBlock.AXIS);

        class_2350 orientation = cce.getInitialOrientation();
        class_2350 rollerFacing = context.state.method_11654(RollerBlock.field_11177);

        int step = orientation.method_10171().method_10181();
        double widthWiseOffset = axis.method_10173(-context.localPos.method_10260(), 0, -context.localPos.method_10263()) * step;
        double lengthWiseOffset = axis.method_10173(-context.localPos.method_10263(), 0, context.localPos.method_10260()) * step - 1;

        if (rollerFacing == orientation.method_10170())
            lengthWiseOffset += 1;

        double distanceToTravel = 2;
        PaveTask heightProfile = new PaveTask(widthWiseOffset, widthWiseOffset);
        ITrackSelector steering = rollerScout.steer(SteerDirection.NONE, new class_243(0, 1, 0));

        rollerScout.traversalCallback = (edge, coords) -> {
        };
        rollerScout.travel(train.graph, lengthWiseOffset + 1, steering);

        rollerScout.traversalCallback = (edge, coords) -> {
            if (edge == null)
                return;
            if (edge.isInterDimensional())
                return;
            if (edge.node1.getLocation().dimension != context.world.method_27983())
                return;
            TrackPaverV2.pave(heightProfile, train.graph, edge, coords.getFirst(), coords.getSecond());
        };
        rollerScout.travel(train.graph, distanceToTravel, steering);

        for (Couple<Integer> entry : heightProfile.keys())
            heightProfile.put(entry.getFirst(), entry.getSecond(), context.localPos.method_10264() + heightProfile.get(entry));

        return heightProfile;
    }

    protected void triggerPaver(MovementContext context, class_2338 pos) {
        class_2680 stateToPaveWith = getStateToPaveWith(context);
        class_2680 stateToPaveWithAsSlab = getStateToPaveWithAsSlab(context);
        RollingMode mode = getMode(context);

        if (mode != RollingMode.TUNNEL_PAVE && stateToPaveWith.method_26215())
            return;

        class_243 directionVec = class_243.method_24954(context.state.method_11654(RollerBlock.field_11177).method_10170().method_62675());
        directionVec = context.rotation.apply(directionVec);
        PaveResult paveResult = PaveResult.PASS;
        int yOffset = 0;

        List<Pair<class_2338, Boolean>> paveSet = new ArrayList<>();
        PaveTask profileForTracks = createHeightProfileForTracks(context);
        if (profileForTracks == null)
            paveSet.add(Pair.of(pos, false));
        else
            for (Couple<Integer> coords : profileForTracks.keys()) {
                float height = profileForTracks.get(coords);
                boolean shouldPlaceSlab = height > Math.floor(height) + .45;
                class_2338 targetPosition = class_2338.method_49637(coords.getFirst(), height, coords.getSecond());
                paveSet.add(Pair.of(targetPosition, shouldPlaceSlab));
            }

        if (paveSet.isEmpty())
            return;

        while (paveResult == PaveResult.PASS) {
            if (yOffset > AllConfigs.server().kinetics.rollerFillDepth.get()) {
                paveResult = PaveResult.FAIL;
                break;
            }

            Set<Pair<class_2338, Boolean>> currentLayer = new HashSet<>();
            if (mode == RollingMode.WIDE_FILL) {
                for (Pair<class_2338, Boolean> anchor : paveSet) {
                    int radius = (yOffset + 1) / 2;
                    for (int i = -radius; i <= radius; i++)
                        for (int j = -radius; j <= radius; j++)
                            if (class_2338.field_11176.method_19455(new class_2338(i, 0, j)) <= radius)
                                currentLayer.add(Pair.of(anchor.getFirst().method_10069(i, -yOffset, j), anchor.getSecond()));
                }
            } else
                for (Pair<class_2338, Boolean> anchor : paveSet)
                    currentLayer.add(Pair.of(anchor.getFirst().method_10087(yOffset), anchor.getSecond()));

            boolean completelyBlocked = true;
            boolean anyBlockPlaced = false;

            for (Pair<class_2338, Boolean> currentPos : currentLayer) {
                if (stateToPaveWithAsSlab != null && yOffset == 0 && currentPos.getSecond())
                    tryFill(context, currentPos.getFirst().method_10084(), stateToPaveWithAsSlab);
                paveResult = tryFill(context, currentPos.getFirst(), stateToPaveWith);
                if (paveResult != PaveResult.FAIL)
                    completelyBlocked = false;
                if (paveResult == PaveResult.SUCCESS)
                    anyBlockPlaced = true;
            }

            if (anyBlockPlaced)
                paveResult = PaveResult.SUCCESS;
            else if (!completelyBlocked || yOffset == 0)
                paveResult = PaveResult.PASS;

            if (paveResult == PaveResult.SUCCESS && stateToPaveWith.method_26204() instanceof class_2346)
                paveResult = PaveResult.PASS;
            if (paveResult != PaveResult.PASS)
                break;
            if (mode == RollingMode.TUNNEL_PAVE)
                break;

            yOffset++;
        }

        if (paveResult == PaveResult.SUCCESS) {
            context.data.method_10569("WaitingTicks", 2);
            context.data.method_67494("LastPos", class_2338.field_25064, pos);
            context.stall = true;
        }
    }

    public static class_2680 getStateToPaveWith(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof class_1747 bi) {
            class_2680 defaultBlockState = bi.method_7711().method_9564();
            if (defaultBlockState.method_28498(class_2482.field_11501))
                defaultBlockState = defaultBlockState.method_11657(class_2482.field_11501, class_2771.field_12682);
            return defaultBlockState;
        }
        return class_2246.field_10124.method_9564();
    }

    protected class_2680 getStateToPaveWith(MovementContext context) {
        class_6903<class_2520> ops = context.world.method_30349().method_57093(class_2509.field_11560);
        class_1799 filter = context.blockEntityData.method_67492("Filter", class_1799.field_49266, ops).orElse(class_1799.field_8037);
        return getStateToPaveWith(filter);
    }

    protected class_2680 getStateToPaveWithAsSlab(MovementContext context) {
        class_2680 stateToPaveWith = getStateToPaveWith(context);
        if (stateToPaveWith.method_28498(class_2482.field_11501))
            return stateToPaveWith.method_11657(class_2482.field_11501, class_2771.field_12681);

        class_2248 block = stateToPaveWith.method_26204();
        if (block == null)
            return null;

        class_2960 rl = class_7923.field_41175.method_10221(block);
        String namespace = rl.method_12836();
        String blockName = rl.method_12832();
        int nameLength = blockName.length();

        List<String> possibleSlabLocations = new ArrayList<>();
        possibleSlabLocations.add(blockName + "_slab");

        if (blockName.endsWith("s") && nameLength > 1)
            possibleSlabLocations.add(blockName.substring(0, nameLength - 1) + "_slab");
        if (blockName.endsWith("planks") && nameLength > 7)
            possibleSlabLocations.add(blockName.substring(0, nameLength - 7) + "_slab");

        for (String locationAttempt : possibleSlabLocations) {
            Optional<class_2248> result = class_7923.field_41175.method_17966(class_2960.method_60655(namespace, locationAttempt));
            if (result.isEmpty())
                continue;
            return result.get().method_9564();
        }

        return null;
    }

    protected RollingMode getMode(MovementContext context) {
        return RollingMode.values()[context.blockEntityData.method_68083("ScrollValue", 0)];
    }

    private static final class RollerTravellingPoint extends TravellingPoint {

        public BiConsumer<TrackEdge, Couple<Double>> traversalCallback;

        @Override
        protected Double edgeTraversedFrom(
            TrackGraph graph,
            boolean forward,
            IEdgePointListener edgePointListener,
            ITurnListener turnListener,
            double prevPos,
            double totalDistance
        ) {
            double from = forward ? prevPos : position;
            double to = forward ? position : prevPos;
            traversalCallback.accept(edge, Couple.create(from, to));
            return super.edgeTraversedFrom(graph, forward, edgePointListener, turnListener, prevPos, totalDistance);
        }

    }

    protected enum PaveResult {
        FAIL,
        PASS,
        SUCCESS;
    }

    protected PaveResult tryFill(MovementContext context, class_2338 targetPos, class_2680 toPlace) {
        class_1937 level = context.world;
        if (!level.method_8477(targetPos))
            return PaveResult.FAIL;
        class_2680 existing = level.method_8320(targetPos);
        if (existing.method_27852(toPlace.method_26204()))
            return PaveResult.PASS;
        if (!existing.method_26164(class_3481.field_15503) && !existing.method_45474() && (!existing.method_26220(level, targetPos)
            .method_1110() || existing.method_26164(class_3481.field_21780)))
            return PaveResult.FAIL;

        FilterItemStack filter = context.getFilterFromBE();
        class_1263 inventory = context.contraption.getStorage().getAllItems();
        class_1799 held = inventory.extract(stack -> filter.test(context.world, stack), 1);
        if (held.method_7960())
            return PaveResult.FAIL;

        level.method_8501(targetPos, toPlace);
        return PaveResult.SUCCESS;
    }

}
