package com.zurrtum.create.content.contraptions.elevator;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn.ColumnCoords;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class ElevatorContactBlockEntity extends SmartBlockEntity {

    public DoorControlBehaviour doorControls;
    public ColumnCoords columnCoords;
    public boolean activateBlock;

    public String shortName;
    public String longName;

    public String lastReportedCurrentFloor = "";

    private int yTargetFromNBT = Integer.MIN_VALUE;
    private boolean deferNameGenerator;

    public ElevatorContactBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ELEVATOR_CONTACT, pos, state);
        shortName = "";
        longName = "";
        deferNameGenerator = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(doorControls = new DoorControlBehaviour(this));
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);

        view.method_71469("ShortName", shortName);
        view.method_71469("LongName", longName);

        if (lastReportedCurrentFloor != null)
            view.method_71469("LastReportedCurrentFloor", lastReportedCurrentFloor);

        if (clientPacket)
            return;
        view.method_71472("Activate", activateBlock);
        if (columnCoords == null)
            return;

        ElevatorColumn column = ElevatorColumn.get(field_11863, columnCoords);
        if (column == null)
            return;
        view.method_71465("ColumnTarget", column.getTargetedYLevel());
        if (column.isActive())
            view.method_71472("ColumnActive", true);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);

        shortName = view.method_71428("ShortName", "");
        longName = view.method_71428("LongName", "");

        lastReportedCurrentFloor = view.method_71428("LastReportedCurrentFloor", null);

        if (clientPacket)
            return;
        activateBlock = view.method_71433("Activate", false);
        Optional<Integer> columnTarget = view.method_71439("ColumnTarget");
        if (columnTarget.isEmpty())
            return;

        int target = columnTarget.get();
        boolean active = view.method_71433("ColumnActive", false);

        if (columnCoords == null) {
            yTargetFromNBT = target;
            return;
        }

        ElevatorColumn column = ElevatorColumn.getOrCreate(field_11863, columnCoords);
        column.target(target);
        column.setActive(active);
    }

    public void updateDisplayedFloor(String floor) {
        if (floor.equals(lastReportedCurrentFloor))
            return;
        lastReportedCurrentFloor = floor;
        DisplayLinkBlock.notifyGatherers(field_11863, field_11867);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (field_11863.method_8608())
            return;
        columnCoords = ElevatorContactBlock.getColumnCoords(field_11863, field_11867);
        if (columnCoords == null)
            return;
        ElevatorColumn column = ElevatorColumn.getOrCreate(field_11863, columnCoords);
        column.add(field_11867);
        if (shortName.isBlank())
            deferNameGenerator = true;
        if (yTargetFromNBT == Integer.MIN_VALUE)
            return;
        column.target(yTargetFromNBT);
        yTargetFromNBT = Integer.MIN_VALUE;
    }

    @Override
    public void tick() {
        super.tick();
        if (!deferNameGenerator)
            return;
        if (columnCoords != null)
            ElevatorColumn.getOrCreate(field_11863, columnCoords).initNames(field_11863);
        deferNameGenerator = false;
    }

    @Override
    public void invalidate() {
        if (columnCoords != null) {
            ElevatorColumn column = ElevatorColumn.get(field_11863, columnCoords);
            if (column != null)
                column.remove(field_11867);
        }
        super.invalidate();
    }

    public void updateName(String shortName, String longName) {
        this.shortName = shortName;
        this.longName = longName;
        this.deferNameGenerator = false;
        notifyUpdate();

        ElevatorColumn column = ElevatorColumn.get(field_11863, columnCoords);
        if (column != null)
            column.namesChanged();
    }

    public Couple<String> getNames() {
        return Couple.create(shortName, longName);
    }

}
