package com.zurrtum.create.content.contraptions.elevator;

import com.zurrtum.create.*;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn.ColumnCoords;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.RequestFloorListPacket;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class ElevatorPulleyBlockEntity extends PulleyBlockEntity {

    private float prevSpeed;
    private boolean arrived;
    private int clientOffsetTarget;
    private boolean initialOffsetReceived;

    public ElevatorPulleyBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ELEVATOR_PULLEY, pos, state);
        prevSpeed = 0;
        arrived = true;
        initialOffsetReceived = false;
    }

    private int getTargetOffset() {
        if (field_11863.field_9236)
            return clientOffsetTarget;
        if (movedContraption == null || !(movedContraption.getContraption() instanceof ElevatorContraption ec))
            return (int) offset;

        Integer target = ec.getCurrentTargetY(field_11863);
        if (target == null)
            return (int) offset;

        return field_11867.method_10264() - target + ec.contactYOffset - 1;
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        super.attach(contraption);
        if (offset >= 0)
            resetContraptionToOffset();
        if (field_11863.field_9236) {
            AllClientHandle.INSTANCE.sendPacket(new RequestFloorListPacket(contraption));
            return;
        }

        if (contraption.getContraption() instanceof ElevatorContraption ec)
            ElevatorColumn.getOrCreate(field_11863, ec.getGlobalColumn()).setActive(true);
    }

    @Override
    public void tick() {
        boolean wasArrived = arrived;
        super.tick();

        if (movedContraption == null)
            return;
        if (!(movedContraption.getContraption() instanceof ElevatorContraption ec))
            return;
        if (field_11863.method_8608())
            ec.setClientYTarget(field_11867.method_10264() - clientOffsetTarget + ec.contactYOffset - 1);

        waitingForSpeedChange = false;
        ec.arrived = wasArrived;

        if (!arrived)
            return;

        double y = movedContraption.method_23318();
        int targetLevel = class_3532.method_15357(0.5f + y) + ec.contactYOffset;

        Integer ecCurrentTargetY = ec.getCurrentTargetY(field_11863);
        if (ecCurrentTargetY != null)
            targetLevel = ecCurrentTargetY;
        if (field_11863.method_8608())
            targetLevel = ec.clientYTarget;
        if (!wasArrived && !field_11863.method_8608()) {
            triggerContact(ec, targetLevel - ec.contactYOffset);
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.play(field_11863, null, field_11867.method_10087((int) offset), 0.75f, 0.8f);
        }

        double diff = targetLevel - y - ec.contactYOffset;
        if (Math.abs(diff) > 1f / 128)
            diff *= 0.25f;
        movedContraption.method_33574(movedContraption.method_19538().method_1031(0, diff, 0));
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (field_11863.method_8608() || !arrived)
            return;
        if (movedContraption == null || !movedContraption.method_5805())
            return;
        if (!(movedContraption.getContraption() instanceof ElevatorContraption ec))
            return;
        if (getTargetOffset() != (int) offset)
            return;

        double y = movedContraption.method_23318();
        int targetLevel = class_3532.method_15357(0.5f + y);
        triggerContact(ec, targetLevel);
    }

    private void triggerContact(ElevatorContraption ec, int targetLevel) {
        ColumnCoords coords = ec.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get(field_11863, coords);
        if (column == null)
            return;

        class_2338 contactPos = column.contactAt(targetLevel + ec.contactYOffset);
        if (!field_11863.method_8477(contactPos))
            return;
        class_2680 contactState = field_11863.method_8320(contactPos);
        if (!contactState.method_27852(AllBlocks.ELEVATOR_CONTACT))
            return;
        if (contactState.method_11654(ElevatorContactBlock.POWERING))
            return;

        ElevatorContactBlock ecb = AllBlocks.ELEVATOR_CONTACT;
        ecb.withBlockEntityDo(field_11863, contactPos, be -> be.activateBlock = true);
        ecb.scheduleActivation(field_11863, contactPos);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket)
            view.method_71465("ClientTarget", clientOffsetTarget);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (!clientPacket)
            return;

        clientOffsetTarget = view.method_71424("ClientTarget", 0);
        if (initialOffsetReceived)
            return;

        offset = view.method_71423("Offset", 0);
        initialOffsetReceived = true;
        resetContraptionToOffset();
    }

    @Override
    public float getMovementSpeed() {
        int currentTarget = getTargetOffset();

        if (!field_11863.method_8608() && currentTarget != clientOffsetTarget) {
            clientOffsetTarget = currentTarget;
            sendData();
        }

        float diff = currentTarget - offset;
        float movementSpeed = class_3532.method_15363(convertToLinear(getSpeed() * 2), -1.99f, 1.99f);
        float rpmLimit = Math.abs(movementSpeed);

        float configacc = class_3532.method_16439(Math.abs(movementSpeed), 0.0075f, 0.0175f);
        float decelleration = (float) Math.sqrt(2 * Math.abs(diff) * configacc);

        float speed = diff;
        speed = class_3532.method_15363(speed, -rpmLimit, rpmLimit);
        speed = class_3532.method_15363(speed, prevSpeed - configacc, prevSpeed + configacc);
        speed = class_3532.method_15363(speed, -decelleration, decelleration);

        arrived = Math.abs(diff) < 0.5f;

        if (speed > 1 / 1024f && !field_11863.method_8608())
            method_5431();

        return prevSpeed = speed;
    }

    @Override
    protected boolean shouldCreateRopes() {
        return false;
    }

    @Override
    public void disassemble() {
        if (movedContraption != null && movedContraption.getContraption() instanceof ElevatorContraption ec) {
            ElevatorColumn column = ElevatorColumn.get(field_11863, ec.getGlobalColumn());
            if (column != null)
                column.setActive(false);
        }

        super.disassemble();
        offset = -1;
        sendData();
    }

    public void clicked() {
        if (isPassive() && field_11863.method_8321(mirrorParent) instanceof ElevatorPulleyBlockEntity parent) {
            parent.clicked();
            return;
        }

        if (running)
            disassemble();
        else
            assembleNextTick = true;
    }

    @Override
    protected boolean moveAndCollideContraption() {
        if (arrived)
            return false;
        super.moveAndCollideContraption();
        return false;
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    protected void assemble() throws AssemblyException {
        if (!(field_11863.method_8320(field_11867).method_26204() instanceof ElevatorPulleyBlock))
            return;
        if (getSpeed() == 0)
            return;

        int maxLength = AllConfigs.server().kinetics.maxRopeLength.get();
        int i = 1;
        while (i <= maxLength) {
            class_2338 ropePos = field_11867.method_10087(i);
            class_2680 ropeState = field_11863.method_8320(ropePos);
            if (!ropeState.method_26220(field_11863, ropePos).method_1110() && !ropeState.method_45474()) {
                break;
            }
            ++i;
        }

        offset = i - 1;
        forceMove = true;

        // Collect Construct
        if (!field_11863.field_9236 && mirrorParent == null) {
            needsContraption = false;
            class_2338 anchor = field_11867.method_10087(class_3532.method_15375(offset + 1));
            offset = class_3532.method_15375(offset);
            ElevatorContraption contraption = new ElevatorContraption((int) offset);

            float offsetOnSucess = offset;
            offset = 0;

            boolean canAssembleStructure = contraption.assemble(field_11863, anchor);
            if (!canAssembleStructure && getSpeed() > 0)
                return;

            if (!contraption.getBlocks().isEmpty()) {
                offset = offsetOnSucess;
                contraption.removeBlocksFromWorld(field_11863, class_2338.field_10980);
                movedContraption = ControlledContraptionEntity.create(field_11863, this, contraption);
                movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
                contraption.maxContactY = field_11867.method_10264() + contraption.contactYOffset - 1;
                contraption.minContactY = contraption.maxContactY - maxLength;
                field_11863.method_8649(movedContraption);
                forceMove = true;
                needsContraption = true;

                if (contraption.containsBlockBreakers())
                    award(AllAdvancements.CONTRAPTION_ACTORS);

                for (class_2338 pos : contraption.createColliders(field_11863, class_2350.field_11036)) {
                    if (pos.method_10264() != 0)
                        continue;
                    pos = pos.method_10081(anchor);
                    if (field_11863.method_8321(new class_2338(pos.method_10263(), this.field_11867.method_10264(), pos.method_10260())) instanceof ElevatorPulleyBlockEntity pbe)
                        pbe.startMirroringOther(this.field_11867);
                }

                ElevatorColumn column = ElevatorColumn.getOrCreate(field_11863, contraption.getGlobalColumn());
                int target = (int) (field_11867.method_10264() + contraption.contactYOffset - 1 - offset);
                column.target(target);
                column.gatherAll();
                column.setActive(true);
                column.markDirty();

                contraption.broadcastFloorData(field_11863, column.contactAt(target));
                clientOffsetTarget = column.getTargetedYLevel();
                arrived = true;
            }
        }

        clientOffsetDiff = 0;
        running = true;
        sendData();
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        method_5431();
    }

    @Override
    protected MovementMode getMovementMode() {
        return MovementMode.MOVE_NEVER_PLACE;
    }

}
