package com.zurrtum.create.content.contraptions.gantry;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class GantryCarriageBlockEntity extends KineticBlockEntity {

    boolean assembleNextTick;
    protected AssemblyException lastException;

    public GantryCarriageBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.GANTRY_PINION, pos, state);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
    }

    public void checkValidGantryShaft() {
        if (shouldAssemble())
            queueAssembly();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!method_11010().method_26184(field_11863, field_11867))
            field_11863.method_22352(field_11867, true);
    }

    public void queueAssembly() {
        assembleNextTick = true;
    }

    @Override
    public void tick() {
        super.tick();

        if (field_11863.field_9236)
            return;

        if (assembleNextTick) {
            tryAssemble();
            assembleNextTick = false;
        }
    }

    public AssemblyException getLastAssemblyException() {
        return lastException;
    }

    private void tryAssemble() {
        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof GantryCarriageBlock))
            return;

        class_2350 direction = blockState.method_11654(GantryCarriageBlock.FACING);
        GantryContraption contraption = new GantryContraption(direction);

        class_2586 blockEntity = field_11863.method_8321(field_11867.method_10093(direction.method_10153()));
        if (!(blockEntity instanceof GantryShaftBlockEntity shaftBE))
            return;
        class_2680 shaftState = shaftBE.method_11010();
        if (shaftState.method_26204() != AllBlocks.GANTRY_SHAFT)
            return;

        float pinionMovementSpeed = shaftBE.getPinionMovementSpeed();
        class_2350 shaftOrientation = shaftState.method_11654(GantryShaftBlock.FACING);
        class_2350 movementDirection = shaftOrientation;
        if (pinionMovementSpeed < 0)
            movementDirection = movementDirection.method_10153();

        try {
            lastException = null;
            if (!contraption.assemble(field_11863, field_11867))
                return;

            sendData();
        } catch (AssemblyException e) {
            lastException = e;
            sendData();
            return;
        }
        if (ContraptionCollider.isCollidingWithWorld(field_11863, contraption, field_11867.method_10093(movementDirection), movementDirection))
            return;

        if (contraption.containsBlockBreakers())
            award(AllAdvancements.CONTRAPTION_ACTORS);

        contraption.removeBlocksFromWorld(field_11863, class_2338.field_10980);
        GantryContraptionEntity movedContraption = GantryContraptionEntity.create(field_11863, contraption, shaftOrientation);
        class_2338 anchor = field_11867;
        movedContraption.method_23327(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(field_11863, field_11867);
        field_11863.method_8649(movedContraption);

        if (shaftBE.sequenceContext != null && shaftBE.sequenceContext.instruction() == SequencerInstructions.TURN_DISTANCE)
            movedContraption.limitMovement(shaftBE.sequenceContext.getEffectiveValue(shaftBE.getTheoreticalSpeed()));
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        if (lastException != null) {
            view.method_71468("LastException", AssemblyException.CODEC, lastException);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        lastException = view.method_71426("LastException", AssemblyException.CODEC).orElse(null);
        super.read(view, clientPacket);
    }

    @Override
    public float propagateRotationTo(
        KineticBlockEntity target,
        class_2680 stateFrom,
        class_2680 stateTo,
        class_2338 diff,
        boolean connectedViaAxes,
        boolean connectedViaCogs
    ) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);

        if (connectedViaAxes)
            return defaultModifier;
        if (!stateTo.method_27852(AllBlocks.GANTRY_SHAFT))
            return defaultModifier;
        if (!stateTo.method_11654(GantryShaftBlock.POWERED))
            return defaultModifier;

        class_2350 direction = class_2350.method_10147(diff.method_10263(), diff.method_10264(), diff.method_10260());
        if (stateFrom.method_11654(GantryCarriageBlock.FACING) != direction.method_10153())
            return defaultModifier;
        return getGantryPinionModifier(stateTo.method_11654(GantryShaftBlock.FACING), stateFrom.method_11654(GantryCarriageBlock.FACING));
    }

    public static float getGantryPinionModifier(class_2350 shaft, class_2350 pinionDirection) {
        class_2351 shaftAxis = shaft.method_10166();
        float directionModifier = shaft.method_10171().method_10181();
        if (shaftAxis == class_2351.field_11052)
            if (pinionDirection == class_2350.field_11043 || pinionDirection == class_2350.field_11034)
                return -directionModifier;
        if (shaftAxis == class_2351.field_11048)
            if (pinionDirection == class_2350.field_11033 || pinionDirection == class_2350.field_11035)
                return -directionModifier;
        if (shaftAxis == class_2351.field_11051)
            if (pinionDirection == class_2350.field_11036 || pinionDirection == class_2350.field_11039)
                return -directionModifier;
        return directionModifier;
    }

    private boolean shouldAssemble() {
        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof GantryCarriageBlock))
            return false;
        class_2350 facing = blockState.method_11654(GantryCarriageBlock.FACING).method_10153();
        class_2680 shaftState = field_11863.method_8320(field_11867.method_10093(facing));
        if (!(shaftState.method_26204() instanceof GantryShaftBlock))
            return false;
        if (shaftState.method_11654(GantryShaftBlock.POWERED))
            return false;
        class_2586 be = field_11863.method_8321(field_11867.method_10093(facing));
        return be instanceof GantryShaftBlockEntity && ((GantryShaftBlockEntity) be).canAssembleOn();
    }
}