package com.zurrtum.create.content.contraptions.mounted;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.redstone.rail.ControllerRailBlock;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class CartAssemblerBlockItem extends class_1747 {

    public CartAssemblerBlockItem(class_2248 block, class_1793 properties) {
        super(block, properties);
    }

    @NotNull
    @Override
    public class_1269 method_7884(class_1838 context) {
        if (tryPlaceAssembler(context)) {
            context.method_8045().method_8396(null, context.method_8037(), class_3417.field_14574, class_3419.field_15245, 1, 1);
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public boolean tryPlaceAssembler(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_1657 player = context.method_8036();

        if (player == null)
            return false;
        if (!(block instanceof class_2241 abstractRailBlock)) {
            player.method_7353(class_2561.method_43471("create.block.cart_assembler.invalid"), true);
            return false;
        }

        class_2768 shape = state.method_11654(abstractRailBlock.method_9474());
        if (shape != class_2768.field_12674 && shape != class_2768.field_12665)
            return false;

        class_2680 newState = AllBlocks.CART_ASSEMBLER.method_9564().method_11657(CartAssemblerBlock.RAIL_SHAPE, shape);
        CartAssembleRailType newType = null;
        for (CartAssembleRailType type : CartAssembleRailType.values())
            if (type.matches(state))
                newType = type;
        if (newType == null)
            return false;
        if (world.field_9236)
            return true;

        newState = newState.method_11657(CartAssemblerBlock.RAIL_TYPE, newType);
        if (state.method_28498(ControllerRailBlock.BACKWARDS))
            newState = newState.method_11657(CartAssemblerBlock.BACKWARDS, state.method_11654(ControllerRailBlock.BACKWARDS));
        else {
            class_2350 direction = player.method_5755();
            newState = newState.method_11657(CartAssemblerBlock.BACKWARDS, direction.method_10171() == class_2352.field_11056);
        }

        world.method_8501(pos, newState);
        if (!player.method_68878())
            context.method_8041().method_7934(1);

        AdvancementBehaviour.setPlacedBy(world, pos, player);
        return true;
    }
}
