package com.zurrtum.create.content.decoration.copycat;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2533;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class CopycatPanelBlock extends WaterloggedCopycatBlock {

    public static final class_2754<class_2350> FACING = class_2741.field_12525;

    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public CopycatPanelBlock(class_2251 pProperties) {
        super(pProperties);
        method_9590(method_9564().method_11657(FACING, class_2350.field_11036));
    }

    @Override
    public boolean isAcceptedRegardless(class_2680 material) {
        return CopycatSpecialCases.isBarsMaterial(material) || CopycatSpecialCases.isTrapdoorMaterial(material);
    }

    @Override
    public class_2680 prepareMaterial(
        class_1937 pLevel,
        class_2338 pPos,
        class_2680 pState,
        class_1657 pPlayer,
        class_1268 pHand,
        class_3965 pHit,
        class_2680 material
    ) {
        if (!CopycatSpecialCases.isTrapdoorMaterial(material))
            return super.prepareMaterial(pLevel, pPos, pState, pPlayer, pHand, pHit, material);

        class_2350 panelFacing = pState.method_11654(FACING);
        if (panelFacing == class_2350.field_11033)
            material = material.method_11657(class_2533.field_11625, class_2760.field_12619);
        if (panelFacing.method_10166() == class_2351.field_11052)
            return material.method_11657(class_2533.field_11177, pPlayer.method_5735()).method_11657(class_2533.field_11631, false);

        boolean clickedNearTop = pHit.method_17784().field_1351 - .5 > pPos.method_10264();
        return material.method_11657(class_2533.field_11631, true).method_11657(class_2533.field_11625, clickedNearTop ? class_2760.field_12619 : class_2760.field_12617)
            .method_11657(class_2533.field_11177, panelFacing);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!player.method_5715() && player.method_7294()) {
            IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
            if (placementHelper.matchesItem(stack)) {
                placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);
                return class_1269.field_5812;
            }
        }

        return super.method_55765(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public boolean isIgnoredConnectivitySide(
        class_1920 reader,
        class_2680 state,
        class_2350 face,
        @Nullable class_2338 fromPos,
        @Nullable class_2338 toPos
    ) {
        if (fromPos == null || toPos == null)
            return true;

        class_2350 facing = state.method_11654(FACING);
        class_2680 toState = reader.method_8320(toPos);

        if (!toState.method_27852(this))
            return facing != face.method_10153();

        class_2338 diff = fromPos.method_10059(toPos);
        int coord = facing.method_10166().method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260());
        return facing == toState.method_11654(FACING).method_10153() && !(coord != 0 && coord == facing.method_10171().method_10181());
    }

    @Override
    public boolean canConnectTexturesToward(class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 state) {
        class_2350 facing = state.method_11654(FACING);
        class_2680 toState = reader.method_8320(toPos);

        if (toPos.equals(fromPos.method_10093(facing)))
            return false;

        class_2338 diff = fromPos.method_10059(toPos);
        int coord = facing.method_10166().method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260());

        if (!toState.method_27852(this))
            return coord != -facing.method_10171().method_10181();

        if (isOccluded(state, toState, facing))
            return true;
        return toState.method_11657(WATERLOGGED, false) == state.method_11657(WATERLOGGED, false) && coord == 0;
    }

    @Override
    public boolean canFaceBeOccluded(class_2680 state, class_2350 face) {
        return state.method_11654(FACING).method_10153() == face;
    }

    @Override
    public boolean shouldFaceAlwaysRender(class_2680 state, class_2350 face) {
        return canFaceBeOccluded(state, face.method_10153());
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 stateForPlacement = super.method_9605(pContext);
        return stateForPlacement.method_11657(FACING, pContext.method_7715().method_10153());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(FACING));
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.CASING_3PX.get(pState.method_11654(FACING));
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    //TODO
    //    @Override
    //    public boolean supportsExternalFaceHiding(BlockState state) {
    //        return true;
    //    }

    //TODO
    //    @Override
    //    public boolean hidesNeighborFace(BlockView level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
    //        if (state.isOf(this) == neighborState.isOf(this)) {
    //            if (CopycatSpecialCases.isBarsMaterial(getMaterial(level, pos)) && CopycatSpecialCases.isBarsMaterial(getMaterial(
    //                level,
    //                pos.offset(dir)
    //            )))
    //                return state.get(FACING) == neighborState.get(FACING);
    //            if (getMaterial(level, pos).skipRendering(getMaterial(level, pos.offset(dir)), dir.getOpposite()))
    //                return isOccluded(state, neighborState, dir.getOpposite());
    //        }
    //
    //        return state.get(FACING) == dir.getOpposite() && getMaterial(level, pos).skipRendering(neighborState, dir.getOpposite());
    //    }

    public static boolean isOccluded(class_2680 state, class_2680 other, class_2350 pDirection) {
        state = state.method_11657(WATERLOGGED, false);
        other = other.method_11657(WATERLOGGED, false);
        class_2350 facing = state.method_11654(FACING);
        if (facing.method_10153() == other.method_11654(FACING) && pDirection == facing)
            return true;
        if (other.method_11654(FACING) != facing)
            return false;
        return pDirection.method_10166() != facing.method_10166();
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return state.method_11657(FACING, rot.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345(state.method_11654(FACING)));
    }

    private static class PlacementHelper implements IPlacementHelper {
        @Override
        public Predicate<class_1799> getItemPredicate() {
            return stack -> stack.method_31574(AllItems.COPYCAT_PANEL);
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return state -> state.method_27852(AllBlocks.COPYCAT_PANEL);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(
                pos,
                ray.method_17784(),
                state.method_11654(FACING).method_10166(),
                dir -> world.method_8320(pos.method_10093(dir)).method_45474()
            );

            if (directions.isEmpty())
                return PlacementOffset.fail();
            else {
                return PlacementOffset.success(pos.method_10093(directions.getFirst()), s -> s.method_11657(FACING, state.method_11654(FACING)));
            }
        }
    }

}
