package com.zurrtum.create.content.decoration.girder;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.content.decoration.bracket.BracketBlock;
import com.zurrtum.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.zurrtum.create.content.decoration.placard.PlacardBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.logistics.chute.AbstractChuteBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.trains.display.FlapDisplayBlock;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2544;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3749;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5172;
import net.minecraft.class_5819;

import static net.minecraft.class_2341.field_11007;
import static net.minecraft.class_2741.field_12508;

public class GirderBlock extends class_2248 implements class_3737, IWrenchable {

    private static final int placementHelperId = PlacementHelpers.register(new GirderPlacementHelper());

    public static final class_2746 X = class_2746.method_11825("x");
    public static final class_2746 Z = class_2746.method_11825("z");
    public static final class_2746 TOP = class_2746.method_11825("top");
    public static final class_2746 BOTTOM = class_2746.method_11825("bottom");
    public static final class_2754<class_2351> AXIS = class_2741.field_12496;

    public GirderBlock(class_2251 p_49795_) {
        super(p_49795_);
        method_9590(method_9564().method_11657(field_12508, false).method_11657(AXIS, class_2351.field_11052).method_11657(TOP, false).method_11657(BOTTOM, false).method_11657(X, false)
            .method_11657(Z, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(X, Z, TOP, BOTTOM, AXIS, field_12508));
    }

    @Override
    public class_265 method_25959(class_2680 pState, class_1922 pReader, class_2338 pPos) {
        return class_259.method_1084(super.method_25959(pState, pReader, pPos), AllShapes.EIGHT_VOXEL_POLE.get(class_2351.field_11052));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player == null)
            return class_1269.field_52423;

        if (stack.method_31574(AllItems.SHAFT)) {
            KineticBlockEntity.switchToBlockState(
                level,
                pos,
                AllBlocks.METAL_GIRDER_ENCASED_SHAFT.method_9564().method_11657(field_12508, state.method_11654(field_12508)).method_11657(TOP, state.method_11654(TOP))
                    .method_11657(BOTTOM, state.method_11654(BOTTOM))
                    .method_11657(GirderEncasedShaftBlock.HORIZONTAL_AXIS, state.method_11654(X) || hitResult.method_17780().method_10166() == class_2351.field_11051 ? class_2351.field_11051 : class_2351.field_11048)
            );

            level.method_8396(null, pos, class_3417.field_21922, class_3419.field_15245, 0.5f, 1.25f);
            if (!level.field_9236 && !player.method_68878()) {
                stack.method_7934(1);
                if (stack.method_7960())
                    player.method_6122(hand, class_1799.field_8037);
            }

            return class_1269.field_5812;
        }

        if (stack.method_31574(AllItems.WRENCH) && !player.method_5715()) {
            if (GirderWrenchBehavior.handleClick(level, pos, state, hitResult))
                return class_1269.field_5812;
            return class_1269.field_5814;
        }

        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(stack))
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);

        return class_1269.field_52423;
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return class_1269.field_5811;
    }

    @Override
    public void method_9588(class_2680 p_60462_, class_3218 p_60463_, class_2338 p_60464_, class_5819 p_60465_) {
        class_2248.method_30094(p_60462_, class_2248.method_9510(p_60462_, p_60463_, p_60464_), p_60463_, p_60464_, 3);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        class_2351 axis = direction.method_10166();

        if (direction.method_10166() != class_2351.field_11052) {
            if (state.method_11654(AXIS) != direction.method_10166()) {
                class_2769<Boolean> updateProperty = axis == class_2351.field_11048 ? X : axis == class_2351.field_11051 ? Z : direction == class_2350.field_11036 ? TOP : BOTTOM;
                if (!isConnected(world, pos, state, direction) && !isConnected(world, pos, state, direction.method_10153()))
                    state = state.method_11657(updateProperty, false);
            }
        } else if (state.method_11654(AXIS) != class_2351.field_11052) {
            if (world.method_8320(pos.method_10084()).method_26222(world, pos.method_10084()).method_1110())
                state = state.method_11657(TOP, false);
            if (world.method_8320(pos.method_10074()).method_26222(world, pos.method_10074()).method_1110())
                state = state.method_11657(BOTTOM, false);
        }

        for (class_2350 d : Iterate.directionsInAxis(axis))
            state = updateState(world, pos, state, d);

        return state;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 face = context.method_8038();
        class_3610 ifluidstate = level.method_8316(pos);
        class_2680 state = super.method_9605(context);
        state = state.method_11657(X, face.method_10166() == class_2351.field_11048);
        state = state.method_11657(Z, face.method_10166() == class_2351.field_11051);
        state = state.method_11657(AXIS, face.method_10166());

        for (class_2350 d : Iterate.directions)
            state = updateState(level, pos, state, d);

        return state.method_11657(field_12508, ifluidstate.method_15772() == class_3612.field_15910);
    }

    public static class_2680 updateState(class_4538 level, class_2338 pos, class_2680 state, class_2350 d) {
        class_2351 axis = d.method_10166();
        class_2769<Boolean> updateProperty = axis == class_2351.field_11048 ? X : axis == class_2351.field_11051 ? Z : d == class_2350.field_11036 ? TOP : BOTTOM;
        class_2680 sideState = level.method_8320(pos.method_10093(d));

        if (axis.method_10178())
            return updateVerticalProperty(level, pos, state, updateProperty, sideState, d);

        if (state.method_11654(AXIS) == axis)
            state = state.method_11657(updateProperty, true);
        else if (sideState.method_26204() instanceof GirderEncasedShaftBlock && sideState.method_11654(GirderEncasedShaftBlock.HORIZONTAL_AXIS) != axis)
            state = state.method_11657(updateProperty, true);
        else if (sideState.method_26204() == state.method_26204() && sideState.method_11654(updateProperty))
            state = state.method_11657(updateProperty, true);
        else if (sideState.method_26204() instanceof NixieTubeBlock && NixieTubeBlock.getFacing(sideState) == d)
            state = state.method_11657(updateProperty, true);
        else if (sideState.method_26204() instanceof PlacardBlock && PlacardBlock.connectedDirection(sideState) == d)
            state = state.method_11657(updateProperty, true);
        else if (isFacingBracket(level, pos, d))
            state = state.method_11657(updateProperty, true);

        for (class_2350 d2 : Iterate.directionsInAxis(axis == class_2351.field_11048 ? class_2351.field_11051 : class_2351.field_11048)) {
            class_2680 above = level.method_8320(pos.method_10084().method_10093(d2));
            if (above.method_26164(AllBlockTags.GIRDABLE_TRACKS)) {
                TrackShape shape = above.method_11654(TrackBlock.SHAPE);
                if (shape == (axis == class_2351.field_11048 ? TrackShape.XO : TrackShape.ZO))
                    state = state.method_11657(updateProperty, true);
            }
        }

        return state;
    }

    public static boolean isFacingBracket(class_1920 level, class_2338 pos, class_2350 d) {
        class_2586 blockEntity = level.method_8321(pos.method_10093(d));
        if (!(blockEntity instanceof SmartBlockEntity sbe))
            return false;
        BracketedBlockEntityBehaviour behaviour = sbe.getBehaviour(BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null)
            return false;
        class_2680 bracket = behaviour.getBracket();
        if (bracket == null || !bracket.method_28498(BracketBlock.field_10927))
            return false;
        return bracket.method_11654(BracketBlock.field_10927) == d;
    }

    public static class_2680 updateVerticalProperty(
        class_4538 level,
        class_2338 pos,
        class_2680 state,
        class_2769<Boolean> updateProperty,
        class_2680 sideState,
        class_2350 d
    ) {
        boolean canAttach = false;

        if (state.method_28498(AXIS) && state.method_11654(AXIS) == class_2351.field_11052)
            canAttach = true;
        else if (isGirder(sideState) && isXGirder(sideState) == isZGirder(sideState))
            canAttach = true;
        else if (isGirder(sideState))
            canAttach = true;
        else if (sideState.method_28498(class_2544.field_11717) && sideState.method_11654(class_2544.field_11717))
            canAttach = true;
        else if (sideState.method_26204() instanceof NixieTubeBlock && NixieTubeBlock.getFacing(sideState) == d)
            canAttach = true;
        else if (sideState.method_26204() instanceof FlapDisplayBlock)
            canAttach = true;
        else if (sideState.method_26204() instanceof class_3749 && (d == class_2350.field_11033) == (sideState.method_11654(class_3749.field_16545)))
            canAttach = true;
        else if (sideState.method_26204() instanceof class_5172 && sideState.method_11654(class_5172.field_11459) == class_2351.field_11052)
            canAttach = true;
        else if (sideState.method_28498(field_11007)) {
            if (sideState.method_11654(field_11007) == class_2738.field_12473 && d == class_2350.field_11033)
                canAttach = true;
            else if (sideState.method_11654(field_11007) == class_2738.field_12475 && d == class_2350.field_11036)
                canAttach = true;
        } else if (sideState.method_26204() instanceof PlacardBlock && PlacardBlock.connectedDirection(sideState) == d)
            canAttach = true;
        else if (isFacingBracket(level, pos, d))
            canAttach = true;

        if (canAttach)
            return state.method_11657(updateProperty, true);
        return state;
    }

    public static boolean isGirder(class_2680 state) {
        return state.method_26204() instanceof GirderBlock || state.method_26204() instanceof GirderEncasedShaftBlock;
    }

    public static boolean isXGirder(class_2680 state) {
        return (state.method_26204() instanceof GirderBlock && state.method_11654(X)) || (state.method_26204() instanceof GirderEncasedShaftBlock && state.method_11654(
            GirderEncasedShaftBlock.HORIZONTAL_AXIS) == class_2351.field_11051);
    }

    public static boolean isZGirder(class_2680 state) {
        return (state.method_26204() instanceof GirderBlock && state.method_11654(Z)) || (state.method_26204() instanceof GirderEncasedShaftBlock && state.method_11654(
            GirderEncasedShaftBlock.HORIZONTAL_AXIS) == class_2351.field_11048);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        boolean x = state.method_11654(GirderBlock.X);
        boolean z = state.method_11654(GirderBlock.Z);
        return x ? z ? AllShapes.GIRDER_CROSS : AllShapes.GIRDER_BEAM.get(class_2351.field_11048) : z ? AllShapes.GIRDER_BEAM.get(class_2351.field_11051) : AllShapes.EIGHT_VOXEL_POLE.get(
            class_2351.field_11052);
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public static boolean isConnected(class_1920 world, class_2338 pos, class_2680 state, class_2350 side) {
        class_2351 axis = side.method_10166();
        if (state.method_26204() instanceof GirderBlock && !state.method_11654(axis == class_2351.field_11048 ? X : Z))
            return false;
        if (state.method_26204() instanceof GirderEncasedShaftBlock && state.method_11654(GirderEncasedShaftBlock.HORIZONTAL_AXIS) == axis)
            return false;
        class_2338 relative = pos.method_10093(side);
        class_2680 blockState = world.method_8320(relative);
        if (blockState.method_26215())
            return false;
        if (blockState.method_26204() instanceof NixieTubeBlock && NixieTubeBlock.getFacing(blockState) == side)
            return true;
        if (isFacingBracket(world, pos, side))
            return true;
        //TODO
        //        if (blockState.getBlock() instanceof PlacardBlock && PlacardBlock.connectedDirection(blockState) == side)
        //            return true;
        class_265 shape = blockState.method_26218(world, relative);
        if (shape.method_1110())
            return false;
        if (class_2248.method_9501(shape, side.method_10153()) && blockState.method_51367())
            return true;
        return AbstractChuteBlock.getChuteFacing(blockState) == class_2350.field_11033;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        state = state.method_11657(AXIS, rot.method_10503(class_2350.method_10169(state.method_11654(AXIS), class_2352.field_11056)).method_10166());
        if (rot.method_10503(class_2350.field_11034).method_10166() == class_2351.field_11048)
            return state;
        return state.method_11657(X, state.method_11654(Z)).method_11657(Z, state.method_11654(Z));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state;
    }

}
