package com.zurrtum.create.content.equipment.blueprint;

import com.google.common.cache.Cache;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.api.schematic.requirement.SpecialEntityItemRequirement;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.utility.IInteractionChecker;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.BlueprintPreviewPacket;
import com.zurrtum.create.infrastructure.packet.s2c.NbtSpawnPacket;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5455;
import net.minecraft.class_8786;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9694;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.concurrent.ExecutionException;

public class BlueprintEntity extends class_1530 implements SpecialEntityItemRequirement, IInteractionChecker {
    private static final Cache<String, BlueprintPreviewPacket> PREVIEW_CACHE = new TickBasedCache<>(20, true);
    private static final class_2940<class_2487> RECIPES = class_2945.method_12791(BlueprintEntity.class, class_2943.field_13318);

    public int size;
    protected class_2350 verticalOrientation;

    public BlueprintEntity(class_1299<? extends BlueprintEntity> p_i50221_1_, class_1937 p_i50221_2_) {
        super(p_i50221_1_, p_i50221_2_);
        size = 1;
    }

    public BlueprintEntity(class_1937 world, class_2338 pos, class_2350 facing, class_2350 verticalOrientation) {
        super(AllEntityTypes.CRAFTING_BLUEPRINT, world, pos);

        for (int size = 3; size > 0; size--) {
            this.size = size;
            updateFacingWithBoundingBox(facing, verticalOrientation);
            if (method_6888())
                break;
        }
    }

    @Override
    public void method_5674(class_2940<?> data) {
        if (field_18064.equals(data)) {
            method_18382();
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RECIPES, new class_2487());
    }

    @Override
    public void method_5652(class_11372 view) {
        view.method_71468("Orientation", class_2350.field_29502, verticalOrientation);
        view.method_71468("Facing", class_2350.field_29502, method_5735());
        view.method_71465("Size", size);
        view.method_71468("Recipes", class_2487.field_25128, field_6011.method_12789(RECIPES));
        super.method_5652(view);
    }

    @Override
    public void method_5749(class_11368 view) {
        verticalOrientation = view.method_71426("Orientation", class_2350.field_29502).orElse(class_2350.field_11033);
        size = view.method_71424("Size", 1);
        view.method_71426("Recipes", class_2487.field_25128).ifPresent(nbt -> field_6011.method_12778(RECIPES, nbt));
        super.method_5749(view);
        class_2350 direction = view.method_71426("Facing", class_2350.field_29502).orElse(class_2350.field_11033);
        updateFacingWithBoundingBox(direction, verticalOrientation);
    }

    protected void updateFacingWithBoundingBox(class_2350 facing, class_2350 verticalOrientation) {
        Objects.requireNonNull(facing);
        method_71770(facing);
        this.verticalOrientation = verticalOrientation;
        if (facing.method_10166().method_10179()) {
            method_36457(0.0F);
            method_36456(facing.method_10161() * 90);
        } else {
            method_36457(-90 * facing.method_10171().method_10181());
            method_36456(verticalOrientation.method_10166().method_10179() ? 180 + verticalOrientation.method_10144() : 0);
        }

        field_6004 = method_36455();
        field_5982 = method_36454();
        method_6895();
    }

    @Override
    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_55685(0);
    }

    @Override
    protected class_238 method_59943(class_2338 blockPos, class_2350 direction) {
        class_243 pos = class_243.method_24954(method_59940()).method_1031(.5, .5, .5).method_1020(class_243.method_24954(direction.method_62675()).method_1021(0.46875));
        double d1 = pos.field_1352;
        double d2 = pos.field_1351;
        double d3 = pos.field_1350;
        method_23327(d1, d2, d3);

        class_2351 axis = direction.method_10166();
        if (size == 2)
            pos = pos.method_1019(class_243.method_24954(axis.method_10179() ? direction.method_10160().method_62675() : verticalOrientation.method_10170()
                    .method_62675()).method_1021(0.5))
                .method_1019(class_243.method_24954(axis.method_10179() ? class_2350.field_11036.method_62675() : direction == class_2350.field_11036 ? verticalOrientation.method_62675() : verticalOrientation.method_10153()
                    .method_62675()).method_1021(0.5));

        d1 = pos.field_1352;
        d2 = pos.field_1351;
        d3 = pos.field_1350;

        double d4 = getEntityWidth();
        double d5 = getEntityHeight();
        double d6 = d4;
        class_2351 direction$axis = method_5735().method_10166();
        switch (direction$axis) {
            case field_11048:
                d4 = 1.0D;
                break;
            case field_11052:
                d5 = 1.0D;
                break;
            case field_11051:
                d6 = 1.0D;
        }

        d4 = d4 / 32.0D;
        d5 = d5 / 32.0D;
        d6 = d6 / 32.0D;

        return new class_238(d1 - d4, d2 - d5, d3 - d6, d1 + d4, d2 + d5, d3 + d6);
    }

    @Override
    protected void method_6895() {
        class_2350 direction = method_5735();
        if (direction != null && verticalOrientation != null) {
            method_5857(method_59943(field_51589, direction));
        }
    }

    @Override
    public void method_5814(double pX, double pY, double pZ) {
        method_23327(pX, pY, pZ);
        super.method_5814(pX, pY, pZ);
    }

    @Override
    public boolean method_6888() {
        class_1937 world = method_37908();
        if (!world.method_17892(this))
            return false;

        int i = Math.max(1, getEntityWidth() / 16);
        int j = Math.max(1, getEntityHeight() / 16);
        class_2350 direction = method_5735();
        class_2338 blockpos = field_51589.method_10093(direction.method_10153());
        class_2350 upDirection = direction.method_10166()
            .method_10179() ? class_2350.field_11036 : direction == class_2350.field_11036 ? verticalOrientation : verticalOrientation.method_10153();
        class_2350 newDirection = direction.method_10166().method_10178() ? verticalOrientation.method_10170() : direction.method_10160();
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();

        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutable.method_10101(blockpos).method_10104(newDirection, k + i1).method_10104(upDirection, l + j1);
                class_2680 blockstate = world.method_8320(blockpos$mutable);
                if (class_2248.method_20044(world, blockpos$mutable, direction))
                    continue;
                if (!blockstate.method_51367() && !class_2312.method_9999(blockstate)) {
                    return false;
                }
            }
        }

        return world.method_8333(this, method_5829(), field_7098).isEmpty();
    }

    public int getEntityWidth() {
        return 16 * size;
    }

    public int getEntityHeight() {
        return 16 * size;
    }

    @Override
    public boolean method_5698(class_1297 source) {
        if (!(source instanceof class_1657 player) || method_37908().field_9236)
            return super.method_5698(source);

        double attrib = player.method_45325(class_5134.field_47758) + (player.method_68878() ? 0 : -0.5F);

        class_243 eyePos = source.method_5836(1);
        class_243 look = source.method_5828(1);
        class_243 target = eyePos.method_1019(look.method_1021(attrib));

        Optional<class_243> rayTrace = method_5829().method_992(eyePos, target);
        if (!rayTrace.isPresent())
            return super.method_5698(source);

        class_243 hitVec = rayTrace.get();
        BlueprintSection sectionAt = getSectionAt(hitVec.method_1020(method_19538()));
        ItemStackHandler items = sectionAt.getItems();

        if (items.method_5438(9).method_7960())
            return super.method_5698(source);
        for (int i = 0, size = items.method_5439(); i < size; i++)
            items.method_5447(i, class_1799.field_8037);
        sectionAt.save(items);
        return true;
    }

    @Override
    public void method_6889(class_3218 world, @Nullable class_1297 p_110128_1_) {
        if (!world.method_64395().method_8355(class_1928.field_19393))
            return;

        method_5783(class_3417.field_14809, 1.0F, 1.0F);
        if (p_110128_1_ instanceof class_1657 playerentity) {
            if (playerentity.method_31549().field_7477)
                return;
        }

        method_5775(world, AllItems.CRAFTING_BLUEPRINT.method_7854());
    }

    @Override
    public @Nullable class_1799 method_31480() {
        return AllItems.CRAFTING_BLUEPRINT.method_7854();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemUseType.CONSUME, AllItems.CRAFTING_BLUEPRINT);
    }

    @Override
    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0F, 1.0F);
    }

    @Override
    public void method_5808(double p_70012_1_, double p_70012_3_, double p_70012_5_, float p_70012_7_, float p_70012_8_) {
        this.method_5814(p_70012_1_, p_70012_3_, p_70012_5_);
    }

    @Override
    public void method_66246(class_243 pos, float yaw, float pitch) {
        class_2338 blockpos = field_51589.method_10081(class_2338.method_49637(pos.method_10216() - method_23317(), pos.method_10214() - method_23318(), pos.method_10215() - method_23321()));
        this.method_5814(blockpos.method_10263(), blockpos.method_10264(), blockpos.method_10260());
    }

    @Override
    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, method_56673());
            method_5652(view);
            return new NbtSpawnPacket(this, entityTrackerEntry, view.method_71475());
        }
    }

    @Override
    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_2487 nbt = ((NbtSpawnPacket) packet).getNbt();
        if (nbt == null) {
            return;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
            method_5749(class_11352.method_71417(logging, method_56673(), nbt));
        }
    }

    @Override
    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        if (FakePlayerHandler.has(player))
            return class_1269.field_5811;

        boolean holdingWrench = player.method_5998(hand).method_31574(AllItems.WRENCH);
        BlueprintSection section = getSectionAt(vec);
        ItemStackHandler items = section.getItems();

        class_1937 world = method_37908();
        if (!holdingWrench && !world.field_9236 && !items.method_5438(9).method_7960()) {
            class_5455 registryManager = world.method_30349();
            class_1661 playerInv = player.method_31548();
            int size = playerInv.method_5439();
            boolean firstPass = true;
            int amountCrafted = 0;
            //TODO
            //            CommonHooks.setCraftingPlayer(player);
            class_8786<class_3955> recipe = null;
            List<class_1799> results = null;

            do {
                int[] stacksTaken = new int[size];
                int max = 0;
                List<class_1799> craftingStacks = new ArrayList<>(9);
                boolean success = true;

                Search:
                for (int i = 0; i < 9; i++) {
                    class_1799 filter = items.method_5438(i);
                    if (filter.method_7960()) {
                        craftingStacks.add(class_1799.field_8037);
                        continue;
                    }
                    FilterItemStack requestedItem = FilterItemStack.of(filter);

                    for (int slot = 0; slot < size; slot++) {
                        class_1799 stack = playerInv.method_5438(slot);
                        if (!requestedItem.test(world, stack))
                            continue;
                        int used = stacksTaken[slot];
                        if (stack.method_7947() == used) {
                            continue;
                        }
                        stacksTaken[slot] = used + 1;
                        craftingStacks.add(stack.method_46651(1));
                        if (slot > max) {
                            max = slot;
                        }
                        continue Search;
                    }

                    success = false;
                    break;
                }

                if (success) {
                    class_9694 input = class_9694.method_59986(3, 3, craftingStacks);
                    recipe = ((class_3218) world).method_64577().method_59993(class_3956.field_17545, input, world, recipe).orElse(null);
                    if (recipe == null) {
                        success = false;
                    } else {
                        class_3955 craftingRecipe = recipe.comp_1933();
                        class_1799 result = craftingRecipe.method_8116(input, registryManager);
                        if (result.method_7960() || result.method_7947() + amountCrafted > 64) {
                            success = false;
                        } else {
                            amountCrafted += result.method_7947();
                            result.method_7982(player, 1);
                            //TODO
                            //                        EventHooks.firePlayerCraftingEvent(player, result, craftingInventory);

                            results = new ArrayList<>();
                            results.add(result);
                            for (class_1799 stack : craftingRecipe.method_17704(input)) {
                                if (stack.method_7960()) {
                                    continue;
                                }
                                results.add(stack);
                            }

                            if (firstPass) {
                                world.method_8396(
                                    null,
                                    player.method_24515(),
                                    class_3417.field_15197,
                                    class_3419.field_15248,
                                    .2f,
                                    1f + world.method_8409().method_43057()
                                );
                                firstPass = false;
                            }
                        }
                    }
                }

                if (success) {
                    for (int slot = 0; slot <= max; slot++) {
                        int used = stacksTaken[slot];
                        if (used == 0) {
                            continue;
                        }
                        class_1799 stack = playerInv.method_5438(slot);
                        int count = stack.method_7947();
                        if (count == used) {
                            stack = class_1799.field_8037;
                        } else {
                            stack.method_7939(count - used);
                        }
                        playerInv.method_5447(slot, stack);
                    }
                    playerInv.method_5431();
                    for (class_1799 stack : results) {
                        player.method_31548().method_7398(stack);
                    }
                } else {
                    break;
                }

            } while (player.method_5715());
            //TODO
            //            CommonHooks.setCraftingPlayer(null);
            PREVIEW_CACHE.invalidate(method_5628() + "_" + section.index + "_" + player.method_5628() + (player.method_5715() ? "_sneaking" : ""));
            return class_1269.field_5812;
        }

        if (!world.field_9236 && player instanceof class_3222 serverPlayer) {
            MenuProvider.openHandledScreen(serverPlayer, section);
        }

        return class_1269.field_5812;
    }

    public static BlueprintPreviewPacket getPreview(BlueprintEntity be, int index, class_3222 player, boolean sneaking) {
        try {
            return PREVIEW_CACHE.get(
                be.method_5628() + "_" + index + "_" + player.method_5628() + (sneaking ? "_sneaking" : ""),
                () -> createPreview(be, index, player, sneaking)
            );
        } catch (ExecutionException e) {
            e.printStackTrace();
            return BlueprintPreviewPacket.EMPTY;
        }
    }

    private static BlueprintPreviewPacket createPreview(BlueprintEntity be, int index, class_3222 player, boolean sneaking) {
        BlueprintSection section = be.getSection(index);
        ItemStackHandler items = section.getItems();
        if (items.method_5442()) {
            return BlueprintPreviewPacket.EMPTY;
        }
        class_3218 world = player.method_51469();
        class_1661 playerInv = player.method_31548();
        int size = playerInv.method_5439();
        int[] stacksTaken = new int[size];
        List<FilterItemStack> requestedItems = new ArrayList<>(9);
        List<class_1799> craftingStacks = new ArrayList<>(9);
        Object2IntLinkedOpenCustomHashMap<class_1799> missingStacks = BlueprintPreviewPacket.createMap();
        Object2IntLinkedOpenCustomHashMap<class_1799> availableStacks = BlueprintPreviewPacket.createMap();
        Search:
        for (int i = 0; i < 9; i++) {
            FilterItemStack requestedItem = FilterItemStack.of(items.method_5438(i));
            if (requestedItem.isEmpty()) {
                requestedItems.add(null);
                craftingStacks.add(class_1799.field_8037);
                continue;
            }
            requestedItems.add(requestedItem);
            for (int slot = 0; slot < size; slot++) {
                class_1799 stack = playerInv.method_5438(slot);
                if (!requestedItem.test(world, stack))
                    continue;
                int used = stacksTaken[slot];
                if (stack.method_7947() == used) {
                    continue;
                }
                stacksTaken[slot] = used + 1;
                craftingStacks.add(stack.method_46651(1));
                availableStacks.merge(stack, 1, Integer::sum);
                continue Search;
            }
            missingStacks.merge(requestedItem.item(), 1, Integer::sum);
        }
        if (!missingStacks.isEmpty()) {
            return new BlueprintPreviewPacket(availableStacks, missingStacks, items.method_5438(9));
        }
        class_9694 input = class_9694.method_59986(3, 3, craftingStacks);
        Optional<class_1799> result = world.method_64577().method_8132(class_3956.field_17545, input, world)
            .map(entry -> entry.comp_1933().method_8116(input, world.method_30349())).filter(stack -> !stack.method_7960());
        if (result.isEmpty()) {
            return new BlueprintPreviewPacket(availableStacks, List.of(), class_1799.field_8037);
        }
        class_1799 resultStack = result.get();
        if (sneaking) {
            int max = resultStack.method_7914();
            int craftingCount = resultStack.method_7947();
            if (craftingCount < max) {
                int count = craftingCount;
                Object2IntLinkedOpenCustomHashMap<class_1799> ingredients = BlueprintPreviewPacket.createMap(availableStacks);
                Outer:
                while (count + craftingCount <= max) {
                    Search:
                    for (int i = 0; i < 9; i++) {
                        FilterItemStack requestedItem = requestedItems.get(i);
                        if (requestedItem == null) {
                            continue;
                        }
                        for (int slot = 0; slot < size; slot++) {
                            class_1799 stack = playerInv.method_5438(slot);
                            if (!requestedItem.test(world, stack))
                                continue;
                            int used = stacksTaken[slot];
                            if (stack.method_7947() == used) {
                                continue;
                            }
                            stacksTaken[slot] = used + 1;
                            continue Search;
                        }
                        break Outer;
                    }
                    ObjectBidirectionalIterator<Object2IntMap.Entry<class_1799>> iterator = availableStacks.object2IntEntrySet().fastIterator();
                    do {
                        Object2IntMap.Entry<class_1799> entry = iterator.next();
                        entry.setValue(entry.getIntValue() + ingredients.getInt(entry.getKey()));
                    } while (iterator.hasNext());
                    count += craftingCount;
                }
                resultStack.method_7939(count);
            }
        }
        return new BlueprintPreviewPacket(availableStacks, List.of(), resultStack);
    }

    public BlueprintSection getSectionAt(class_243 vec) {
        int index = 0;
        if (size > 1) {
            vec = VecHelper.rotate(vec, method_36454(), class_2351.field_11052);
            vec = VecHelper.rotate(vec, -method_36455(), class_2351.field_11048);
            vec = vec.method_1031(0.5, 0.5, 0);
            if (size == 3)
                vec = vec.method_1031(1, 1, 0);
            int x = class_3532.method_15340(class_3532.method_15357(vec.field_1352), 0, size - 1);
            int y = class_3532.method_15340(class_3532.method_15357(vec.field_1351), 0, size - 1);
            index = x + y * size;
        }

        return getSection(index);
    }

    public Optional<class_2487> getRecipeCompound(int index) {
        return field_6011.method_12789(RECIPES).method_10562(Integer.toString(index));
    }

    public void putRecipeCompound(int index, class_2487 compound) {
        class_2487 recipes = field_6011.method_12789(RECIPES);
        recipes.method_10566(Integer.toString(index), compound);
        field_6011.method_49743(RECIPES, recipes, true);
    }

    private final Map<Integer, BlueprintSection> sectionCache = new HashMap<>();

    public BlueprintSection getSection(int index) {
        return sectionCache.computeIfAbsent(index, BlueprintSection::new);
    }

    public class BlueprintSection implements MenuProvider, IInteractionChecker {
        private static final Couple<class_1799> EMPTY_DISPLAY = Couple.create(class_1799.field_8037, class_1799.field_8037);
        public int index;
        Couple<class_1799> cachedDisplayItems;
        public boolean inferredIcon = false;

        public BlueprintSection(int index) {
            this.index = index;
        }

        public Couple<class_1799> getDisplayItems() {
            if (cachedDisplayItems != null)
                return cachedDisplayItems;
            return getRecipeCompound(index).flatMap(nbt -> nbt.method_67491("Inventory", CreateCodecs.ITEM_LIST_CODEC)
                .map(items -> Couple.create(items.get(9), items.get(10)))).orElse(EMPTY_DISPLAY);
        }

        public ItemStackHandler getItems() {
            ItemStackHandler newInv = new ItemStackHandler(11);
            getRecipeCompound(index).ifPresentOrElse(
                nbt -> {
                    try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
                        class_11368 view = class_11352.method_71417(logging, method_56673(), nbt);
                        newInv.readSlots(view);
                        inferredIcon = view.method_71433("InferredIcon", false);
                    }
                }, () -> inferredIcon = false
            );
            return newInv;
        }

        public void save(ItemStackHandler inventory) {
            cachedDisplayItems = null;
            if (!method_37908().field_9236) {
                try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
                    class_11362 view = class_11362.method_71459(logging, method_56673());
                    inventory.writeSlots(view);
                    view.method_71472("InferredIcon", inferredIcon);
                    putRecipeCompound(index, view.method_71475());
                }
            }
        }

        public boolean isEntityAlive() {
            return method_5805();
        }

        public class_1937 getBlueprintWorld() {
            return method_37908();
        }

        @Override
        public BlueprintMenu createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
            extraData.method_10804(method_5628());
            extraData.method_10804(index);
            return new BlueprintMenu(id, inv, this);
        }

        @Override
        public class_2561 getDisplayName() {
            return AllItems.CRAFTING_BLUEPRINT.method_63680();
        }

        @Override
        public boolean canPlayerUse(class_1657 player) {
            return BlueprintEntity.this.canPlayerUse(player);
        }

    }

    @Override
    public boolean canPlayerUse(class_1657 player) {
        class_238 box = method_5829();

        double dx = 0;
        if (box.field_1323 > player.method_23317()) {
            dx = box.field_1323 - player.method_23317();
        } else if (player.method_23317() > box.field_1320) {
            dx = player.method_23317() - box.field_1320;
        }

        double dy = 0;
        if (box.field_1322 > player.method_23318()) {
            dy = box.field_1322 - player.method_23318();
        } else if (player.method_23318() > box.field_1325) {
            dy = player.method_23318() - box.field_1325;
        }

        double dz = 0;
        if (box.field_1321 > player.method_23321()) {
            dz = box.field_1321 - player.method_23321();
        } else if (player.method_23321() > box.field_1324) {
            dz = player.method_23321() - box.field_1324;
        }

        return (dx * dx + dy * dy + dz * dz) <= 64.0D;
    }

}
