package com.zurrtum.create.content.equipment.clipboard;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

import static com.zurrtum.create.Create.LOGGER;

public class ClipboardValueSettingsHandler {

    public static class_1269 rightClickToCopy(class_1937 world, class_1657 player, class_1799 itemStack, class_1268 hand, class_3965 hit, class_2338 pos) {
        return interact(world, player, itemStack, hit.method_17780(), pos, false);
    }

    public static boolean leftClickToPaste(class_1937 world, class_1657 player, class_1799 itemStack, class_2350 side, class_2338 pos) {
        return interact(world, player, itemStack, side, pos, true) == class_1269.field_5812;
    }

    private static class_1269 interact(class_1937 world, class_1657 player, class_1799 itemStack, class_2350 side, class_2338 pos, boolean paste) {
        if (!itemStack.method_31574(AllItems.CLIPBOARD) || player.method_7325() || player.method_5715())
            return null;
        if (!(world.method_8321(pos) instanceof SmartBlockEntity smartBE))
            return null;

        ClipboardContent clipboardContent = itemStack.method_58695(AllDataComponents.CLIPBOARD_CONTENT, ClipboardContent.EMPTY);

        if (smartBE instanceof ClipboardBlockEntity cbe) {
            if (!world.field_9236) {
                List<List<ClipboardEntry>> listTo = ClipboardEntry.readAll(clipboardContent);
                List<List<ClipboardEntry>> listFrom = ClipboardEntry.readAll(cbe.method_58693());
                List<ClipboardEntry> toAdd = new ArrayList<>();

                for (List<ClipboardEntry> page : listFrom) {
                    Copy:
                    for (ClipboardEntry entry : page) {
                        String entryToAdd = entry.text.getString();
                        for (List<ClipboardEntry> pageTo : listTo)
                            for (ClipboardEntry existing : pageTo)
                                if (entryToAdd.equals(existing.text.getString()))
                                    continue Copy;
                        toAdd.add(new ClipboardEntry(entry.checked, entry.text));
                    }
                }

                for (ClipboardEntry entry : toAdd) {
                    List<ClipboardEntry> page = null;
                    for (List<ClipboardEntry> freePage : listTo) {
                        if (freePage.size() > 11)
                            continue;
                        page = freePage;
                        break;
                    }
                    if (page == null) {
                        page = new ArrayList<>();
                        listTo.add(page);
                    }
                    page.add(entry);

                    clipboardContent = clipboardContent.setType(ClipboardType.WRITTEN);
                    itemStack.method_57379(AllDataComponents.CLIPBOARD_CONTENT, clipboardContent);
                }

                clipboardContent = clipboardContent.setPages(listTo);
                itemStack.method_57379(AllDataComponents.CLIPBOARD_CONTENT, clipboardContent);
            }

            player.method_7353(
                class_2561.method_43469("create.clipboard.copied_from_clipboard", world.method_8320(pos).method_26204().method_9518().method_27692(class_124.field_1068))
                    .method_27692(class_124.field_1060), true
            );
            return class_1269.field_5812;
        }

        class_2487 tag = null;
        if (paste) {
            tag = clipboardContent.copiedValues().orElse(null);
            if (tag == null) {
                return null;
            }
        }

        boolean anySuccess = false;
        boolean anyValid = false;
        try (class_8942.class_11340 logging = new class_8942.class_11340(smartBE.method_71402(), LOGGER)) {
            class_5455 registryManager = world.method_30349();
            class_11368 readView = paste ? class_11352.method_71417(logging, registryManager, tag) : null;
            class_11362 writeView = paste ? null : class_11362.method_71459(logging, registryManager);
            if (smartBE instanceof ClipboardCloneable cc) {
                anyValid = true;
                if (paste) {
                    anySuccess = paste(cc, player, readView, side, world.field_9236);
                } else {
                    anySuccess = write(cc, registryManager, writeView, side, world.field_9236);
                    if (anySuccess) {
                        tag = writeView.method_71475();
                    }
                }
            }

            if (!anySuccess) {
                for (BehaviourType<? extends BlockEntityBehaviour<SmartBlockEntity>> type : List.of(
                    ServerScrollValueBehaviour.TYPE,
                    ServerFilteringBehaviour.TYPE,
                    ServerLinkBehaviour.TYPE
                )) {
                    if (!(smartBE.getBehaviour(type) instanceof ClipboardCloneable cc))
                        continue;
                    anyValid = true;
                    if (paste) {
                        anySuccess = paste(cc, player, readView, side, world.field_9236);
                    } else {
                        anySuccess = write(cc, registryManager, writeView, side, world.field_9236);
                        if (anySuccess) {
                            tag = writeView.method_71475();
                            break;
                        }
                    }
                }
            }
        }

        if (!anyValid)
            return null;

        if (world.method_8608() || !anySuccess)
            return class_1269.field_5812;

        player.method_7353(
            class_2561.method_43469(
                paste ? "create.clipboard.pasted_to" : "create.clipboard.copied_from",
                world.method_8320(pos).method_26204().method_9518().method_27692(class_124.field_1068)
            ).method_27692(class_124.field_1060), true
        );

        if (!paste) {
            clipboardContent = clipboardContent.setType(ClipboardType.WRITTEN);
            clipboardContent = clipboardContent.setCopiedValues(tag);
            itemStack.method_57379(AllDataComponents.CLIPBOARD_CONTENT, clipboardContent);
        }
        return class_1269.field_5812;
    }

    private static boolean paste(ClipboardCloneable cc, class_1657 player, class_11368 readView, class_2350 side, boolean simulate) {
        return readView.method_71420(cc.getClipboardKey()).map(v -> cc.readFromClipboard(v, player, side, simulate)).orElse(false);
    }

    private static boolean write(
        ClipboardCloneable cc,
        class_7225.class_7874 registryManager,
        class_11372 writeView,
        class_2350 side,
        boolean simulate
    ) {
        String clipboardKey = cc.getClipboardKey();
        if (simulate) {
            return cc.canWrite(registryManager, side);
        } else {
            return cc.writeToClipboard(writeView.method_71461(clipboardKey), side);
        }
    }
}
