package com.zurrtum.create.content.equipment.potatoCannon;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileEntityHitAction;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.player.FakePlayerEntity;
import java.util.UUID;
import net.minecraft.class_10124;
import net.minecraft.class_10128;
import net.minecraft.class_10134;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1641;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4019;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9298;
import net.minecraft.class_9298.class_8751;
import net.minecraft.class_9334;

import static com.zurrtum.create.Create.MOD_ID;

public class AllPotatoProjectileEntityHitActions {
    public static void register() {
        register("set_on_fire", SetOnFire.CODEC);
        register("potion_effect", PotionEffect.CODEC);
        register("food_effects", FoodEffects.CODEC);
        register("chorus_teleport", ChorusTeleport.CODEC);
        register("cure_zombie_villager", CureZombieVillager.CODEC);
        register("suspicious_stew", SuspiciousStew.CODEC);
    }

    private static void register(String name, MapCodec<? extends PotatoProjectileEntityHitAction> codec) {
        class_2378.method_10230(CreateRegistries.POTATO_PROJECTILE_ENTITY_HIT_ACTION, class_2960.method_60655(MOD_ID, name), codec);
    }

    public record SetOnFire(int ticks) implements PotatoProjectileEntityHitAction {
        public static final MapCodec<SetOnFire> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_5699.field_33442.fieldOf("ticks")
            .forGetter(SetOnFire::ticks)).apply(instance, SetOnFire::new));

        public static SetOnFire seconds(int seconds) {
            return new SetOnFire(seconds * 20);
        }

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, Type type) {
            ray.method_17782().method_20803(ticks);
            return false;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record PotionEffect(
        class_6880<class_1291> effect, int level, int ticks, boolean recoverable
    ) implements PotatoProjectileEntityHitAction {
        public static final MapCodec<PotionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_7923.field_41174.method_40294().fieldOf("effect").forGetter(PotionEffect::effect),
            class_5699.field_33442.fieldOf("level").forGetter(PotionEffect::level),
            class_5699.field_33442.fieldOf("ticks").forGetter(PotionEffect::ticks),
            Codec.BOOL.fieldOf("recoverable").forGetter(PotionEffect::recoverable)
        ).apply(instance, PotionEffect::new));

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, Type type) {
            class_1297 entity = ray.method_17782();
            if (entity.method_37908().field_9236)
                return true;
            if (entity instanceof class_1309 livingEntity)
                applyEffect(livingEntity, new class_1293(effect, ticks, level - 1));
            return !recoverable;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record FoodEffects(
        class_10124 foodProperty, boolean recoverable
    ) implements PotatoProjectileEntityHitAction {
        public static final MapCodec<FoodEffects> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_10124.field_53770.fieldOf(
                "food_property").forGetter(FoodEffects::foodProperty),
            Codec.BOOL.fieldOf("recoverable").forGetter(FoodEffects::recoverable)
        ).apply(instance, FoodEffects::new));

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, Type type) {
            class_1297 entity = ray.method_17782();
            class_1937 world = entity.method_37908();
            if (world.field_9236)
                return true;

            if (entity instanceof class_1309 livingEntity) {
                for (class_10134 effect : foodProperty.comp_3089()) {
                    effect.method_62866(world, projectile, livingEntity);
                }
            }
            return !recoverable;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record ChorusTeleport(double teleportDiameter) implements PotatoProjectileEntityHitAction {
        public static final MapCodec<ChorusTeleport> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(CreateCodecs.POSITIVE_DOUBLE.fieldOf(
            "teleport_diameter").forGetter(ChorusTeleport::teleportDiameter)).apply(instance, ChorusTeleport::new));

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, Type type) {
            class_1297 entity = ray.method_17782();
            class_1937 level = entity.method_37908();
            if (level.field_9236)
                return true;
            if (!(entity instanceof class_1309 livingEntity))
                return false;

            double entityX = livingEntity.method_23317();
            double entityY = livingEntity.method_23318();
            double entityZ = livingEntity.method_23321();

            for (int teleportTry = 0; teleportTry < 16; ++teleportTry) {
                double teleportX = entityX + (livingEntity.method_59922().method_43058() - 0.5D) * teleportDiameter;
                double teleportY = class_3532.method_15350(
                    entityY + (livingEntity.method_59922()
                        .method_43048((int) teleportDiameter) - (int) (teleportDiameter / 2)), 0.0D, level.method_31605() - 1
                );
                double teleportZ = entityZ + (livingEntity.method_59922().method_43058() - 0.5D) * teleportDiameter;

                //TODO
                //                EntityTeleportEvent.ChorusFruit event = EventHooks.onChorusFruitTeleport(livingEntity, teleportX, teleportY, teleportZ);
                //                if (event.isCanceled())
                //                    return false;
                if (livingEntity.method_6082(teleportX, teleportY, teleportZ, true)) {
                    if (livingEntity.method_5765())
                        livingEntity.method_5848();

                    class_3414 soundevent = livingEntity instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
                    level.method_43128(null, entityX, entityY, entityZ, soundevent, class_3419.field_15248, 1.0F, 1.0F);
                    livingEntity.method_5783(soundevent, 1.0F, 1.0F);
                    livingEntity.method_18799(class_243.field_1353);
                    return true;
                }
            }

            return false;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public enum CureZombieVillager implements PotatoProjectileEntityHitAction {
        INSTANCE;

        private static final FoodEffects EFFECT = new FoodEffects(class_10128.field_53786, false);
        private static final GameProfile ZOMBIE_CONVERTER_NAME = new GameProfile(
            UUID.fromString("be12d3dc-27d3-4992-8c97-66be53fd49c5"),
            "Converter"
        );
        private static final WorldAttached<FakePlayerEntity> ZOMBIE_CONVERTERS = new WorldAttached<>(w -> new FakePlayerEntity(
            (class_3218) w,
            ZOMBIE_CONVERTER_NAME
        ));

        public static final MapCodec<CureZombieVillager> CODEC = MapCodec.unit(INSTANCE);

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, Type type) {
            class_1297 entity = ray.method_17782();
            class_1937 world = entity.method_37908();

            if (!(entity instanceof class_1641 zombieVillager) || !zombieVillager.method_6059(class_1294.field_5911))
                return EFFECT.execute(projectile, ray, type);
            if (world.field_9236)
                return false;

            FakePlayerEntity dummy = ZOMBIE_CONVERTERS.get(world);
            dummy.method_6122(class_1268.field_5808, new class_1799(class_1802.field_8463, 1));
            zombieVillager.method_5992(dummy, class_1268.field_5808);
            return true;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public enum SuspiciousStew implements PotatoProjectileEntityHitAction {
        INSTANCE;

        public static final MapCodec<SuspiciousStew> CODEC = MapCodec.unit(INSTANCE);

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, Type type) {
            if (ray.method_17782() instanceof class_1309 livingEntity) {
                class_9298 stew = projectile.method_58695(
                    class_9334.field_49652,
                    class_9298.field_49362
                );
                for (class_8751 effect : stew.comp_2416())
                    livingEntity.method_6092(effect.method_53247());
            }

            return false;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    private static void applyEffect(class_1309 entity, class_1293 effect) {
        if (effect.method_5579().comp_349().method_5561()) {
            if (entity.method_37908() instanceof class_3218 serverWorld) {
                effect.method_5579().comp_349().method_5564(serverWorld, null, null, entity, effect.method_5584(), 1.0);
            }
        } else {
            entity.method_6092(effect);
        }
    }
}
