package com.zurrtum.create.content.equipment.potatoCannon;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoCannonProjectileType;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import com.zurrtum.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.zurrtum.create.foundation.item.SwingControlItem;
import com.zurrtum.create.foundation.utility.GlobalRegistryAccess;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.PotatoCannonPacket;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9304;

public class PotatoCannonItem extends class_1811 implements SwingControlItem {
    private static final Predicate<class_1799> AMMO_PREDICATE = s -> PotatoCannonProjectileType.getTypeForItem(
        GlobalRegistryAccess.getOrThrow(),
        s.method_7909()
    ).isPresent();

    public PotatoCannonItem(class_1793 properties) {
        super(properties);
    }

    @Nullable
    public static Ammo getAmmo(class_1657 player, class_1799 heldStack) {
        class_1799 ammoStack = player.method_18808(heldStack);
        if (ammoStack.method_7960()) {
            return null;
        }

        return PotatoCannonProjectileType.getTypeForItem(player.method_37908().method_30349(), ammoStack.method_7909())
            .map(r -> new Ammo(ammoStack, r.comp_349())).orElse(null);
    }

    @Override
    protected void method_7763(
        class_1309 shooter,
        class_1676 projectile,
        int index,
        float velocity,
        float inaccuracy,
        float angle,
        @Nullable class_1309 target
    ) {
    }

    @Override
    protected void method_57393(
        class_3218 level,
        class_1309 shooter,
        class_1268 hand,
        class_1799 weapon,
        List<class_1799> projectileItems,
        float velocity,
        float inaccuracy,
        boolean isCrit,
        @Nullable class_1309 target
    ) {
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        return method_7836(context.method_8045(), context.method_8036(), context.method_20287());
    }

    @Override
    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 heldStack = player.method_5998(hand);
        if (ShootableGadgetItemMethods.shouldSwap(player, heldStack, hand, s -> s.method_7909() instanceof PotatoCannonItem)) {
            return class_1269.field_5814;
        }

        Ammo ammo = getAmmo(player, heldStack);
        if (ammo == null) {
            return class_1269.field_5811;
        }
        class_1799 ammoStack = ammo.stack();
        PotatoCannonProjectileType projectileType = ammo.type();

        if (level.field_9236) {
            player.method_6021();
            AllClientHandle.INSTANCE.cannonDontAnimateItem(hand);
            return class_1269.field_21466.method_61393(heldStack);
        }

        class_243 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == class_1268.field_5808, new class_243(.75f, -0.15f, 1.5f));
        class_243 correction = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == class_1268.field_5808, new class_243(-.05f, 0, 0))
            .method_1020(player.method_19538().method_1031(0, player.method_5751(), 0));

        class_243 lookVec = player.method_5720();
        class_243 motion = lookVec.method_1019(correction).method_1029().method_1021(2).method_1021(projectileType.velocityMultiplier());

        float soundPitch = projectileType.soundPitch() + (level.method_8409().method_43057() - .5f) / 4f;

        boolean spray = projectileType.split() > 1;
        class_243 sprayBase = VecHelper.rotate(new class_243(0, 0.1, 0), 360 * level.method_8409().method_43057(), class_2351.field_11051);
        float sprayChange = 360f / projectileType.split();

        class_1799 ammoStackCopy = ammoStack.method_7972();

        for (int i = 0; i < projectileType.split(); i++) {
            PotatoProjectileEntity projectile = AllEntityTypes.POTATO_PROJECTILE.method_5883(level, class_3730.field_16465);
            projectile.setItem(ammoStackCopy);
            projectile.setEnchantmentEffectsFromCannon(heldStack);

            class_243 splitMotion = motion;
            if (spray) {
                float imperfection = 40 * (level.method_8409().method_43057() - 0.5f);
                class_243 sprayOffset = VecHelper.rotate(sprayBase, i * sprayChange + imperfection, class_2351.field_11051);
                splitMotion = splitMotion.method_1019(VecHelper.lookAt(sprayOffset, motion));
            }

            if (i != 0)
                projectile.recoveryChance = 0;

            projectile.method_5814(barrelPos.field_1352, barrelPos.field_1351, barrelPos.field_1350);
            projectile.method_18799(splitMotion);
            projectile.method_7432(player);
            level.method_8649(projectile);
        }

        if (!player.method_68878()) {
            ammoStack.method_7934(1);
            if (ammoStack.method_7960())
                player.method_31548().method_7378(ammoStack);
        }

        if (!BacktankUtil.canAbsorbDamage(player, maxUses()))
            heldStack.method_7970(1, player, class_1309.method_56079(hand));

        ShootableGadgetItemMethods.applyCooldown(player, heldStack, hand, s -> s.method_7909() instanceof PotatoCannonItem, projectileType.reloadTicks());
        ShootableGadgetItemMethods.sendPackets(player, b -> new PotatoCannonPacket(barrelPos, lookVec.method_1029(), ammoStack, hand, soundPitch, b));
        player.method_6021();
        return class_1269.field_21466.method_61393(heldStack);
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_67187(
        class_1799 stack,
        class_9635 context,
        class_10712 displayComponent,
        Consumer<class_2561> tooltip,
        class_1836 tooltipType
    ) {
        if (!AllClientHandle.INSTANCE.isClient()) {
            return;
        }
        class_1657 player = AllClientHandle.INSTANCE.getPlayer();
        if (player == null) {
            return;
        }
        Ammo ammo = getAmmo(player, stack);
        if (ammo == null) {
            return;
        }
        class_1799 ammoStack = ammo.stack();
        PotatoCannonProjectileType type = ammo.type();

        class_7225.class_7874 registries = context.method_59527();
        if (registries == null)
            return;

        class_7871<class_1887> lookup = registries.method_46762(class_7924.field_41265);
        class_9304 enchantments = stack.method_58657();
        int power = enchantments.method_57536(lookup.method_46747(class_1893.field_9103));
        int punch = enchantments.method_57536(lookup.method_46747(class_1893.field_9116));
        final float additionalDamageMult = 1 + power * .2f;
        final float additionalKnockback = punch * .5f;

        String _attack = "create.potato_cannon.ammo.attack_damage";
        String _reload = "create.potato_cannon.ammo.reload_ticks";
        String _knockback = "create.potato_cannon.ammo.knockback";

        tooltip.accept(class_5244.field_39003);
        tooltip.accept(ammoStack.method_7964().method_27661().method_10852(class_2561.method_43470(":")).method_27692(class_124.field_1080));
        class_5250 spacing = class_5244.method_48320();
        class_124 green = class_124.field_1060;
        class_124 darkGreen = class_124.field_1077;

        float damageF = type.damage() * additionalDamageMult;
        class_5250 damage = class_2561.method_43470(damageF == class_3532.method_15375(damageF) ? "" + class_3532.method_15375(damageF) : "" + damageF);
        class_5250 reloadTicks = class_2561.method_43470("" + type.reloadTicks());
        class_5250 knockback = class_2561.method_43470("" + (type.knockback() + additionalKnockback));

        damage = damage.method_27692(additionalDamageMult > 1 ? green : darkGreen);
        knockback = knockback.method_27692(additionalKnockback > 0 ? green : darkGreen);
        reloadTicks = reloadTicks.method_27692(darkGreen);

        tooltip.accept(spacing.method_27662().method_10852(class_2561.method_43469(_attack, damage).method_27692(darkGreen)));
        tooltip.accept(spacing.method_27662().method_10852(class_2561.method_43469(_reload, reloadTicks).method_27692(darkGreen)));
        tooltip.accept(spacing.method_27662().method_10852(class_2561.method_43469(_knockback, knockback).method_27692(darkGreen)));
    }

    @Override
    public boolean method_7885(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1309 player) {
        return false;
    }

    //TODO
    //    @Override
    //    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
    //        return slotChanged || newStack.getItem() != oldStack.getItem();
    //    }

    @Override
    public Predicate<class_1799> method_19268() {
        return AMMO_PREDICATE;
    }

    @Override
    public int method_24792() {
        return 15;
    }

    //TODO
    //    @Override
    //    public boolean supportsEnchantment(ItemStack stack, RegistryEntry<Enchantment> enchantment) {
    //        if (enchantment.is(Enchantments.INFINITY))
    //            return false;
    //        if (enchantment.is(Enchantments.LOOTING))
    //            return true;
    //        return super.supportsEnchantment(stack, enchantment);
    //    }

    @Override
    public boolean method_31567(class_1799 stack) {
        return false;
    }

    public boolean isModelBarVisible(class_1799 stack) {
        return BacktankUtil.isBarVisible(stack, maxUses());
    }

    @Override
    public int method_31569(class_1799 stack) {
        return BacktankUtil.getBarWidth(stack, maxUses());
    }

    @Override
    public int method_31571(class_1799 stack) {
        return BacktankUtil.getBarColor(stack, maxUses());
    }

    private static int maxUses() {
        return AllConfigs.server().equipment.maxPotatoCannonShots.get();
    }

    @Override
    public boolean onEntitySwing(class_1799 stack, class_1309 entity, class_1268 hand) {
        return true;
    }

    public record Ammo(class_1799 stack, PotatoCannonProjectileType type) {
    }
}
