package com.zurrtum.create.content.equipment.toolbox;

import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ToolboxHandler {

    public static final WorldAttached<WeakHashMap<class_2338, ToolboxBlockEntity>> toolboxes = new WorldAttached<>(w -> new WeakHashMap<>());

    public static void onLoad(ToolboxBlockEntity be) {
        toolboxes.get(be.method_10997()).put(be.method_11016(), be);
    }

    public static void onUnload(ToolboxBlockEntity be) {
        toolboxes.get(be.method_10997()).remove(be.method_11016());
    }

    static int validationTimer = 20;

    public static void entityTick(class_1297 entity, class_1937 world) {
        if (world.field_9236)
            return;
        if (!(world instanceof class_3218))
            return;
        if (!(entity instanceof class_3222 player))
            return;
        if (entity.field_6012 % validationTimer != 0)
            return;

        class_2487 compound = AllSynchedDatas.TOOLBOX.get(player);
        if (compound.method_33133())
            return;

        boolean sendData = false;
        for (int i = 0; i < 9; i++) {
            String key = String.valueOf(i);
            if (!compound.method_10545(key))
                continue;

            class_2487 data = compound.method_68568(key);
            class_2338 pos = data.method_67491("Pos", class_2338.field_25064).orElse(class_2338.field_10980);
            int slot = data.method_68083("Slot", 0);

            if (!world.method_8477(pos))
                continue;
            if (!(world.method_8320(pos).method_26204() instanceof ToolboxBlock)) {
                compound.method_10551(key);
                sendData = true;
                continue;
            }

            class_2586 prevBlockEntity = world.method_8321(pos);
            if (prevBlockEntity instanceof ToolboxBlockEntity toolbox)
                toolbox.connectPlayer(slot, player, i);
        }

        if (sendData)
            syncData(player, compound);
    }

    public static void syncData(class_1657 player, class_2487 data) {
        AllSynchedDatas.TOOLBOX.set(player, data, true);
    }

    public static List<ToolboxBlockEntity> getNearest(class_1936 world, class_1657 player, int maxAmount) {
        class_243 location = player.method_19538();
        double maxRange = getMaxRange(player);
        return toolboxes.get(world).keySet().stream().filter(p -> distance(location, p) < maxRange * maxRange)
            .sorted(Comparator.comparingDouble(p -> distance(location, p))).limit(maxAmount).map(toolboxes.get(world)::get)
            .filter(ToolboxBlockEntity::isFullyInitialized).collect(Collectors.toList());
    }

    public static void unequip(class_1657 player, int hotbarSlot, boolean keepItems) {
        class_2487 compound = AllSynchedDatas.TOOLBOX.get(player);
        class_1937 world = player.method_37908();
        String key = String.valueOf(hotbarSlot);
        if (!compound.method_10545(key))
            return;

        class_2487 prevData = compound.method_68568(key);
        class_2338 prevPos = prevData.method_67491("Pos", class_2338.field_25064).orElse(class_2338.field_10980);
        int prevSlot = prevData.method_68083("Slot", 0);

        class_2586 prevBlockEntity = world.method_8321(prevPos);
        if (prevBlockEntity instanceof ToolboxBlockEntity toolbox) {
            toolbox.unequip(prevSlot, player, hotbarSlot, keepItems || !ToolboxHandler.withinRange(player, toolbox));
        }
        compound.method_10551(key);
    }

    public static boolean withinRange(class_1657 player, ToolboxBlockEntity box) {
        if (player.method_37908() != box.method_10997())
            return false;
        double maxRange = getMaxRange(player);
        return distance(player.method_19538(), box.method_11016()) < maxRange * maxRange;
    }

    public static double distance(class_243 location, class_2338 p) {
        return location.method_1028(p.method_10263() + 0.5f, p.method_10264(), p.method_10260() + 0.5f);
    }

    public static double getMaxRange(class_1657 player) {
        return AllConfigs.server().equipment.toolboxRange.get().doubleValue();
    }

}
