package com.zurrtum.create.content.equipment.zapper;

import com.zurrtum.create.*;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.foundation.item.SwingControlItem;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.packet.s2c.ZapperBeamPacket;
import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_11352;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_8942;

public abstract class ZapperItem extends class_1792 implements SwingControlItem {

    public ZapperItem(class_1793 properties) {
        super(properties);
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_67187(
        class_1799 stack,
        class_9635 context,
        class_10712 displayComponent,
        Consumer<class_2561> tooltip,
        class_1836 flagIn
    ) {
        if (stack.method_57826(AllDataComponents.SHAPER_BLOCK_USED)) {
            class_5250 usedBlock = stack.method_58694(AllDataComponents.SHAPER_BLOCK_USED).method_26204().method_9518();
            tooltip.accept(class_2561.method_43469("create.terrainzapper.usingBlock", usedBlock.method_27692(class_124.field_1080))
                .method_27692(class_124.field_1063));
        }
    }

    //TODO
    //    @Override
    //    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
    //        boolean differentBlock = false;
    //        if (oldStack.contains(AllDataComponents.SHAPER_BLOCK_USED) && newStack.contains(AllDataComponents.SHAPER_BLOCK_USED))
    //            differentBlock = oldStack.get(AllDataComponents.SHAPER_BLOCK_USED) != newStack.get(AllDataComponents.SHAPER_BLOCK_USED);
    //        return slotChanged || !isZapper(newStack) || differentBlock;
    //    }

    public boolean isZapper(class_1799 newStack) {
        return newStack.method_7909() instanceof ZapperItem;
    }

    @Override
    @NotNull
    public class_1269 method_7884(class_1838 context) {
        // Shift -> open GUI
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            if (context.method_8045().field_9236) {
                openHandgunGUI(context.method_8041(), context.method_20287());
                context.method_8036().method_7357().method_62835(context.method_8041(), 10);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 item = player.method_5998(hand);
        boolean mainHand = hand == class_1268.field_5808;

        // Shift -> Open GUI
        if (player.method_5715()) {
            if (world.field_9236) {
                openHandgunGUI(item, hand);
                player.method_7357().method_62835(item, 10);
            }
            return class_1269.field_5812;
        }

        if (ShootableGadgetItemMethods.shouldSwap(player, item, hand, this::isZapper))
            return class_1269.field_5814;

        // Check if can be used
        class_2561 msg = validateUsage(item);
        if (msg != null) {
            AllSoundEvents.DENY.play(world, player, player.method_24515());
            player.method_7353(msg.method_27662().method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }

        class_2680 stateToUse = class_2246.field_10124.method_9564();
        if (item.method_57826(AllDataComponents.SHAPER_BLOCK_USED))
            stateToUse = item.method_58694(AllDataComponents.SHAPER_BLOCK_USED);
        stateToUse = BlockHelper.setZeroAge(stateToUse);
        class_2487 data = null;
        if (stateToUse.method_26164(AllBlockTags.SAFE_NBT) && item.method_57826(AllDataComponents.SHAPER_BLOCK_DATA)) {
            data = item.method_58694(AllDataComponents.SHAPER_BLOCK_DATA);
        }

        // Raytrace - Find the target
        class_243 start = player.method_19538().method_1031(0, player.method_5751(), 0);
        class_243 range = player.method_5720().method_1021(getZappingRange(item));
        class_3965 raytrace = world.method_17742(new class_3959(start, start.method_1019(range), class_3960.field_17559, class_242.field_1348, player));
        class_2338 pos = raytrace.method_17777();
        class_2680 stateReplaced = world.method_8320(pos);

        // No target
        if (pos == null || stateReplaced.method_26204() == class_2246.field_10124) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, getCooldownDelay(item));
            player.method_6021();
            return class_1269.field_5812;
        }

        // Find exact position of gun barrel for VFX
        class_243 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, mainHand, new class_243(.35f, -0.1f, 1));

        // Client side
        if (world.field_9236) {
            player.method_6021();
            AllClientHandle.INSTANCE.zapperDontAnimateItem(hand);
            return class_1269.field_5812;
        }

        // Server side
        if (activate(world, player, item, stateToUse, raytrace, data)) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, getCooldownDelay(item));
            ShootableGadgetItemMethods.sendPackets(player, b -> new ZapperBeamPacket(barrelPos, hand, b, raytrace.method_17784()));
        }

        player.method_6021();
        return class_1269.field_5812;
    }

    public class_2561 validateUsage(class_1799 item) {
        if (!canActivateWithoutSelectedBlock(item) && !item.method_57826(AllDataComponents.SHAPER_BLOCK_USED))
            return class_2561.method_43471("create.terrainzapper.leftClickToSet");
        return null;
    }

    protected abstract boolean activate(
        class_1937 world,
        class_1657 player,
        class_1799 item,
        class_2680 stateToUse,
        class_3965 raytrace,
        class_2487 data
    );

    protected abstract void openHandgunGUI(class_1799 item, class_1268 hand);

    protected abstract int getCooldownDelay(class_1799 item);

    protected abstract int getZappingRange(class_1799 stack);

    protected boolean canActivateWithoutSelectedBlock(class_1799 stack) {
        return false;
    }

    @Override
    public boolean onEntitySwing(class_1799 stack, class_1309 entity, class_1268 hand) {
        return true;
    }

    @Override
    public boolean method_7885(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1309 player) {
        return false;
    }

    public static void setBlockEntityData(class_1937 world, class_2338 pos, class_2680 state, class_2487 data, class_1657 player) {
        if (data != null && state.method_26164(AllBlockTags.SAFE_NBT)) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity != null) {
                data = NBTProcessors.process(state, blockEntity, data, !player.method_68878());
                if (data == null)
                    return;
                data.method_10569("x", pos.method_10263());
                data.method_10569("y", pos.method_10264());
                data.method_10569("z", pos.method_10260());
                try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), Create.LOGGER)) {
                    blockEntity.method_58690(class_11352.method_71417(logging, world.method_30349(), data));
                }
            }
        }
    }

}