package com.zurrtum.create.content.equipment.zapper.terrainzapper;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.infrastructure.component.PlacementOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class SphereBrush extends ShapedBrush {

    public static final int MAX_RADIUS = 10;
    private final Map<Integer, List<class_2338>> cachedBrushes;

    public SphereBrush() {
        super(1);

        cachedBrushes = new HashMap<>();
        for (int i = 0; i <= MAX_RADIUS; i++) {
            int radius = i;
            List<class_2338> positions = class_2338.method_20437(class_2338.field_10980.method_10069(-i - 1, -i - 1, -i - 1), class_2338.field_10980.method_10069(i + 1, i + 1, i + 1))
                .map(class_2338::new).filter(p -> VecHelper.getCenterOf(p).method_1022(VecHelper.getCenterOf(class_2338.field_11176)) < radius + .5f)
                .collect(Collectors.toList());
            cachedBrushes.put(i, positions);
        }
    }

    @Override
    public class_2338 getOffset(class_243 ray, class_2350 face, PlacementOptions option) {
        if (option == PlacementOptions.Merged)
            return class_2338.field_10980;

        int offset = option == PlacementOptions.Attached ? 0 : -1;
        int r = (param0 + 1 + offset);

        return class_2338.field_10980.method_10079(face, r * (option == PlacementOptions.Attached ? 1 : -1));
    }

    @Override
    public int getMax(int paramIndex) {
        return MAX_RADIUS;
    }

    @Override
    List<class_2338> getIncludedPositions() {
        return cachedBrushes.get(param0);
    }

}
