package com.zurrtum.create.content.fluids;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.api.effect.OpenPipeEffectHandler;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.fluids.pipes.VanillaFluidTargets;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

import static net.minecraft.class_2741.field_12508;

public class OpenEndedPipe extends FlowSource {
    private static final Function<class_2338, Codec<OpenEndedPipe>> CODEC = class_156.method_34866(pos -> RecordCodecBuilder.create(instance -> instance.group(
        FluidStack.OPTIONAL_CODEC.fieldOf("Fluid").forGetter(i -> i.fluidHandler.stack),
        Codec.BOOL.fieldOf("Pulling").forGetter(i -> i.wasPulling),
        class_2350.field_29502.fieldOf("Direction").forGetter(i -> i.location.getFace())
    ).apply(instance, (stack, wasPulling, direction) -> new OpenEndedPipe(stack, wasPulling, pos, direction))));

    public static Codec<OpenEndedPipe> codec(class_2338 pos) {
        return CODEC.apply(pos);
    }

    private class_1937 world;
    private final class_2338 pos;
    private class_238 aoe;

    private final OpenEndFluidHandler fluidHandler;
    private final class_2338 outputPos;
    private boolean wasPulling;

    public OpenEndedPipe(BlockFace face) {
        super(face);
        fluidHandler = new OpenEndFluidHandler();
        outputPos = face.getConnectedPos();
        pos = face.getPos();
        aoe = new class_238(outputPos).method_1012(0, -1, 0);
        if (face.getFace() == class_2350.field_11033)
            aoe = aoe.method_1012(0, -1, 0);
    }

    private OpenEndedPipe(FluidStack stack, boolean wasPulling, class_2338 pos, class_2350 direction) {
        this(new BlockFace(pos, direction));
        this.fluidHandler.stack = stack;
        this.wasPulling = wasPulling;
    }

    public class_1937 getWorld() {
        return world;
    }

    public class_2338 getPos() {
        return pos;
    }

    public class_2338 getOutputPos() {
        return outputPos;
    }

    public class_238 getAOE() {
        return aoe;
    }

    @Override
    public void manageSource(class_1937 world, class_2586 networkBE) {
        this.world = world;
    }

    @Override
    @Nullable
    public FluidInventory provideHandler() {
        return fluidHandler;
    }

    @Override
    public boolean isEndpoint() {
        return true;
    }

    private FluidStack removeFluidFromSpace(boolean simulate) {
        if (world == null)
            return FluidStack.EMPTY;
        if (!world.method_8477(outputPos))
            return FluidStack.EMPTY;

        class_2680 state = world.method_8320(outputPos);
        class_3610 fluidState = state.method_26227();
        boolean waterlog = state.method_28498(field_12508);

        FluidStack drainBlock = VanillaFluidTargets.drainBlock(world, outputPos, state, simulate);
        if (!drainBlock.isEmpty()) {
            if (!simulate && state.method_28498(class_2741.field_20432) && drainBlock.getFluid() == AllFluids.HONEY)
                AdvancementBehaviour.tryAward(world, pos, AllAdvancements.HONEY_DRAIN);
            return drainBlock;
        }

        if (!waterlog && !state.method_45474())
            return FluidStack.EMPTY;
        if (fluidState.method_15769() || !fluidState.method_15771())
            return FluidStack.EMPTY;

        FluidStack stack = new FluidStack(fluidState.method_15772(), BucketFluidInventory.CAPACITY);

        if (simulate)
            return stack;

        if (FluidHelper.isWater(stack.getFluid()))
            AdvancementBehaviour.tryAward(world, pos, AllAdvancements.WATER_SUPPLY);

        if (waterlog) {
            world.method_8652(outputPos, state.method_11657(field_12508, false), class_2248.field_31036);
            world.method_64312(outputPos, class_3612.field_15910, 1);
        } else {
            var newState = fluidState.method_15759().method_11657(class_2404.field_11278, 14);

            var newFluidState = newState.method_26227();

            if (newFluidState.method_15772() instanceof class_3609 flowing && world instanceof class_3218 serverWorld) {
                var potentiallyFilled = flowing.method_15727(serverWorld, outputPos, newState);

                // Check if we'd immediately become the same fluid again.
                if (potentiallyFilled.equals(fluidState)) {
                    // If so, no need to update the block state.
                    return stack;
                }
            }

            world.method_8652(outputPos, newState, class_2248.field_31036);
        }

        return stack;
    }

    private boolean provideFluidToSpace(FluidStack fluid, boolean simulate) {
        if (world == null)
            return false;
        if (!world.method_8477(outputPos))
            return false;

        class_2680 state = world.method_8320(outputPos);
        class_3610 fluidState = state.method_26227();
        boolean waterlog = state.method_28498(field_12508);

        if (!waterlog && !state.method_45474())
            return false;
        if (fluid.isEmpty())
            return false;
        if (!(fluid.getFluid() instanceof class_3609))
            return false;
        if (!FluidHelper.hasBlockState(fluid.getFluid()))
            return true;

        if (!fluidState.method_15769() && FluidHelper.convertToStill(fluidState.method_15772()) != fluid.getFluid()) {
            FluidReactions.handlePipeSpillCollision(world, outputPos, fluid.getFluid(), fluidState);
            return false;
        }

        if (fluidState.method_15771())
            return false;
        if (waterlog && fluid.getFluid() != class_3612.field_15910)
            return false;
        if (simulate)
            return true;

        if (!AllConfigs.server().fluids.pipesPlaceFluidSourceBlocks.get())
            return true;

        if (world.method_8597().comp_644() && FluidHelper.isTag(fluid, class_3486.field_15517)) {
            int i = outputPos.method_10263();
            int j = outputPos.method_10264();
            int k = outputPos.method_10260();
            world.method_43128(
                null,
                i,
                j,
                k,
                class_3417.field_15102,
                class_3419.field_15245,
                0.5F,
                2.6F + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8F
            );
            return true;
        }

        if (waterlog) {
            world.method_8652(outputPos, state.method_11657(field_12508, true), class_2248.field_31036);
            world.method_64312(outputPos, class_3612.field_15910, 1);
            return true;
        }

        world.method_8652(outputPos, fluid.getFluid().method_15785().method_15759(), class_2248.field_31036);
        return true;
    }

    private class OpenEndFluidHandler implements SidedFluidInventory {
        @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
        private static final Optional<Integer> MAX = Optional.of(BucketFluidInventory.CAPACITY);
        private static final int[] SLOTS = {0, 1};
        private FluidStack stack = FluidStack.EMPTY;
        private int previousAmount = 0;

        @Override
        public FluidStack onExtract(FluidStack stack) {
            return removeMaxSize(stack, MAX);
        }

        @Override
        public int getMaxAmountPerStack() {
            return BucketFluidInventory.CAPACITY;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public int[] getAvailableSlots(class_2350 side) {
            return SLOTS;
        }

        @Override
        public FluidStack getStack(int slot) {
            if (slot > 1) {
                return FluidStack.EMPTY;
            }
            if (slot == 0) {
                return stack;
            }
            if (stack == FluidStack.EMPTY) {
                stack = removeFluidFromSpace(false);
                if (!stack.isEmpty()) {
                    setMaxSize(stack, MAX);
                }
                return stack;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public int getMaxAmount(FluidStack stack) {
            OpenPipeEffectHandler effectHandler = OpenPipeEffectHandler.REGISTRY.get(stack.getFluid());
            if (effectHandler != null && !FluidHelper.hasBlockState(stack.getFluid())) {
                return 81;
            }
            return SidedFluidInventory.super.getMaxAmount(stack);
        }

        @Override
        public boolean canInsert(int slot, FluidStack resource, @Nullable class_2350 dir) {
            if (slot != 0 || !provideFluidToSpace(resource, true))
                return false;
            if (!stack.isEmpty() && !matches(stack, resource))
                stack = FluidStack.EMPTY;
            return true;
        }

        @Override
        public boolean canExtract(int slot, FluidStack stack, class_2350 dir) {
            return world != null && world.method_8477(outputPos);
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            if (slot != 0) {
                return;
            }
            if (stack != FluidStack.EMPTY) {
                setMaxSize(stack, MAX);
            }
            this.stack = stack;
        }

        @Override
        public void markDirty() {
            int amount = stack.getAmount();
            if (amount > previousAmount) {
                class_3611 fluid = stack.getFluid();
                OpenPipeEffectHandler effectHandler = OpenPipeEffectHandler.REGISTRY.get(fluid);
                if (effectHandler != null) {
                    effectHandler.apply(world, aoe, stack);
                }
                if (stack.getAmount() == BucketFluidInventory.CAPACITY || !FluidHelper.hasBlockState(fluid)) {
                    if (provideFluidToSpace(stack, false)) {
                        stack = FluidStack.EMPTY;
                    }
                }
                wasPulling = false;
            } else if (amount < previousAmount) {
                wasPulling = true;
            }
            previousAmount = stack.getAmount();
        }
    }
}
