package com.zurrtum.create.content.fluids.pipes.valve;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.pipes.StraightPipeBlockEntity.StraightPipeFluidTransportBehaviour;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class FluidValveBlockEntity extends KineticBlockEntity {

    public LerpedFloat pointer;

    public FluidValveBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.FLUID_VALVE, pos, state);
        pointer = LerpedFloat.linear().startWithValue(0).chase(0, 0, Chaser.LINEAR);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = getSpeed();
        pointer.chase(speed > 0 ? 1 : 0, getChaseSpeed(), Chaser.LINEAR);
        sendData();
    }

    @Override
    public void tick() {
        super.tick();
        pointer.tickChaser();

        if (field_11863.field_9236)
            return;

        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof FluidValveBlock))
            return;
        boolean stateOpen = blockState.method_11654(FluidValveBlock.ENABLED);

        if (stateOpen && pointer.getValue() == 0) {
            switchToBlockState(field_11863, field_11867, blockState.method_11657(FluidValveBlock.ENABLED, false));
            return;
        }
        if (!stateOpen && pointer.getValue() == 1) {
            switchToBlockState(field_11863, field_11867, blockState.method_11657(FluidValveBlock.ENABLED, true));
        }
    }

    private float getChaseSpeed() {
        return class_3532.method_15363(Math.abs(getSpeed()) / 16 / 20, 0, 1);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        pointer.write(view.method_71461("Pointer"));
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        pointer.read(view.method_71434("Pointer"), clientPacket);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new ValvePipeBehaviour(this));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return FluidPropagator.getSharedTriggers();
    }

    static class ValvePipeBehaviour extends StraightPipeFluidTransportBehaviour {

        public ValvePipeBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return FluidValveBlock.getPipeAxis(state) == direction.method_10166();
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, class_2680 state, class_2350 direction) {
            if (state.method_28498(FluidValveBlock.ENABLED) && state.method_11654(FluidValveBlock.ENABLED))
                return super.canPullFluidFrom(fluid, state, direction);
            return false;
        }

    }

}
