package com.zurrtum.create.content.fluids.tank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemPlacementSoundContext;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class FluidTankItem extends class_1747 {

    public FluidTankItem(class_2248 p_i48527_1_, class_1793 p_i48527_2_) {
        super(p_i48527_1_, p_i48527_2_);
    }

    @Override
    public class_1269 method_7712(class_1750 ctx) {
        class_1269 initialResult = super.method_7712(ctx);
        if (!initialResult.method_23665())
            return initialResult;
        tryMultiPlace(ctx);
        return initialResult;
    }

    @Override
    protected boolean method_7710(class_2338 blockPos, class_1937 level, class_1657 player, class_1799 itemStack, class_2680 blockState) {
        MinecraftServer minecraftserver = level.method_8503();
        if (minecraftserver == null)
            return false;
        class_9279 blockEntityData = itemStack.method_58694(class_9334.field_49611);
        if (blockEntityData != null) {
            class_2487 nbt = blockEntityData.method_57461();
            nbt.method_10551("Luminosity");
            nbt.method_10551("Size");
            nbt.method_10551("Height");
            nbt.method_10551("Controller");
            nbt.method_10551("LastKnownPos");
            if (nbt.method_10545("TankContent")) {
                FluidStack fluid = FluidStack.fromNbt(minecraftserver.method_30611(), nbt.method_10562("TankContent"));
                if (!fluid.isEmpty()) {
                    fluid.setAmount(Math.min(FluidTankBlockEntity.getCapacityMultiplier(), fluid.getAmount()));
                    nbt.method_10566("TankContent", fluid.toNbt(minecraftserver.method_30611()));
                }
            }
            nbt.method_67494("id", CreateCodecs.BLOCK_ENTITY_TYPE_CODEC, ((IBE<?>) this.method_7711()).getBlockEntityType());
            itemStack.method_57379(class_9334.field_49611, class_9279.method_57456(nbt));
        }
        return super.method_7710(blockPos, level, player, itemStack, blockState);
    }

    private void tryMultiPlace(class_1750 ctx) {
        class_1657 player = ctx.method_8036();
        if (player == null)
            return;
        if (player.method_5715())
            return;
        class_2350 face = ctx.method_8038();
        if (!face.method_10166().method_10178())
            return;
        class_1799 stack = ctx.method_8041();
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2338 placedOnPos = pos.method_10093(face.method_10153());
        class_2680 placedOnState = world.method_8320(placedOnPos);

        if (!FluidTankBlock.isTank(placedOnState))
            return;
        if (SymmetryWandItem.presentInHotbar(player))
            return;
        boolean creative = method_7711().equals(AllBlocks.CREATIVE_FLUID_TANK);
        FluidTankBlockEntity tankAt = ConnectivityHandler.partAt(
            creative ? AllBlockEntityTypes.CREATIVE_FLUID_TANK : AllBlockEntityTypes.FLUID_TANK,
            world,
            placedOnPos
        );
        if (tankAt == null)
            return;
        FluidTankBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null)
            return;

        int width = controllerBE.width;
        if (width == 1)
            return;

        int tanksToPlace = 0;
        class_2338 startPos = face == class_2350.field_11033 ? controllerBE.method_11016().method_10074() : controllerBE.method_11016().method_10086(controllerBE.height);

        if (startPos.method_10264() != pos.method_10264())
            return;

        for (int xOffset = 0; xOffset < width; xOffset++) {
            for (int zOffset = 0; zOffset < width; zOffset++) {
                class_2338 offsetPos = startPos.method_10069(xOffset, 0, zOffset);
                class_2680 blockState = world.method_8320(offsetPos);
                if (FluidTankBlock.isTank(blockState))
                    continue;
                if (!blockState.method_45474())
                    return;
                tanksToPlace++;
            }
        }

        if (!player.method_68878() && stack.method_7947() < tanksToPlace)
            return;

        ItemPlacementSoundContext context = new ItemPlacementSoundContext(ctx, 0.1f, 1.5f, SILENCED_METAL.method_10598());
        for (int xOffset = 0; xOffset < width; xOffset++) {
            for (int zOffset = 0; zOffset < width; zOffset++) {
                class_2338 offsetPos = startPos.method_10069(xOffset, 0, zOffset);
                class_2680 blockState = world.method_8320(offsetPos);
                if (FluidTankBlock.isTank(blockState))
                    continue;
                super.method_7712(context.offset(offsetPos, face));
            }
        }
    }

    // Tanks are less noisy when placed in batch
    public static final class_2498 SILENCED_METAL = new class_2498(
        0.1F,
        1.5F,
        class_3417.field_15044,
        class_3417.field_14924,
        class_3417.field_15167,
        class_3417.field_14557,
        class_3417.field_15142
    );
}
