package com.zurrtum.create.content.fluids.transfer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BBHelper;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import net.minecraft.block.*;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_6756;
import net.minecraft.class_6757;
import java.util.*;

public class FluidFillingBehaviour extends FluidManipulationBehaviour {

    public static final BehaviourType<FluidFillingBehaviour> TYPE = new BehaviourType<>();

    PriorityQueue<BlockPosEntry> queue;

    List<BlockPosEntry> infinityCheckFrontier;
    Set<class_2338> infinityCheckVisited;

    public FluidFillingBehaviour(SmartBlockEntity be) {
        super(be);
        queue = new ObjectHeapPriorityQueue<>((p, p2) -> -comparePositions(p, p2));
        revalidateIn = 1;
        infinityCheckFrontier = new ArrayList<>();
        infinityCheckVisited = new HashSet<>();
    }

    @Override
    public void tick() {
        super.tick();
        if (!infinityCheckFrontier.isEmpty() && rootPos != null) {
            class_3611 fluid = getWorld().method_8316(rootPos).method_15772();
            if (fluid != class_3612.field_15906)
                continueValidation(fluid);
        }
        if (revalidateIn > 0)
            revalidateIn--;
    }

    protected void continueValidation(class_3611 fluid) {
        try {
            search(fluid, infinityCheckFrontier, infinityCheckVisited, (p, d) -> infinityCheckFrontier.add(new BlockPosEntry(p, d)), true);
        } catch (ChunkNotLoadedException e) {
            infinityCheckFrontier.clear();
            infinityCheckVisited.clear();
            setLongValidationTimer();
            return;
        }

        int maxBlocks = maxBlocks();

        if (infinityCheckVisited.size() > maxBlocks && maxBlocks != -1 && !fillInfinite()) {
            if (!infinite) {
                reset();
                infinite = true;
                blockEntity.sendData();
            }
            infinityCheckFrontier.clear();
            setLongValidationTimer();
            return;
        }

        if (!infinityCheckFrontier.isEmpty())
            return;
        if (infinite) {
            reset();
            return;
        }

        infinityCheckVisited.clear();
    }

    public boolean tryDeposit(class_3611 fluid, class_2338 root, boolean simulate) {
        if (!Objects.equals(root, rootPos)) {
            reset();
            rootPos = root;
            queue.enqueue(new BlockPosEntry(root, 0));
            affectedArea = class_3341.method_34390(rootPos, rootPos);
            return false;
        }

        if (counterpartActed) {
            counterpartActed = false;
            softReset(root);
            return false;
        }

        if (affectedArea == null)
            affectedArea = class_3341.method_34390(root, root);

        if (revalidateIn == 0) {
            visited.clear();
            infinityCheckFrontier.clear();
            infinityCheckVisited.clear();
            infinityCheckFrontier.add(new BlockPosEntry(root, 0));
            setValidationTimer();
            softReset(root);
        }

        class_1937 world = getWorld();
        int maxRange = maxRange();
        int maxRangeSq = maxRange * maxRange;
        int maxBlocks = maxBlocks();
        boolean evaporate = world.method_8597().comp_644() && FluidHelper.isTag(fluid, class_3486.field_15517);
        boolean canPlaceSources = AllConfigs.server().fluids.fluidFillPlaceFluidSourceBlocks.get();

        if ((!fillInfinite() && infinite) || evaporate || !canPlaceSources) {
            class_3610 fluidState = world.method_8316(rootPos);
            boolean equivalentTo = fluidState.method_15772().method_15780(fluid);
            if (!equivalentTo && !evaporate && canPlaceSources)
                return false;
            if (simulate)
                return true;
            playEffect(world, root, fluid, false);
            if (evaporate) {
                int i = root.method_10263();
                int j = root.method_10264();
                int k = root.method_10260();
                world.method_43128(
                    null,
                    i,
                    j,
                    k,
                    class_3417.field_15102,
                    class_3419.field_15245,
                    0.5F,
                    2.6F + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8F
                );
            } else if (!canPlaceSources)
                blockEntity.award(AllAdvancements.HOSE_PULLEY);
            return true;
        }

        boolean success = false;
        for (int i = 0; !success && !queue.isEmpty() && i < searchedPerTick; i++) {
            BlockPosEntry entry = queue.first();
            class_2338 currentPos = entry.pos();

            if (visited.contains(currentPos)) {
                queue.dequeue();
                continue;
            }

            if (!simulate)
                visited.add(currentPos);

            if (visited.size() >= maxBlocks && maxBlocks != -1) {
                infinite = true;
                if (!fillInfinite()) {
                    visited.clear();
                    queue.clear();
                    return false;
                }
            }

            SpaceType spaceType = getAtPos(world, currentPos, fluid);
            if (spaceType == SpaceType.BLOCKING)
                continue;
            if (spaceType == SpaceType.FILLABLE) {
                success = true;
                if (!simulate) {
                    playEffect(world, currentPos, fluid, false);

                    class_2680 blockState = world.method_8320(currentPos);
                    if (blockState.method_28498(class_2741.field_12508) && fluid.method_15780(class_3612.field_15910)) {
                        if (!blockEntity.isVirtual())
                            world.method_8652(currentPos, updatePostWaterlogging(blockState.method_11657(class_2741.field_12508, true)), 2 | 16);
                    } else {
                        replaceBlock(world, currentPos, blockState);
                        if (!blockEntity.isVirtual())
                            world.method_8652(currentPos, FluidHelper.convertToStill(fluid).method_15785().method_15759(), 2 | 16);
                    }

                    class_6756<class_3611> pendingFluidTicks = world.method_8405();
                    if (pendingFluidTicks instanceof class_6757<class_3611> serverTickList) {
                        serverTickList.method_39380(new class_3341(currentPos));
                    }

                    affectedArea = BBHelper.encapsulate(affectedArea, currentPos);
                }
            }

            if (simulate && success)
                return true;

            visited.add(currentPos);
            queue.dequeue();

            for (class_2350 side : Iterate.directions) {
                if (side == class_2350.field_11036)
                    continue;

                class_2338 offsetPos = currentPos.method_10093(side);
                if (visited.contains(offsetPos))
                    continue;
                if (offsetPos.method_10262(rootPos) > maxRangeSq)
                    continue;

                SpaceType nextSpaceType = getAtPos(world, offsetPos, fluid);
                if (nextSpaceType != SpaceType.BLOCKING)
                    queue.enqueue(new BlockPosEntry(offsetPos, entry.distance() + 1));
            }
        }

        if (!simulate && success)
            blockEntity.award(AllAdvancements.HOSE_PULLEY);
        return success;
    }

    protected void softReset(class_2338 root) {
        visited.clear();
        queue.clear();
        queue.enqueue(new BlockPosEntry(root, 0));
        infinite = false;
        setValidationTimer();
        blockEntity.sendData();
    }

    enum SpaceType {
        FILLABLE,
        FILLED,
        BLOCKING
    }

    protected SpaceType getAtPos(class_1937 world, class_2338 pos, class_3611 toFill) {
        class_2680 blockState = world.method_8320(pos);
        class_3610 fluidState = blockState.method_26227();

        if (blockState.method_28498(class_2741.field_12508))
            return toFill.method_15780(class_3612.field_15910) ? blockState.method_11654(class_2741.field_12508) ? SpaceType.FILLED : SpaceType.FILLABLE : SpaceType.BLOCKING;

        if (blockState.method_26204() instanceof class_2404)
            return blockState.method_11654(class_2404.field_11278) == 0 ? toFill.method_15780(fluidState.method_15772()) ? SpaceType.FILLED : SpaceType.BLOCKING : SpaceType.FILLABLE;

        if (fluidState.method_15772() != class_3612.field_15906 && blockState.method_26194(getWorld(), pos, class_3726.method_16194()).method_1110())
            return toFill.method_15780(fluidState.method_15772()) ? SpaceType.FILLED : SpaceType.BLOCKING;

        return canBeReplacedByFluid(world, pos, blockState) ? SpaceType.FILLABLE : SpaceType.BLOCKING;
    }

    protected void replaceBlock(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        class_2248.method_9610(state, world, pos, blockEntity);
    }

    // From FlowingFluidBlock#isBlocked
    protected boolean canBeReplacedByFluid(class_1922 world, class_2338 pos, class_2680 pState) {
        class_2248 block = pState.method_26204();
        if (!(block instanceof class_2323) && !pState.method_26164(class_3481.field_41282) && !pState.method_27852(class_2246.field_9983) && !pState.method_27852(class_2246.field_10424) && !pState.method_27852(
            class_2246.field_10422)) {
            if (!pState.method_27852(class_2246.field_10316) && !pState.method_27852(class_2246.field_10027) && !pState.method_27852(class_2246.field_10613) && !pState.method_27852(class_2246.field_10369)) {
                return !pState.method_51366();
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    protected class_2680 updatePostWaterlogging(class_2680 state) {
        if (state.method_28498(class_2741.field_12548))
            state = state.method_11657(class_2741.field_12548, false);
        return state;
    }

    @Override
    public void reset() {
        super.reset();
        queue.clear();
        infinityCheckFrontier.clear();
        infinityCheckVisited.clear();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

}
