package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1542;
import net.minecraft.class_1928;
import net.minecraft.class_2189;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public abstract class BlockBreakingKineticBlockEntity extends KineticBlockEntity {

    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    protected int ticksUntilNextProgress;
    protected int destroyProgress;
    protected int breakerId = -NEXT_BREAKER_ID.incrementAndGet();
    protected class_2338 breakingPos;

    public BlockBreakingKineticBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (destroyProgress == -1)
            destroyNextTick();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (ticksUntilNextProgress == -1)
            destroyNextTick();
    }

    public void destroyNextTick() {
        ticksUntilNextProgress = 1;
    }

    protected abstract class_2338 getBreakingPos();

    protected boolean shouldRun() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Progress", destroyProgress);
        view.method_71465("NextTick", ticksUntilNextProgress);
        if (breakingPos != null)
            view.method_71468("Breaking", class_2338.field_25064, breakingPos);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        destroyProgress = view.method_71424("Progress", 0);
        ticksUntilNextProgress = view.method_71424("NextTick", 0);
        breakingPos = view.method_71426("Breaking", class_2338.field_25064).orElse(null);
        super.read(view, clientPacket);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (!field_11863.field_9236 && destroyProgress != 0)
            field_11863.method_8517(breakerId, breakingPos, -1);
    }

    @Override
    public void tick() {
        super.tick();

        if (field_11863.field_9236)
            return;
        if (!shouldRun())
            return;
        if (getSpeed() == 0)
            return;

        breakingPos = getBreakingPos();

        if (ticksUntilNextProgress < 0)
            return;
        if (ticksUntilNextProgress-- > 0)
            return;

        class_2680 stateToBreak = field_11863.method_8320(breakingPos);
        float blockHardness = stateToBreak.method_26214(field_11863, breakingPos);

        if (!canBreak(stateToBreak, blockHardness)) {
            if (destroyProgress != 0) {
                destroyProgress = 0;
                field_11863.method_8517(breakerId, breakingPos, -1);
            }
            return;
        }

        float breakSpeed = getBreakSpeed();
        destroyProgress += class_3532.method_15340((int) (breakSpeed / blockHardness), 1, 10 - destroyProgress);
        field_11863.method_8396(null, field_11867, stateToBreak.method_26231().method_10596(), class_3419.field_15245, .25f, 1);

        if (destroyProgress >= 10) {
            onBlockBroken(stateToBreak);
            destroyProgress = 0;
            ticksUntilNextProgress = -1;
            field_11863.method_8517(breakerId, breakingPos, -1);
            return;
        }

        ticksUntilNextProgress = (int) (blockHardness / breakSpeed);
        field_11863.method_8517(breakerId, breakingPos, (int) destroyProgress);
    }

    public boolean canBreak(class_2680 stateToBreak, float blockHardness) {
        return isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(class_2680 stateToBreak, float blockHardness) {
        return !(stateToBreak.method_51176() || stateToBreak.method_26204() instanceof class_2189 || blockHardness == -1 || stateToBreak.method_26164(AllBlockTags.NON_BREAKABLE));
    }

    public void onBlockBroken(class_2680 stateToBreak) {
        class_243 vec = VecHelper.offsetRandomly(VecHelper.getCenterOf(breakingPos), field_11863.field_9229, .125f);
        BlockHelper.destroyBlock(
            field_11863, breakingPos, 1f, (stack) -> {
                if (stack.method_7960())
                    return;
                if (!((class_3218) field_11863).method_64395().method_8355(class_1928.field_19392))
                    return;

                class_1542 itementity = new class_1542(field_11863, vec.field_1352, vec.field_1351, vec.field_1350, stack);
                itementity.method_6988();
                itementity.method_18799(class_243.field_1353);
                field_11863.method_8649(itementity);
            }
        );
    }

    protected float getBreakSpeed() {
        return Math.abs(getSpeed() / 100f);
    }

}
