package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.catnip.data.Iterate;
import net.minecraft.class_1750;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_4538;

public class HorizontalAxisKineticBlock extends KineticBlock {
    public static final class_2754<class_2350.class_2351> HORIZONTAL_AXIS = class_2741.field_12529;

    public HorizontalAxisKineticBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(HORIZONTAL_AXIS);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2351 preferredAxis = getPreferredHorizontalAxis(context);
        if (preferredAxis != null)
            return this.method_9564().method_11657(HORIZONTAL_AXIS, preferredAxis);
        return this.method_9564().method_11657(HORIZONTAL_AXIS, context.method_8042().method_10170().method_10166());
    }

    public static class_2351 getPreferredHorizontalAxis(class_1750 context) {
        class_2350 prefferedSide = null;
        for (class_2350 side : Iterate.horizontalDirections) {
            class_2680 blockState = context.method_8045().method_8320(context.method_8037().method_10093(side));
            if (blockState.method_26204() instanceof IRotate) {
                if (((IRotate) blockState.method_26204()).hasShaftTowards(
                    context.method_8045(),
                    context.method_8037().method_10093(side),
                    blockState,
                    side.method_10153()
                ))
                    if (prefferedSide != null && prefferedSide.method_10166() != side.method_10166()) {
                        prefferedSide = null;
                        break;
                    } else {
                        prefferedSide = side;
                    }
            }
        }
        return prefferedSide == null ? null : prefferedSide.method_10166();
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(HORIZONTAL_AXIS);
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == state.method_11654(HORIZONTAL_AXIS);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        class_2351 axis = state.method_11654(HORIZONTAL_AXIS);
        return state.method_11657(HORIZONTAL_AXIS, rot.method_10503(class_2350.method_10156(class_2352.field_11056, axis)).method_10166());
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state;
    }

}
