package com.zurrtum.create.content.kinetics.belt;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.kinetics.belt.transport.*;
import com.zurrtum.create.content.kinetics.belt.transport.BeltMovementHandler.TransportedEntityInfo;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3542;
import net.minecraft.class_6088;
import net.minecraft.util.math.*;
import java.util.*;
import java.util.function.Function;

import static com.zurrtum.create.content.kinetics.belt.BeltPart.MIDDLE;
import static com.zurrtum.create.content.kinetics.belt.BeltSlope.HORIZONTAL;
import static net.minecraft.class_2350.class_2352.field_11060;
import static net.minecraft.class_2350.class_2352.field_11056;

public class BeltBlockEntity extends KineticBlockEntity {
    public Map<class_1297, TransportedEntityInfo> passengers;
    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public Optional<class_1767> color;
    public int beltLength;
    public int index;
    public CasingType casing;
    public boolean covered;

    protected class_2338 controller;
    protected BeltInventory inventory;
    public ItemHandlerBeltSegment itemHandler;
    public VersionedInventoryTrackerBehaviour invVersionTracker;

    public class_2487 trackerUpdateTag;

    public enum CasingType implements class_3542 {
        NONE,
        ANDESITE,
        BRASS;

        public static final Codec<CasingType> CODEC = class_3542.method_28140(CasingType::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public BeltBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.BELT, pos, state);
        controller = class_2338.field_10980;
        itemHandler = null;
        casing = CasingType.NONE;
        color = Optional.empty();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::canInsertFrom).setInsertionHandler(this::tryInsertingFromSide)
            .considerOccupiedWhen(this::isOccupied));
        behaviours.add(new TransportedItemStackHandlerBehaviour(this, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf));
        behaviours.add(invVersionTracker = new VersionedInventoryTrackerBehaviour(this));
    }

    @Override
    public void tick() {
        // Init belt
        if (beltLength == 0)
            BeltBlock.initBelt(field_11863, field_11867);

        super.tick();

        if (!field_11863.method_8320(field_11867).method_27852(AllBlocks.BELT))
            return;

        initializeItemHandler();

        // Move Items
        if (!isController())
            return;

        invalidateRenderBoundingBox();

        getInventory().tick();

        if (getSpeed() == 0)
            return;

        // Move Entities
        if (passengers == null)
            passengers = new HashMap<>();

        List<class_1297> toRemove = new ArrayList<>();
        passengers.forEach((entity, info) -> {
            boolean canBeTransported = BeltMovementHandler.canBeTransported(entity);
            boolean leftTheBelt = info.getTicksSinceLastCollision() > ((method_11010().method_11654(BeltBlock.SLOPE) != HORIZONTAL) ? 3 : 1);
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }

            info.tick();
            BeltMovementHandler.transportEntity(this, entity, info);
        });
        toRemove.forEach(passengers::remove);
    }

    @Override
    public float calculateStressApplied() {
        if (!isController())
            return 0;
        return super.calculateStressApplied();
    }

    @Override
    public class_238 createRenderBoundingBox() {
        if (!isController())
            return super.createRenderBoundingBox();
        else
            return super.createRenderBoundingBox().method_1014(beltLength + 1);
    }

    public void initializeItemHandler() {
        if (field_11863.field_9236 || itemHandler != null)
            return;
        if (beltLength == 0 || controller == null)
            return;
        if (!field_11863.method_8477(controller))
            return;
        class_2586 be = field_11863.method_8321(controller);
        if (be == null || !(be instanceof BeltBlockEntity))
            return;
        BeltInventory inventory = ((BeltBlockEntity) be).getInventory();
        if (inventory == null)
            return;
        itemHandler = new ItemHandlerBeltSegment(inventory, index);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (isController())
            getInventory().ejectAll();
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (controller != null)
            view.method_71468("Controller", class_2338.field_25064, controller);
        view.method_71472("IsController", isController());
        view.method_71465("Length", beltLength);
        view.method_71465("Index", index);
        view.method_71468("Casing", CasingType.CODEC, casing);
        view.method_71472("Covered", covered);

        color.ifPresent(dyeColor -> view.method_71468("Dye", class_1767.field_41600, dyeColor));

        if (isController())
            getInventory().write(view.method_71461("Inventory"));
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);

        if (view.method_71433("IsController", false))
            controller = field_11867;

        color = view.method_71426("Dye", class_1767.field_41600);

        if (!wasMoved) {
            if (!isController())
                controller = view.method_71426("Controller", class_2338.field_25064).orElse(null);
            index = view.method_71424("Index", 0);
            beltLength = view.method_71424("Length", 0);
        }

        if (isController())
            getInventory().read(view.method_71434("Inventory"));

        CasingType casingBefore = casing;
        boolean coverBefore = covered;
        casing = view.method_71426("Casing", CasingType.CODEC).orElse(CasingType.NONE);
        covered = view.method_71433("Covered", false);

        if (!clientPacket)
            return;

        if (casingBefore == casing && coverBefore == covered)
            return;
        if (method_11002())
            field_11863.method_8413(method_11016(), method_11010(), method_11010(), 16);
    }

    @Override
    public void clearKineticInformation() {
        super.clearKineticInformation();
        beltLength = 0;
        index = 0;
        controller = null;
        trackerUpdateTag = new class_2487();
    }

    public boolean applyColor(class_1767 colorIn) {
        if (colorIn == null) {
            if (!color.isPresent())
                return false;
        } else if (color.isPresent() && color.get() == colorIn)
            return false;
        if (field_11863.method_8608())
            return true;

        for (class_2338 blockPos : BeltBlock.getBeltChain(field_11863, getController())) {
            BeltBlockEntity belt = BeltHelper.getSegmentBE(field_11863, blockPos);
            if (belt == null)
                continue;
            belt.color = Optional.ofNullable(colorIn);
            belt.method_5431();
            belt.sendData();
        }

        return true;
    }

    public BeltBlockEntity getControllerBE() {
        if (controller == null)
            return null;
        if (!field_11863.method_8477(controller))
            return null;
        class_2586 be = field_11863.method_8321(controller);
        if (be == null || !(be instanceof BeltBlockEntity))
            return null;
        return (BeltBlockEntity) be;
    }

    public void setController(class_2338 controller) {
        this.controller = controller;
    }

    public class_2338 getController() {
        return controller == null ? field_11867 : controller;
    }

    public boolean isController() {
        return controller != null && field_11867.method_10263() == controller.method_10263() && field_11867.method_10264() == controller.method_10264() && field_11867.method_10260() == controller.method_10260();
    }

    public float getBeltMovementSpeed() {
        return getSpeed() / 480f;
    }

    public float getDirectionAwareBeltMovementSpeed() {
        int offset = getBeltFacing().method_10171().method_10181();
        if (getBeltFacing().method_10166() == class_2351.field_11048)
            offset *= -1;
        return getBeltMovementSpeed() * offset;
    }

    public boolean hasPulley() {
        if (!method_11010().method_27852(AllBlocks.BELT))
            return false;
        return method_11010().method_11654(BeltBlock.PART) != MIDDLE;
    }

    protected boolean isLastBelt() {
        if (getSpeed() == 0)
            return false;

        class_2350 direction = getBeltFacing();
        if (method_11010().method_11654(BeltBlock.SLOPE) == BeltSlope.VERTICAL)
            return false;

        BeltPart part = method_11010().method_11654(BeltBlock.PART);
        if (part == MIDDLE)
            return false;

        boolean movingPositively = (getSpeed() > 0 == (direction.method_10171().method_10181() == 1)) ^ direction.method_10166() == class_2351.field_11048;
        return part == BeltPart.START ^ movingPositively;
    }

    public class_2382 getMovementDirection(boolean firstHalf) {
        return this.getMovementDirection(firstHalf, false);
    }

    public class_2382 getBeltChainDirection() {
        return this.getMovementDirection(true, true);
    }

    protected class_2382 getMovementDirection(boolean firstHalf, boolean ignoreHalves) {
        if (getSpeed() == 0)
            return class_2338.field_11176;

        final class_2680 blockState = method_11010();
        final class_2350 beltFacing = blockState.method_11654(class_2741.field_12481);
        final BeltSlope slope = blockState.method_11654(BeltBlock.SLOPE);
        final BeltPart part = blockState.method_11654(BeltBlock.PART);
        final class_2351 axis = beltFacing.method_10166();

        class_2350 movementFacing = class_2350.method_10156(axis == class_2351.field_11048 ? field_11060 : field_11056, axis);
        boolean notHorizontal = blockState.method_11654(BeltBlock.SLOPE) != HORIZONTAL;
        if (getSpeed() < 0)
            movementFacing = movementFacing.method_10153();
        class_2382 movement = movementFacing.method_62675();

        boolean slopeBeforeHalf = (part == BeltPart.END) == (beltFacing.method_10171() == field_11056);
        boolean onSlope = notHorizontal && (part == MIDDLE || slopeBeforeHalf == firstHalf || ignoreHalves);
        boolean movingUp = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD);

        if (!onSlope)
            return movement;

        return new class_2382(movement.method_10263(), movingUp ? 1 : -1, movement.method_10260());
    }

    public class_2350 getMovementFacing() {
        class_2351 axis = getBeltFacing().method_10166();
        return class_2350.method_10169(axis, getBeltMovementSpeed() < 0 ^ axis == class_2351.field_11048 ? field_11060 : field_11056);
    }

    public class_2350 getBeltFacing() {
        return method_11010().method_11654(class_2741.field_12481);
    }

    public BeltInventory getInventory() {
        if (!isController()) {
            BeltBlockEntity controllerBE = getControllerBE();
            if (controllerBE != null)
                return controllerBE.getInventory();
            return null;
        }
        if (inventory == null) {
            inventory = new BeltInventory(this);
        }
        return inventory;
    }

    private void applyToAllItems(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedResult> processFunction) {
        BeltBlockEntity controller = getControllerBE();
        if (controller == null)
            return;
        BeltInventory inventory = controller.getInventory();
        if (inventory != null)
            inventory.applyToEachWithin(index + .5f, maxDistanceFromCenter, processFunction);
    }

    private class_243 getWorldPositionOf(TransportedItemStack transported) {
        BeltBlockEntity controllerBE = getControllerBE();
        if (controllerBE == null)
            return class_243.field_1353;
        return BeltHelper.getVectorForOffset(controllerBE, transported.beltPosition);
    }

    public void setCasingType(CasingType type) {
        if (casing == type)
            return;

        class_2680 blockState = method_11010();
        boolean shouldBlockHaveCasing = type != CasingType.NONE;

        if (field_11863.field_9236) {
            casing = type;
            field_11863.method_8652(field_11867, blockState.method_11657(BeltBlock.CASING, shouldBlockHaveCasing), 0);
            AllClientHandle.INSTANCE.queueUpdate(this);
            field_11863.method_8413(field_11867, method_11010(), method_11010(), 16);
            return;
        }

        if (casing != CasingType.NONE)
            field_11863.method_20290(
                class_6088.field_31144,
                field_11867,
                class_2248.method_9507(casing == CasingType.ANDESITE ? AllBlocks.ANDESITE_CASING.method_9564() : AllBlocks.BRASS_CASING.method_9564())
            );
        if (blockState.method_11654(BeltBlock.CASING) != shouldBlockHaveCasing)
            KineticBlockEntity.switchToBlockState(field_11863, field_11867, blockState.method_11657(BeltBlock.CASING, shouldBlockHaveCasing));
        casing = type;
        method_5431();
        sendData();
    }

    private boolean canInsertFrom(class_2350 side) {
        if (getSpeed() == 0)
            return false;
        class_2680 state = method_11010();
        if (state.method_28498(BeltBlock.SLOPE) && (state.method_11654(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS || state.method_11654(BeltBlock.SLOPE) == BeltSlope.VERTICAL))
            return false;
        return getMovementFacing() != side.method_10153();
    }

    private boolean isOccupied(class_2350 side) {
        BeltBlockEntity nextBeltController = getControllerBE();
        if (nextBeltController == null)
            return true;
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null)
            return true;
        if (getSpeed() == 0)
            return true;
        if (getMovementFacing() == side.method_10153())
            return true;
        if (!nextInventory.canInsertAtFromSide(index, side))
            return true;
        return false;
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        BeltBlockEntity nextBeltController = getControllerBE();
        class_1799 inserted = transportedStack.stack;
        class_1799 empty = class_1799.field_8037;

        if (!BeltBlock.canTransportObjects(method_11010()))
            return inserted;
        if (nextBeltController == null)
            return inserted;
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null)
            return inserted;

        class_2586 teAbove = field_11863.method_8321(field_11867.method_10084());
        if (teAbove instanceof BrassTunnelBlockEntity tunnelBE) {
            if (tunnelBE.hasDistributionBehaviour()) {
                if (!tunnelBE.getStackToDistribute().method_7960())
                    return inserted;
                if (!tunnelBE.testFlapFilter(side.method_10153(), inserted))
                    return inserted;
                if (!simulate) {
                    BeltTunnelInteractionHandler.flapTunnel(nextInventory, index, side.method_10153(), true);
                    tunnelBE.setStackToDistribute(inserted, side.method_10153());
                }
                return empty;
            }
        }

        if (isOccupied(side))
            return inserted;
        if (simulate)
            return empty;

        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = index + .5f - Math.signum(getDirectionAwareBeltMovementSpeed()) / 16f;

        class_2350 movementFacing = getMovementFacing();
        if (!side.method_10166().method_10178()) {
            if (movementFacing != side) {
                transportedStack.sideOffset = side.method_10171().method_10181() * .675f;
                if (side.method_10166() == class_2351.field_11048)
                    transportedStack.sideOffset *= -1;
            } else {
                // This creates a smoother transition from belt to belt
                float extraOffset = transportedStack.prevBeltPosition != 0 && BeltHelper.getSegmentBE(
                    field_11863,
                    field_11867.method_10093(movementFacing.method_10153())
                ) != null ? .26f : 0;
                transportedStack.beltPosition = getDirectionAwareBeltMovementSpeed() > 0 ? index - extraOffset : index + 1 + extraOffset;
            }
        }

        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.insertedAt = index;
        transportedStack.insertedFrom = side;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;

        BeltTunnelInteractionHandler.flapTunnel(nextInventory, index, side.method_10153(), true);

        nextInventory.addItem(transportedStack);
        nextBeltController.method_5431();
        nextBeltController.sendData();
        return empty;
    }

    @Override
    protected boolean canPropagateDiagonally(IRotate block, class_2680 state) {
        return state.method_28498(BeltBlock.SLOPE) && (state.method_11654(BeltBlock.SLOPE) == BeltSlope.UPWARD || state.method_11654(BeltBlock.SLOPE) == BeltSlope.DOWNWARD);
    }

    @Override
    public float propagateRotationTo(
        KineticBlockEntity target,
        class_2680 stateFrom,
        class_2680 stateTo,
        class_2338 diff,
        boolean connectedViaAxes,
        boolean connectedViaCogs
    ) {
        if (target instanceof BeltBlockEntity && !connectedViaAxes)
            return getController().equals(((BeltBlockEntity) target).getController()) ? 1 : 0;
        return 0;
    }

    public void invalidateItemHandler() {
        itemHandler = null;
    }

    public boolean shouldSkipVanillaRender() {
        if (field_11863 == null)
            return !isController();
        class_2680 state = method_11010();
        return state == null || !state.method_28498(BeltBlock.PART) || state.method_11654(BeltBlock.PART) != BeltPart.START;
    }

    public void setCovered(boolean blockCoveringBelt) {
        if (blockCoveringBelt == covered)
            return;
        covered = blockCoveringBelt;
        notifyUpdate();
    }
}
