package com.zurrtum.create.content.kinetics.belt.transport;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.displayLink.source.AccumulatedItemCountDisplaySource;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class BeltTunnelInteractionHandler {

    public static boolean flapTunnelsAndCheckIfStuck(BeltInventory beltInventory, TransportedItemStack current, float nextOffset) {

        int currentSegment = (int) current.beltPosition;
        int upcomingSegment = (int) nextOffset;

        class_2350 movementFacing = beltInventory.belt.getMovementFacing();
        if (!beltInventory.beltMovementPositive && nextOffset == 0)
            upcomingSegment = -1;
        if (currentSegment == upcomingSegment)
            return false;

        if (stuckAtTunnel(beltInventory, upcomingSegment, current.stack, movementFacing)) {
            current.beltPosition = currentSegment + (beltInventory.beltMovementPositive ? .99f : .01f);
            return true;
        }

        class_1937 world = beltInventory.belt.method_10997();
        boolean onServer = !world.field_9236 || beltInventory.belt.isVirtual();
        boolean removed = false;
        BeltTunnelBlockEntity nextTunnel = getTunnelOnSegment(beltInventory, upcomingSegment);
        int transferred = current.stack.method_7947();

        if (nextTunnel instanceof BrassTunnelBlockEntity brassTunnel) {
            if (brassTunnel.hasDistributionBehaviour()) {
                if (!brassTunnel.canTakeItems())
                    return true;
                if (onServer) {
                    brassTunnel.setStackToDistribute(current.stack, movementFacing.method_10153());
                    current.stack = class_1799.field_8037;
                    beltInventory.belt.notifyUpdate();
                }
                removed = true;
            }
        } else if (nextTunnel != null) {
            class_2680 blockState = nextTunnel.method_11010();
            if (current.stack.method_7947() > 1 && blockState.method_27852(AllBlocks.ANDESITE_TUNNEL) && BeltTunnelBlock.isJunction(blockState) && movementFacing.method_10166() == blockState.method_11654(
                BeltTunnelBlock.HORIZONTAL_AXIS)) {

                for (class_2350 d : Iterate.horizontalDirections) {
                    if (d.method_10166() == blockState.method_11654(BeltTunnelBlock.HORIZONTAL_AXIS))
                        continue;
                    if (!nextTunnel.flaps.containsKey(d))
                        continue;
                    class_2338 outpos = nextTunnel.method_11016().method_10074().method_10093(d);
                    if (!world.method_8477(outpos))
                        return true;
                    DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get(world, outpos, DirectBeltInputBehaviour.TYPE);
                    if (behaviour == null)
                        continue;
                    if (!behaviour.canInsertFromSide(d))
                        continue;

                    class_1799 toinsert = current.stack.method_46651(1);
                    if (!behaviour.handleInsertion(toinsert, d, false).method_7960())
                        return true;
                    if (onServer)
                        flapTunnel(beltInventory, upcomingSegment, d, false);

                    current.stack.method_7934(1);
                    beltInventory.belt.notifyUpdate();
                    if (current.stack.method_7947() <= 1)
                        break;
                }
            }
        }

        if (onServer) {
            flapTunnel(beltInventory, currentSegment, movementFacing, false);
            flapTunnel(beltInventory, upcomingSegment, movementFacing.method_10153(), true);

            if (nextTunnel != null)
                DisplayLinkBlock.sendToGatherers(
                    world,
                    nextTunnel.method_11016(),
                    (dgte, b) -> b.itemReceived(dgte, transferred),
                    AccumulatedItemCountDisplaySource.class
                );
        }

        return removed;
    }

    public static boolean stuckAtTunnel(BeltInventory beltInventory, int offset, class_1799 stack, class_2350 movementDirection) {
        BeltBlockEntity belt = beltInventory.belt;
        class_2338 pos = BeltHelper.getPositionForOffset(belt, offset).method_10084();
        if (!(belt.method_10997().method_8320(pos).method_26204() instanceof BrassTunnelBlock))
            return false;
        class_2586 be = belt.method_10997().method_8321(pos);
        if (be == null || !(be instanceof BrassTunnelBlockEntity tunnel))
            return false;
        return !tunnel.canInsert(movementDirection.method_10153(), stack);
    }

    public static void flapTunnel(BeltInventory beltInventory, int offset, class_2350 side, boolean inward) {
        BeltTunnelBlockEntity be = getTunnelOnSegment(beltInventory, offset);
        if (be == null)
            return;
        be.flap(side, inward);
    }

    protected static BeltTunnelBlockEntity getTunnelOnSegment(BeltInventory beltInventory, int offset) {
        BeltBlockEntity belt = beltInventory.belt;
        if (belt.method_11010().method_11654(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL)
            return null;
        return getTunnelOnPosition(belt.method_10997(), BeltHelper.getPositionForOffset(belt, offset));
    }

    public static BeltTunnelBlockEntity getTunnelOnPosition(class_1937 world, class_2338 pos) {
        pos = pos.method_10084();
        if (!(world.method_8320(pos).method_26204() instanceof BeltTunnelBlock))
            return null;
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof BeltTunnelBlockEntity))
            return null;
        return ((BeltTunnelBlockEntity) be);
    }

}
