package com.zurrtum.create.content.kinetics.crafter;

import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler.ConnectedInput;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class CrafterHelper {

    public static MechanicalCrafterBlockEntity getCrafter(class_1920 reader, class_2338 pos) {
        class_2586 blockEntity = reader.method_8321(pos);
        if (blockEntity instanceof MechanicalCrafterBlockEntity mechanicalCrafterBlockEntity) {
            return mechanicalCrafterBlockEntity;
        }
        return null;
    }

    public static ConnectedInput getInput(class_1920 reader, class_2338 pos) {
        MechanicalCrafterBlockEntity crafter = getCrafter(reader, pos);
        return crafter == null ? null : crafter.input;
    }

    public static boolean areCraftersConnected(class_1920 reader, class_2338 pos, class_2338 otherPos) {
        ConnectedInput input1 = getInput(reader, pos);
        ConnectedInput input2 = getInput(reader, otherPos);

        if (input1 == null || input2 == null)
            return false;
        if (input1.data.isEmpty() || input2.data.isEmpty())
            return false;
        try {
            if (pos.method_10081(input1.data.getFirst()).equals(otherPos.method_10081(input2.data.getFirst())))
                return true;
        } catch (IndexOutOfBoundsException e) {
            // race condition. data somehow becomes empty between the last 2 if statements
        }

        return false;
    }

}
