package com.zurrtum.create.content.kinetics.crusher;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.*;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1263;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.world.*;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;

public class CrushingWheelControllerBlock extends class_2318 implements IBE<CrushingWheelControllerBlockEntity>, ItemInventoryProvider<CrushingWheelControllerBlockEntity> {

    public CrushingWheelControllerBlock(class_2251 p_i48440_1_) {
        super(p_i48440_1_);
    }

    @Override
    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Override
    protected float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        return 0;
    }

    @Override
    public class_1263 getInventory(
        class_1936 world,
        class_2338 pos,
        class_2680 state,
        CrushingWheelControllerBlockEntity blockEntity,
        class_2350 context
    ) {
        return blockEntity.inventory;
    }

    public static final class_2746 VALID = class_2746.method_11825("valid");

    public static final MapCodec<CrushingWheelControllerBlock> field_46280 = method_54094(CrushingWheelControllerBlock::new);

    @Override
    public boolean method_9616(class_2680 state, class_1750 useContext) {
        return false;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(VALID);
        builder.method_11667(field_10927);
        super.method_9515(builder);
    }

    @Override
    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entityIn, class_10774 handler) {
        if (!state.method_11654(VALID))
            return;

        class_2350 facing = state.method_11654(field_10927);
        class_2351 axis = facing.method_10166();

        checkEntityForProcessing(worldIn, pos, entityIn);

        withBlockEntityDo(
            worldIn, pos, be -> {
                if (be.processingEntity == entityIn) {
                    entityIn.method_5844(
                        state,
                        new class_243(
                            axis == class_2351.field_11048 ? (double) 0.05F : 0.25D,
                            axis == class_2351.field_11052 ? (double) 0.05F : 0.25D,
                            axis == class_2351.field_11051 ? (double) 0.05F : 0.25D
                        )
                    );
                }
            }
        );
    }

    public void checkEntityForProcessing(class_1937 worldIn, class_2338 pos, class_1297 entityIn) {
        CrushingWheelControllerBlockEntity be = getBlockEntity(worldIn, pos);
        if (be == null)
            return;
        if (be.crushingspeed == 0)
            return;
        //		if (entityIn instanceof ItemEntity)
        //			((ItemEntity) entityIn).setPickUpDelay(10);
        if (entityIn instanceof class_1542) {
            Optional<class_2338> value = AllSynchedDatas.BYPASS_CRUSHING_WHEEL.get(entityIn);
            if (value.isPresent() && pos.equals(value.get()))
                return;
        }
        if (be.isOccupied())
            return;
        if (entityIn instanceof class_1657 player) {
            if (player.method_68878())
                return;
            if (entityIn.method_37908().method_8407() == class_1267.field_5801)
                return;
        }

        be.startCrushing(entityIn);
    }

    @Override
    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);
        // Moved to onEntityCollision to allow for omnidirectional input
    }

    @Override
    public void method_9496(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_5819 rand) {
        if (!stateIn.method_11654(VALID))
            return;
        if (rand.method_43048(1) != 0)
            return;
        double d0 = (float) pos.method_10263() + rand.method_43057();
        double d1 = (float) pos.method_10264() + rand.method_43057();
        double d2 = (float) pos.method_10260() + rand.method_43057();
        worldIn.method_8406(class_2398.field_11205, d0, d1, d2, 0.0D, 0.0D, 0.0D);
    }

    @Override
    public class_2680 method_9559(
        class_2680 stateIn,
        class_4538 worldIn,
        class_10225 tickView,
        class_2338 currentPos,
        class_2350 facing,
        class_2338 facingPos,
        class_2680 facingState,
        class_5819 random
    ) {
        updateSpeed(stateIn, worldIn, currentPos);
        return stateIn;
    }

    public void updateSpeed(class_2680 state, class_4538 world, class_2338 pos) {
        withBlockEntityDo(
            world, pos, be -> {
                if (!state.method_11654(VALID)) {
                    if (be.crushingspeed != 0) {
                        be.crushingspeed = 0;
                        be.sendData();
                    }
                    return;
                }

                for (class_2350 d : Iterate.directions) {
                    class_2680 neighbour = world.method_8320(pos.method_10093(d));
                    if (!neighbour.method_27852(AllBlocks.CRUSHING_WHEEL))
                        continue;
                    if (neighbour.method_11654(class_2741.field_12496) == d.method_10166())
                        continue;
                    class_2586 adjBE = world.method_8321(pos.method_10093(d));
                    if (!(adjBE instanceof CrushingWheelBlockEntity cwbe))
                        continue;
                    be.crushingspeed = Math.abs(cwbe.getSpeed() / 50f);
                    be.sendData();

                    cwbe.award(AllAdvancements.CRUSHING_WHEEL);
                    if (Math.abs(cwbe.getSpeed()) > AllConfigs.server().kinetics.maxRotationSpeed.get() - 1)
                        cwbe.award(AllAdvancements.CRUSHER_MAXED);

                    break;
                }
            }
        );
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        class_265 standardShape = AllShapes.CRUSHING_WHEEL_CONTROLLER_COLLISION.get(state.method_11654(field_10927));

        if (!state.method_11654(VALID))
            return standardShape;
        if (!(context instanceof class_3727 entityShapeContext))
            return standardShape;
        class_1297 entity = entityShapeContext.method_32480();
        if (entity == null)
            return standardShape;

        if (entity instanceof class_1542 && state.method_11654(field_10927) != class_2350.field_11036) {
            Optional<class_2338> value = AllSynchedDatas.BYPASS_CRUSHING_WHEEL.get(entity);
            if (value.isPresent() && pos.equals(value.get())) // Allow output items to land on top of the block rather
                return class_259.method_1073();                    // than falling back through.
        }

        CrushingWheelControllerBlockEntity be = getBlockEntity(worldIn, pos);
        if (be != null && be.processingEntity == entity)
            return class_259.method_1073();

        return standardShape;
    }

    @Override
    public Class<CrushingWheelControllerBlockEntity> getBlockEntityClass() {
        return CrushingWheelControllerBlockEntity.class;
    }

    @Override
    public class_2591<? extends CrushingWheelControllerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CRUSHING_WHEEL_CONTROLLER;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2318> method_53969() {
        return field_46280;
    }
}
