package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperItem;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import net.minecraft.class_10289;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;
import net.minecraft.class_4844;
import net.minecraft.class_8786;
import net.minecraft.class_8942;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;

import static com.zurrtum.create.Create.LOGGER;
import static com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock.FACING;

public class DeployerBlockEntity extends KineticBlockEntity {
    public State state;
    public Mode mode;
    public class_1799 heldItem;
    protected DeployerPlayer player;
    public int timer;
    public float reach;
    public boolean fistBump = false;
    public List<class_1799> overflowItems = new ArrayList<>();
    protected ServerFilteringBehaviour filtering;
    protected boolean redstoneLocked;
    protected UUID owner;
    protected String ownerName;
    public class_1263 invHandler;
    private class_2487 deferredInventoryList;

    public LerpedFloat animatedOffset;

    public BeltProcessingBehaviour processingBehaviour;

    public enum State implements class_3542 {
        WAITING,
        EXPANDING,
        RETRACTING,
        DUMPING;

        public static final Codec<State> CODEC = class_3542.method_28140(State::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public enum Mode implements class_3542 {
        PUNCH,
        USE;

        public static final Codec<Mode> CODEC = class_3542.method_28140(Mode::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public DeployerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.DEPLOYER, pos, state);
        this.state = State.WAITING;
        mode = Mode.USE;
        heldItem = class_1799.field_8037;
        redstoneLocked = false;
        animatedOffset = LerpedFloat.linear().startWithValue(0);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        discardPlayer();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        filtering = new ServerFilteringBehaviour(this);
        behaviours.add(filtering);
        processingBehaviour = new BeltProcessingBehaviour(this).whenItemEnters((s, i) -> BeltDeployerCallbacks.onItemReceived(s, i, this))
            .whileItemHeld((s, i) -> BeltDeployerCallbacks.whenItemHeld(s, i, this));
        behaviours.add(processingBehaviour);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(
            AllAdvancements.TRAIN_CASING,
            AllAdvancements.ANDESITE_CASING,
            AllAdvancements.BRASS_CASING,
            AllAdvancements.COPPER_CASING,
            AllAdvancements.FIST_BUMP,
            AllAdvancements.DEPLOYER,
            AllAdvancements.SELF_DEPLOYING
        );
    }

    @Override
    public void initialize() {
        super.initialize();
        initHandler();
    }

    public void initHandler() {
        if (invHandler != null)
            return;
        if (field_11863 instanceof class_3218 sLevel) {
            player = DeployerPlayer.create(sLevel, owner, ownerName);
            class_3222 serverPlayer = player.cast();
            if (deferredInventoryList != null) {
                try (class_8942.class_11340 logging = new class_8942.class_11340(method_71402(), LOGGER)) {
                    class_11368 view = class_11352.method_71417(logging, field_11863.method_30349(), deferredInventoryList);
                    serverPlayer.method_31548().method_7397(view.method_71437("Inventory", class_11343.field_60354));
                }
                deferredInventoryList = null;
                heldItem = serverPlayer.method_6047();
                sendData();
            }
            class_243 initialPos = VecHelper.getCenterOf(field_11867.method_10093(method_11010().method_11654(FACING)));
            serverPlayer.method_5814(initialPos.field_1352, initialPos.field_1351, initialPos.field_1350);
        }
        invHandler = createHandler();
    }

    protected void onExtract(class_1799 stack) {
        player.cast().method_6122(class_1268.field_5808, stack.method_7972());
        sendData();
        method_5431();
    }

    public int getTimerSpeed() {
        return (int) (getSpeed() == 0 ? 0 : class_3532.method_15363(Math.abs(getSpeed() * 2), 8, 512));
    }

    @Override
    public void tick() {
        super.tick();

        if (getSpeed() == 0)
            return;
        if (!field_11863.field_9236 && player != null && player.getBlockBreakingProgress() != null) {
            if (field_11863.method_22347(player.getBlockBreakingProgress().getKey())) {
                field_11863.method_8517(player.cast().method_5628(), player.getBlockBreakingProgress().getKey(), -1);
                player.setBlockBreakingProgress(null);
            }
        }
        if (timer > 0) {
            timer -= getTimerSpeed();
            return;
        }
        if (field_11863.field_9236)
            return;
        if (player == null)
            return;

        class_3222 serverPlayer = player.cast();
        class_1799 stack = serverPlayer.method_6047();
        if (state == State.WAITING) {
            if (!overflowItems.isEmpty()) {
                timer = getTimerSpeed() * 10;
                return;
            }

            boolean changed = false;
            class_1661 inventory = serverPlayer.method_31548();
            for (int i = 0, size = inventory.method_5439(); i < size; i++) {
                if (overflowItems.size() > 10)
                    break;
                class_1799 item = inventory.method_5438(i);
                if (item.method_7960())
                    continue;
                if (item != stack || !filtering.test(item)) {
                    overflowItems.add(item);
                    inventory.method_5447(i, class_1799.field_8037);
                    changed = true;
                }
            }

            if (changed) {
                sendData();
                timer = getTimerSpeed() * 10;
                return;
            }

            class_2350 facing = method_11010().method_11654(FACING);
            if (mode == Mode.USE && !DeployerHandler.shouldActivate(stack, field_11863, field_11867.method_10079(facing, 2), facing)) {
                timer = getTimerSpeed() * 10;
                return;
            }

            // Check for advancement conditions
            if (mode == Mode.PUNCH && !fistBump && startFistBump(facing))
                return;
            if (redstoneLocked)
                return;

            start();
            return;
        }

        if (state == State.EXPANDING) {
            if (fistBump)
                triggerFistBump();
            activate();

            state = State.RETRACTING;
            timer = 1000;
            sendData();
            return;
        }

        if (state == State.RETRACTING) {
            state = State.WAITING;
            timer = 500;
            sendData();
            return;
        }

    }

    protected void start() {
        state = State.EXPANDING;
        class_243 movementVector = getMovementVector();
        class_243 rayOrigin = VecHelper.getCenterOf(field_11867).method_1019(movementVector.method_1021(3 / 2f));
        class_243 rayTarget = VecHelper.getCenterOf(field_11867).method_1019(movementVector.method_1021(5 / 2f));
        class_3959 rayTraceContext = new class_3959(rayOrigin, rayTarget, class_3960.field_17559, class_242.field_1348, player.cast());
        class_3965 result = field_11863.method_17742(rayTraceContext);
        reach = (float) (.5f + Math.min(result.method_17784().method_1020(rayOrigin).method_1033(), .75f));
        timer = 1000;
        sendData();
    }

    public boolean startFistBump(class_2350 facing) {
        int i = 0;
        DeployerBlockEntity partner = null;

        for (i = 2; i < 5; i++) {
            class_2338 otherDeployer = field_11867.method_10079(facing, i);
            if (!field_11863.method_8477(otherDeployer))
                return false;
            class_2586 other = field_11863.method_8321(otherDeployer);
            if (other instanceof DeployerBlockEntity dpe) {
                partner = dpe;
                break;
            }
        }

        if (partner == null)
            return false;

        if (field_11863.method_8320(partner.method_11016()).method_11654(FACING).method_10153() != facing || partner.mode != Mode.PUNCH)
            return false;
        if (partner.getSpeed() == 0)
            return false;

        for (DeployerBlockEntity be : Arrays.asList(this, partner)) {
            be.fistBump = true;
            be.reach = ((i - 2)) * .5f;
            be.timer = 1000;
            be.state = State.EXPANDING;
            be.sendData();
        }

        return true;
    }

    public void triggerFistBump() {
        int i = 0;
        DeployerBlockEntity deployerBlockEntity = null;
        for (i = 2; i < 5; i++) {
            class_2338 pos = this.field_11867.method_10079(method_11010().method_11654(class_2741.field_12525), i);
            if (!field_11863.method_8477(pos))
                return;
            if (field_11863.method_8321(pos) instanceof DeployerBlockEntity dpe) {
                deployerBlockEntity = dpe;
                break;
            }
        }

        if (deployerBlockEntity == null)
            return;
        if (!deployerBlockEntity.fistBump || deployerBlockEntity.state != State.EXPANDING)
            return;
        if (deployerBlockEntity.timer > 0)
            return;

        fistBump = false;
        deployerBlockEntity.fistBump = false;
        deployerBlockEntity.state = State.RETRACTING;
        deployerBlockEntity.timer = 1000;
        deployerBlockEntity.sendData();
        award(AllAdvancements.FIST_BUMP);

        class_2338 soundLocation = class_2338.method_49638(class_243.method_24953(field_11867).method_1019(class_243.method_24953(deployerBlockEntity.method_11016())).method_1021(.5f));
        field_11863.method_8396(null, soundLocation, class_3417.field_14914, class_3419.field_15245, .75f, .75f);
    }

    protected void activate() {
        class_243 movementVector = getMovementVector();
        class_2350 direction = method_11010().method_11654(class_2741.field_12525);
        class_243 center = VecHelper.getCenterOf(field_11867);
        class_2338 clickedPos = field_11867.method_10079(direction, 2);
        class_3222 serverPlayer = player.cast();
        serverPlayer.method_36457(direction == class_2350.field_11036 ? -90 : direction == class_2350.field_11033 ? 90 : 0);
        serverPlayer.method_36456(direction.method_10144());

        if (direction == class_2350.field_11033 && BlockEntityBehaviour.get(field_11863, clickedPos, TransportedItemStackHandlerBehaviour.TYPE) != null)
            return; // Belt processing handled in BeltDeployerCallbacks

        DeployerHandler.activate(player, center, clickedPos, movementVector, mode);
        award(AllAdvancements.DEPLOYER);

        if (player != null) {
            int count = heldItem.method_7947();
            heldItem = serverPlayer.method_6047();
            if (count != heldItem.method_7947())
                method_5431();
        }
    }

    protected class_243 getMovementVector() {
        class_2680 state = method_11010();
        if (!state.method_27852(AllBlocks.DEPLOYER))
            return class_243.field_1353;
        return class_243.method_24954(state.method_11654(FACING).method_62675());
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        state = view.method_71426("State", State.CODEC).orElse(State.WAITING);
        mode = view.method_71426("Mode", Mode.CODEC).orElse(Mode.PUNCH);
        timer = view.method_71424("Timer", 0);
        redstoneLocked = view.method_71433("Powered", false);
        owner = view.method_71426("Owner", class_4844.field_25122).orElse(null);
        ownerName = view.method_71426("OwnerName", Codec.STRING).orElse(null);

        deferredInventoryList = view.method_71426("Inventory", class_2487.field_25128).orElseGet(class_2487::new);
        overflowItems = new ArrayList<>();
        view.method_71426("Overflow", CreateCodecs.ITEM_LIST_CODEC).ifPresent(overflowItems::addAll);
        view.method_71426("HeldItem", class_1799.field_49266).ifPresent(item -> heldItem = item);
        super.read(view, clientPacket);

        if (!clientPacket)
            return;
        fistBump = view.method_71433("Fistbump", false);
        reach = view.method_71423("Reach", 0);
        view.method_71426("Particle", class_1799.field_24671).ifPresent(particleStack -> {
            SandPaperItem.spawnParticles(VecHelper.getCenterOf(field_11867).method_1019(getMovementVector().method_1021(reach + 1)), particleStack, field_11863);
        });
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71468("Mode", Mode.CODEC, mode);
        view.method_71468("State", State.CODEC, state);
        view.method_71465("Timer", timer);
        view.method_71472("Powered", redstoneLocked);
        if (owner != null) {
            view.method_71468("Owner", class_4844.field_25122, owner);
            view.method_71468("OwnerName", Codec.STRING, ownerName);
        }

        if (player != null) {
            class_3222 serverPlayer = player.cast();
            try (class_8942.class_11340 logging = new class_8942.class_11340(method_71402(), LOGGER)) {
                class_11362 writeView = class_11362.method_71459(logging, field_11863.method_30349());
                serverPlayer.method_31548().method_7384(writeView.method_71467("Inventory", class_11343.field_60354));
                view.method_71468("Inventory", class_2487.field_25128, writeView.method_71475());
            }
            class_1799 stack = serverPlayer.method_6047();
            view.method_71468("HeldItem", class_1799.field_49266, stack);
            view.method_71468("Overflow", CreateCodecs.ITEM_LIST_CODEC, overflowItems);
        } else if (deferredInventoryList != null) {
            view.method_71468("Inventory", class_2487.field_25128, deferredInventoryList);
        }

        super.write(view, clientPacket);

        if (!clientPacket)
            return;
        view.method_71472("Fistbump", fistBump);
        view.method_71464("Reach", reach);
        if (player == null)
            return;
        if (player.getSpawnedItemEffects() != null) {
            class_1799 stack = player.getSpawnedItemEffects();
            if (!stack.method_7960()) {
                view.method_71468("Particle", class_1799.field_24671, stack);
            }
            player.setSpawnedItemEffects(null);
        }
    }

    @Override
    public void writeSafe(class_11372 view) {
        view.method_71468("Mode", Mode.CODEC, mode);
        super.writeSafe(view);
    }

    private class_1263 createHandler() {
        return new DeployerItemHandler(this);
    }

    public void redstoneUpdate() {
        if (field_11863.field_9236)
            return;
        boolean blockPowered = field_11863.method_49803(field_11867);
        if (blockPowered == redstoneLocked)
            return;
        redstoneLocked = blockPowered;
        sendData();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(3);
    }

    public void discardPlayer() {
        if (player == null)
            return;
        class_3222 serverPlayer = player.cast();
        serverPlayer.method_31548().method_7388();
        overflowItems.forEach(itemstack -> serverPlayer.method_7329(itemstack, true, false));
        serverPlayer.method_31472();
        player = null;
    }

    public void changeMode() {
        mode = mode == Mode.PUNCH ? Mode.USE : Mode.PUNCH;
        method_5431();
        sendData();
    }

    public void setAnimatedOffset(float offset) {
        animatedOffset.setValue(offset);
    }

    @Nullable
    public class_1860<? extends class_9695> getRecipe(class_1799 stack) {
        if (player == null || field_11863 == null)
            return null;

        class_1799 heldItemMainhand = player.cast().method_6047();
        class_10289 preparedRecipes = ((class_3218) field_11863).method_64577().field_54638;
        if (heldItemMainhand.method_7909() instanceof SandPaperItem) {
            return preparedRecipes.method_64699(AllRecipeTypes.SANDPAPER_POLISHING, new class_9696(stack), field_11863)
                .filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(class_8786::comp_1933).findFirst().orElse(null);
        }

        ItemApplicationInput input = new ItemApplicationInput(stack, heldItemMainhand);
        return AllRecipeTypes.DEPLOYER_RECIPES.stream().flatMap(type -> preparedRecipes.method_64699(type, input, field_11863))
            .filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(class_8786::comp_1933).findFirst().orElse(null);
    }

    public DeployerPlayer getPlayer() {
        return player;
    }
}
