package com.zurrtum.create.content.kinetics.drill;

import com.zurrtum.create.*;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;

public class DrillBlock extends DirectionalKineticBlock implements IBE<DrillBlockEntity>, class_3737 {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public DrillBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(class_2741.field_12508, false));
    }

    @Override
    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entityIn, class_10774 handler) {
        if (entityIn instanceof class_1542)
            return;
        if (!new class_238(pos).method_1011(.1f).method_994(entityIn.method_5829()))
            return;
        withBlockEntityDo(
            worldIn, pos, be -> {
                if (be.getSpeed() == 0)
                    return;
                if (worldIn instanceof class_3218 serverWorld) {
                    entityIn.method_64397(serverWorld, AllDamageSources.get(worldIn).drill, (float) getDamage(be.getSpeed()));
                }
            }
        );
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.CASING_12PX.get(state.method_11654(FACING));
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_2248 blockIn,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        withBlockEntityDo(worldIn, pos, DrillBlockEntity::destroyNextTick);
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(FACING).method_10166();
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face == state.method_11654(FACING).method_10153();
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12508);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(class_2741.field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        return state;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_3610 FluidState = context.method_8045().method_8316(context.method_8037());
        return super.method_9605(context).method_11657(class_2741.field_12508, FluidState.method_15772() == class_3612.field_15910);
    }

    public static double getDamage(float speed) {
        float speedAbs = Math.abs(speed);
        double sub1 = Math.min(speedAbs / 16, 2);
        double sub2 = Math.min(speedAbs / 32, 4);
        double sub3 = Math.min(speedAbs / 64, 4);
        return class_3532.method_15350(sub1 + sub2 + sub3, 1, 10);
    }

    @Override
    public Class<DrillBlockEntity> getBlockEntityClass() {
        return DrillBlockEntity.class;
    }

    @Override
    public class_2591<? extends DrillBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.DRILL;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!player.method_5715() && player.method_7294()) {
            if (placementHelper.matchesItem(stack)) {
                placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);
                return class_1269.field_5812;
            }
        }

        return class_1269.field_52423;
    }

    private static class PlacementHelper implements IPlacementHelper {

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return stack -> stack.method_31574(AllItems.MECHANICAL_DRILL);
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return state -> state.method_27852(AllBlocks.MECHANICAL_DRILL);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(
                pos,
                ray.method_17784(),
                state.method_11654(FACING).method_10166(),
                dir -> world.method_8320(pos.method_10093(dir)).method_45474()
            );

            if (directions.isEmpty())
                return PlacementOffset.fail();
            else {
                return PlacementOffset.success(pos.method_10093(directions.getFirst()), s -> s.method_11657(FACING, state.method_11654(FACING)));
            }
        }
    }

}