package com.zurrtum.create.content.kinetics.press;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_3532;

public class PressingBehaviour extends BeltProcessingBehaviour {

    public static final int CYCLE = 240;
    public static final int ENTITY_SCAN = 10;

    public List<class_1799> particleItems = new ArrayList<>();

    public PressingBehaviourSpecifics specifics;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    public boolean finished;
    public Mode mode;

    int entityScanCooldown;

    public interface PressingBehaviourSpecifics {
        boolean tryProcessInBasin(boolean simulate);

        boolean tryProcessOnBelt(TransportedItemStack input, List<class_1799> outputList, boolean simulate);

        boolean tryProcessInWorld(class_1542 itemEntity, boolean simulate);

        boolean canProcessInBulk();

        void onPressingCompleted();

        int getParticleAmount();

        float getKineticSpeed();
    }

    public <T extends SmartBlockEntity & PressingBehaviourSpecifics> PressingBehaviour(T be) {
        super(be);
        this.specifics = be;
        mode = Mode.WORLD;
        entityScanCooldown = ENTITY_SCAN;
        whenItemEnters((s, i) -> BeltPressingCallbacks.onItemReceived(s, i, this));
        whileItemHeld((s, i) -> BeltPressingCallbacks.whenItemHeld(s, i, this));
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        running = view.method_71433("Running", false);
        mode = Mode.values()[view.method_71424("Mode", 0)];
        finished = view.method_71433("Finished", false);
        prevRunningTicks = runningTicks = view.method_71424("Ticks", 0);
        super.read(view, clientPacket);

        if (clientPacket) {
            view.method_71426("ParticleItems", CreateCodecs.ITEM_LIST_CODEC).ifPresent(particleItems::addAll);
            spawnParticles();
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Running", running);
        view.method_71465("Mode", mode.ordinal());
        view.method_71472("Finished", finished);
        view.method_71465("Ticks", runningTicks);
        super.write(view, clientPacket);

        if (clientPacket) {
            view.method_71468("ParticleItems", CreateCodecs.ITEM_LIST_CODEC, particleItems);
            particleItems.clear();
        }
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (!running)
            return 0;
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = class_3532.method_48781(partialTicks, prevRunningTicks, runningTicks);
        if (runningTicks < (CYCLE * 2) / 3)
            return (float) class_3532.method_15350(Math.pow(ticks / CYCLE * 2, 3), 0, 1);
        return class_3532.method_15363((CYCLE - ticks) / CYCLE * 3, 0, 1);
    }

    public void start(Mode mode) {
        this.mode = mode;
        running = true;
        prevRunningTicks = 0;
        runningTicks = 0;
        particleItems.clear();
        blockEntity.sendData();
    }

    public boolean inWorld() {
        return mode == Mode.WORLD;
    }

    public boolean onBasin() {
        return mode == Mode.BASIN;
    }

    @Override
    public void tick() {
        super.tick();

        class_1937 level = getWorld();
        class_2338 worldPosition = getPos();

        if (!running || level == null) {
            if (level != null && !level.field_9236) {

                if (specifics.getKineticSpeed() == 0)
                    return;
                if (entityScanCooldown > 0)
                    entityScanCooldown--;
                if (entityScanCooldown <= 0) {
                    entityScanCooldown = ENTITY_SCAN;

                    if (BlockEntityBehaviour.get(level, worldPosition.method_10087(2), TransportedItemStackHandlerBehaviour.TYPE) != null)
                        return;
                    if (BasinBlock.isBasin(level, worldPosition.method_10087(2)))
                        return;

                    for (class_1542 itemEntity : level.method_18467(class_1542.class, new class_238(worldPosition.method_10074()).method_1011(.125f))) {
                        if (!itemEntity.method_5805() || !itemEntity.method_24828())
                            continue;
                        if (!specifics.tryProcessInWorld(itemEntity, true))
                            continue;
                        start(Mode.WORLD);
                        return;
                    }
                }

            }
            return;
        }

        if (level.field_9236 && runningTicks == -CYCLE / 2) {
            prevRunningTicks = CYCLE / 2;
            return;
        }

        if (runningTicks == CYCLE / 2 && specifics.getKineticSpeed() != 0) {
            if (inWorld())
                applyInWorld();
            if (onBasin())
                applyOnBasin();

            if (level.method_8320(worldPosition.method_10087(2)).method_26231() == class_2498.field_11543)
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(level, worldPosition);
            else
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(
                    level,
                    worldPosition,
                    .5f,
                    .75f + (Math.abs(specifics.getKineticSpeed()) / 1024f)
                );

            if (!level.field_9236)
                blockEntity.sendData();
        }

        if (!level.field_9236 && runningTicks > CYCLE) {
            finished = true;
            running = false;
            particleItems.clear();
            specifics.onPressingCompleted();
            blockEntity.sendData();
            return;
        }

        prevRunningTicks = runningTicks;
        runningTicks += getRunningTickSpeed();
        if (prevRunningTicks < CYCLE / 2 && runningTicks >= CYCLE / 2) {
            runningTicks = CYCLE / 2;
            // Pause the ticks until a packet is received
            if (level.field_9236 && !blockEntity.isVirtual())
                runningTicks = -(CYCLE / 2);
        }
    }

    protected void applyOnBasin() {
        class_1937 level = getWorld();
        if (level.field_9236)
            return;
        particleItems.clear();
        if (specifics.tryProcessInBasin(false))
            blockEntity.sendData();
    }

    protected void applyInWorld() {
        class_1937 level = getWorld();
        class_2338 worldPosition = getPos();
        class_238 bb = new class_238(worldPosition.method_10087(1));
        boolean bulk = specifics.canProcessInBulk();

        particleItems.clear();

        if (level.field_9236)
            return;

        for (class_1297 entity : level.method_8335(null, bb)) {
            if (!(entity instanceof class_1542 itemEntity))
                continue;
            if (!entity.method_5805() || !entity.method_24828())
                continue;

            entityScanCooldown = 0;
            if (specifics.tryProcessInWorld(itemEntity, false))
                blockEntity.sendData();
            if (!bulk)
                break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = specifics.getKineticSpeed();
        if (speed == 0)
            return 0;
        return (int) class_3532.method_48781(class_3532.method_15363(Math.abs(speed) / 512f, 0, 1), 1, 60);
    }

    protected void spawnParticles() {
        if (particleItems.isEmpty())
            return;

        class_2338 worldPosition = getPos();

        if (mode == Mode.BASIN)
            particleItems.forEach(stack -> makeCompactingParticleEffect(VecHelper.getCenterOf(worldPosition.method_10087(2)), stack));
        if (mode == Mode.BELT)
            particleItems.forEach(stack -> makePressingParticleEffect(VecHelper.getCenterOf(worldPosition.method_10087(2)).method_1031(0, 8 / 16f, 0), stack));
        if (mode == Mode.WORLD)
            particleItems.forEach(stack -> makePressingParticleEffect(VecHelper.getCenterOf(worldPosition.method_10087(1)).method_1031(0, -1 / 4f, 0), stack));

        particleItems.clear();
    }

    public void makePressingParticleEffect(class_243 pos, class_1799 stack) {
        makePressingParticleEffect(pos, stack, specifics.getParticleAmount());
    }

    public void makePressingParticleEffect(class_243 pos, class_1799 stack, int amount) {
        class_1937 level = getWorld();
        if (level == null || !level.field_9236)
            return;
        for (int i = 0; i < amount; i++) {
            class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, level.field_9229, .125f).method_18805(1, 0, 1);
            motion = motion.method_1031(0, amount != 1 ? 0.125f : 1 / 16f, 0);
            level.method_8406(new class_2392(class_2398.field_11218, stack), pos.field_1352, pos.field_1351 - .25f, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        }
    }

    public void makeCompactingParticleEffect(class_243 pos, class_1799 stack) {
        class_1937 level = getWorld();
        if (level == null || !level.field_9236)
            return;
        for (int i = 0; i < 20; i++) {
            class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, level.field_9229, .175f).method_18805(1, 0, 1);
            level.method_8406(new class_2392(class_2398.field_11218, stack), pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351 + .25f, motion.field_1350);
        }
    }

    public enum Mode {
        WORLD(1),
        BELT(19f / 16f),
        BASIN(22f / 16f);

        public float headOffset;

        Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }

}
