package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import net.minecraft.class_1799;

public class DepotItemHandler implements ItemInventory {
    private final DepotBehaviour behaviour;

    public DepotItemHandler(DepotBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        if (slot != 0)
            return false;
        if (!behaviour.isItemValid(stack) || !behaviour.canAcceptItems.get()) {
            return false;
        }
        if (behaviour.canMergeItems()) {
            Integer max = behaviour.maxStackSize.get();
            if (max == 0) {
                return true;
            }
            return behaviour.getHeldItemStack().method_7947() < max;
        } else {
            return behaviour.getHeldItemStack().method_7960() && behaviour.isOutputEmpty();
        }
    }

    @Override
    public int method_5439() {
        return 9;
    }

    @Override
    public class_1799 method_5438(int slot) {
        return slot == 0 ? behaviour.getHeldItemStack() : behaviour.processingOutputBuffer.method_5438(slot - 1);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (slot == 0) {
            if (stack.method_7960()) {
                behaviour.removeHeldItem();
            } else {
                behaviour.setHeldItem(new TransportedItemStack(stack));
            }
        } else {
            behaviour.processingOutputBuffer.method_5447(slot - 1, stack);
        }
    }

    @Override
    public void method_5431() {
        behaviour.blockEntity.notifyUpdate();
    }
}
