package com.zurrtum.create.content.logistics.factoryBoard;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.foundation.gui.menu.GhostItemMenu;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class FactoryPanelSetItemMenu extends GhostItemMenu<ServerFactoryPanelBehaviour> {

    public FactoryPanelSetItemMenu(int id, class_1661 inv, ServerFactoryPanelBehaviour contentHolder) {
        super(AllMenuTypes.FACTORY_PANEL_SET_ITEM, id, inv, contentHolder);
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler();
    }

    @Override
    protected boolean allowRepeats() {
        return true;
    }

    @Override
    protected void addSlots() {
        int playerX = 13;
        int playerY = 112;
        int slotX = 74;
        int slotY = 28;

        addPlayerSlots(playerX, playerY);
        method_7621(new class_1735(ghostInventory, 0, slotX, slotY));
    }

    @Override
    protected void saveData(ServerFactoryPanelBehaviour contentHolder) {
        if (!contentHolder.setFilter(ghostInventory.method_5438(0))) {
            player.method_7353(class_2561.method_43471("create.logistics.filter.invalid_item"), true);
            AllSoundEvents.DENY.playOnServer(player.method_37908(), player.method_24515(), 1, 1);
            return;
        }
        player.method_37908().method_8396(null, contentHolder.getPos(), class_3417.field_14667, class_3419.field_15245, .25f, .1f);
    }

}
