package com.zurrtum.create.content.logistics.funnel;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.foundation.item.ItemHelper;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class FunnelMovementBehaviour extends MovementBehaviour {

    private final boolean hasFilter;

    public static FunnelMovementBehaviour andesite() {
        return new FunnelMovementBehaviour(false);
    }

    public static FunnelMovementBehaviour brass() {
        return new FunnelMovementBehaviour(true);
    }

    private FunnelMovementBehaviour(boolean hasFilter) {
        this.hasFilter = hasFilter;
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        class_2350 facing = FunnelBlock.getFunnelFacing(context.state);
        class_243 vec = class_243.method_24954(facing.method_62675());
        if (facing != class_2350.field_11036)
            return vec.method_1021(context.state.method_11654(FunnelBlock.EXTRACTING) ? .15 : .65);

        return vec.method_1021(.65);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        super.visitNewPosition(context, pos);

        if (context.state.method_11654(FunnelBlock.EXTRACTING))
            extract(context, pos);
        else
            succ(context, pos);

    }

    private void extract(MovementContext context, class_2338 pos) {
        class_1937 world = context.world;

        class_243 entityPos = context.position;
        if (context.state.method_11654(FunnelBlock.FACING) != class_2350.field_11033)
            entityPos = entityPos.method_1031(0, -.5f, 0);

        if (!world.method_8320(pos).method_26220(world, pos).method_1110())
            return;

        if (!world.method_18467(class_1542.class, new class_238(class_2338.method_49638(entityPos))).isEmpty())
            return;

        FilterItemStack filter = context.getFilterFromBE();
        int filterAmount = context.blockEntityData.method_68083("FilterAmount", 0);
        boolean upTo = context.blockEntityData.method_68566("UpTo", false);
        filterAmount = hasFilter ? filterAmount : 1;

        class_1263 inventory = context.contraption.getStorage().getAllItems();
        class_1799 extract;
        if (upTo) {
            extract = inventory.extract(s -> filter.test(world, s), filterAmount);
        } else {
            extract = inventory.preciseExtract(s -> filter.test(world, s), filterAmount);
        }

        if (extract.method_7960())
            return;

        if (world.field_9236)
            return;

        class_1542 entity = new class_1542(world, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, extract);
        entity.method_18799(class_243.field_1353);
        entity.method_6982(5);
        world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 1 / 16f, .1f);
        world.method_8649(entity);
    }

    private void succ(MovementContext context, class_2338 pos) {
        class_1937 world = context.world;
        List<class_1297> items = world.method_8333(null, new class_238(pos), e -> e instanceof class_1542 || e instanceof PackageEntity);
        FilterItemStack filter = context.getFilterFromBE();

        for (class_1297 entity : items) {
            if (!entity.method_5805())
                continue;
            class_1799 toInsert = ItemHelper.fromItemEntity(entity);
            if (!filter.test(context.world, toInsert))
                continue;
            class_1263 inventory = context.contraption.getStorage().getAllItems();
            int count = toInsert.method_7947();
            int insert = inventory.insertExist(toInsert);
            if (insert == count) {
                entity.method_31472();
            } else if (insert > 0) {
                toInsert.method_7939(count - insert);
                if (entity instanceof class_1542 item) {
                    item.method_6979(toInsert);
                }
            }
        }
    }

}
