package com.zurrtum.create.content.logistics.packagerLink;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class PackagerLinkBlock extends class_2341 implements IBE<PackagerLinkBlockEntity>, ProperWaterloggedBlock, IWrenchable {
    public static final MapCodec<PackagerLinkBlock> field_46280 = method_54094(PackagerLinkBlock::new);

    public static final class_2746 POWERED = class_2741.field_12484;

    public PackagerLinkBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(POWERED, false).method_11657(WATERLOGGED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2338 pos = context.method_8037();
        class_2680 placed = super.method_9605(context);
        if (placed == null)
            return null;
        if (placed.method_11654(field_11007) == class_2738.field_12473)
            placed = placed.method_11657(field_11177, placed.method_11654(field_11177).method_10153());
        return withWater(placed.method_11657(POWERED, getPower(placed, context.method_8045(), pos) > 0), context);
    }

    public static class_2350 getConnectedDirection(class_2680 state) {
        return class_2341.method_10119(state);
    }

    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return true;
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pPos);
        return pState;
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_2248 blockIn,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        if (worldIn.field_9236)
            return;

        int power = getPower(state, worldIn, pos);
        boolean powered = power > 0;
        boolean previouslyPowered = state.method_11654(POWERED);
        if (previouslyPowered != powered)
            worldIn.method_8652(pos, state.method_28493(POWERED), class_2248.field_31028);
        withBlockEntityDo(worldIn, pos, link -> link.behaviour.redstonePowerChanged(power));
    }

    public static int getPower(class_2680 state, class_1937 worldIn, class_2338 pos) {
        int power = 0;
        for (class_2350 d : Iterate.directions)
            if (d.method_10153() != getConnectedDirection(state))
                power = Math.max(power, worldIn.method_49808(pos.method_10093(d), d));
        return power;
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        withBlockEntityDo(
            pLevel, pPos, plbe -> {
                if (pPlacer instanceof class_1657 player) {
                    plbe.placedBy = player.method_5667();
                    plbe.notifyUpdate();
                }
            }
        );
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.STOCK_LINK.get(getConnectedDirection(pState));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(POWERED, WATERLOGGED, field_11007, field_11177));
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public Class<PackagerLinkBlockEntity> getBlockEntityClass() {
        return PackagerLinkBlockEntity.class;
    }

    @Override
    public class_2591<? extends PackagerLinkBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.PACKAGER_LINK;
    }

    @Override
    protected MapCodec<? extends class_2341> method_53969() {
        return field_46280;
    }
}
