package com.zurrtum.create.content.logistics.tunnel;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock.Shape;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerSidedFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class BrassTunnelBlockEntity extends BeltTunnelBlockEntity {
    ServerSidedFilteringBehaviour filtering;

    boolean connectedLeft;
    boolean connectedRight;

    class_1799 stackToDistribute;
    class_2350 stackEnteredFrom;

    float distributionProgress;
    int distributionDistanceLeft;
    int distributionDistanceRight;
    int previousOutputIndex;

    // <filtered, non-filtered>
    Couple<List<Pair<class_2338, class_2350>>> distributionTargets;

    private boolean newItemArrived;
    private boolean syncedOutputActive;
    private Set<BrassTunnelBlockEntity> syncSet;

    protected ServerScrollOptionBehaviour<SelectionMode> selectionMode;
    private class_1263 beltCapability;
    public class_1263 tunnelCapability;

    public BrassTunnelBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.BRASS_TUNNEL, pos, state);
        distributionTargets = Couple.create(ArrayList::new);
        syncSet = new HashSet<>();
        stackToDistribute = class_1799.field_8037;
        stackEnteredFrom = null;
        beltCapability = null;
        tunnelCapability = new BrassTunnelItemHandler(this);
        previousOutputIndex = 0;
        syncedOutputActive = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(selectionMode = new ServerScrollOptionBehaviour<>(SelectionMode.class, this));

        // Propagate settings across connected tunnels
        selectionMode.withCallback(setting -> {
            for (boolean side : Iterate.trueAndFalse) {
                if (!isConnected(side))
                    continue;
                BrassTunnelBlockEntity adjacent = getAdjacent(side);
                if (adjacent != null)
                    adjacent.selectionMode.setValue(setting);
            }
        });
    }

    @Override
    public void tick() {
        super.tick();
        BeltBlockEntity beltBelow = BeltHelper.getSegmentBE(field_11863, field_11867.method_10074());

        if (distributionProgress > 0)
            distributionProgress--;
        if (beltBelow == null || beltBelow.getSpeed() == 0)
            return;
        if (stackToDistribute.method_7960() && !syncedOutputActive)
            return;
        if (field_11863.field_9236 && !isVirtual())
            return;

        if (distributionProgress == -1) {
            distributionTargets.forEach(List::clear);
            distributionDistanceLeft = 0;
            distributionDistanceRight = 0;

            syncSet.clear();
            List<Pair<BrassTunnelBlockEntity, class_2350>> validOutputs = gatherValidOutputs();
            if (selectionMode.get() == SelectionMode.SYNCHRONIZE) {
                boolean allEmpty = true;
                boolean allFull = true;
                for (BrassTunnelBlockEntity be : syncSet) {
                    boolean hasStack = !be.stackToDistribute.method_7960();
                    allEmpty &= !hasStack;
                    allFull &= hasStack;
                }
                final boolean notifySyncedOut = !allEmpty;
                if (allFull || allEmpty)
                    syncSet.forEach(be -> be.syncedOutputActive = notifySyncedOut);
            }

            if (validOutputs == null)
                return;
            if (stackToDistribute.method_7960())
                return;

            for (Pair<BrassTunnelBlockEntity, class_2350> pair : validOutputs) {
                BrassTunnelBlockEntity tunnel = pair.getFirst();
                class_2350 output = pair.getSecond();
                if (insertIntoTunnel(tunnel, output, stackToDistribute, true) == null)
                    continue;
                distributionTargets.get(!tunnel.flapFilterEmpty(output)).add(Pair.of(tunnel.field_11867, output));
                int distance = tunnel.field_11867.method_10263() + tunnel.field_11867.method_10260() - field_11867.method_10263() - field_11867.method_10260();
                if (distance < 0)
                    distributionDistanceLeft = Math.max(distributionDistanceLeft, -distance);
                else
                    distributionDistanceRight = Math.max(distributionDistanceRight, distance);
            }

            if (distributionTargets.getFirst().isEmpty() && distributionTargets.getSecond().isEmpty())
                return;

            if (newItemArrived) {
                newItemArrived = false;
                distributionProgress = 2;
            } else {
                if (selectionMode.get() != SelectionMode.SYNCHRONIZE || syncedOutputActive) {
                    distributionProgress = AllConfigs.server().logistics.brassTunnelTimer.get();
                    sendData();
                }
                return;
            }
        }

        if (distributionProgress != 0)
            return;

        distributionTargets.forEach(list -> {
            if (stackToDistribute.method_7960())
                return;
            List<Pair<BrassTunnelBlockEntity, class_2350>> validTargets = new ArrayList<>();
            for (Pair<class_2338, class_2350> pair : list) {
                class_2338 tunnelPos = pair.getFirst();
                class_2350 output = pair.getSecond();
                if (tunnelPos.equals(field_11867) && output == stackEnteredFrom)
                    continue;
                class_2586 be = field_11863.method_8321(tunnelPos);
                if (!(be instanceof BrassTunnelBlockEntity))
                    continue;
                validTargets.add(Pair.of((BrassTunnelBlockEntity) be, output));
            }
            distribute(validTargets);
            distributionProgress = -1;
        });
    }

    private static Map<Pair<BrassTunnelBlockEntity, class_2350>, class_1799> distributed = new IdentityHashMap<>();
    private static Set<Pair<BrassTunnelBlockEntity, class_2350>> full = new HashSet<>();

    private void distribute(List<Pair<BrassTunnelBlockEntity, class_2350>> validTargets) {
        int amountTargets = validTargets.size();
        if (amountTargets == 0)
            return;

        distributed.clear();
        full.clear();

        int indexStart = previousOutputIndex % amountTargets;
        SelectionMode mode = selectionMode.get();
        boolean force = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.FORCED_SPLIT;
        boolean split = mode == SelectionMode.FORCED_SPLIT || mode == SelectionMode.SPLIT;
        boolean robin = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.ROUND_ROBIN;

        if (mode == SelectionMode.RANDOMIZE)
            indexStart = field_11863.field_9229.method_43048(amountTargets);
        if (mode == SelectionMode.PREFER_NEAREST || mode == SelectionMode.SYNCHRONIZE)
            indexStart = 0;

        class_1799 toDistribute = stackToDistribute.method_7972();
        for (boolean distributeAgain : Iterate.trueAndFalse) {
            class_1799 toDistributeThisCycle = null;
            int remainingOutputs = amountTargets;
            int leftovers = 0;

            for (boolean simulate : Iterate.trueAndFalse) {
                if (remainingOutputs == 0)
                    break;

                leftovers = 0;
                int index = indexStart;
                int stackSize = toDistribute.method_7947();
                int splitStackSize = stackSize / remainingOutputs;
                int splitRemainder = stackSize % remainingOutputs;
                int visited = 0;

                toDistributeThisCycle = toDistribute.method_7972();
                if (!(force || split) && simulate)
                    continue;

                while (visited < amountTargets) {
                    Pair<BrassTunnelBlockEntity, class_2350> pair = validTargets.get(index);
                    BrassTunnelBlockEntity tunnel = pair.getFirst();
                    class_2350 side = pair.getSecond();
                    index = (index + 1) % amountTargets;
                    visited++;

                    if (full.contains(pair)) {
                        if (split && simulate)
                            remainingOutputs--;
                        continue;
                    }

                    int count = split ? splitStackSize + (splitRemainder > 0 ? 1 : 0) : stackSize;
                    class_1799 toOutput = toDistributeThisCycle.method_46651(count);

                    // Grow by 1 to determine if target is full even after a successful transfer
                    boolean testWithIncreasedCount = distributed.containsKey(pair);
                    int increasedCount = testWithIncreasedCount ? distributed.get(pair).method_7947() : 0;
                    if (testWithIncreasedCount)
                        toOutput.method_7933(increasedCount);

                    class_1799 remainder = insertIntoTunnel(tunnel, side, toOutput, true);

                    if (remainder == null || remainder.method_7947() == (testWithIncreasedCount ? count + 1 : count)) {
                        if (force)
                            return;
                        if (split && simulate)
                            remainingOutputs--;
                        if (!simulate)
                            full.add(pair);
                        if (robin)
                            break;
                        continue;
                    } else if (!remainder.method_7960() && !simulate) {
                        full.add(pair);
                    }

                    if (!simulate) {
                        toOutput.method_7934(remainder.method_7947());
                        distributed.put(pair, toOutput);
                    }

                    leftovers += remainder.method_7947();
                    toDistributeThisCycle.method_7934(count);
                    if (toDistributeThisCycle.method_7960())
                        break;
                    splitRemainder--;
                    if (!split)
                        break;
                }
            }

            toDistribute.method_7939(toDistributeThisCycle.method_7947() + leftovers);
            if (leftovers == 0 && distributeAgain)
                break;
            if (!split)
                break;
        }

        int failedTransferrals = 0;
        for (Map.Entry<Pair<BrassTunnelBlockEntity, class_2350>, class_1799> entry : distributed.entrySet()) {
            Pair<BrassTunnelBlockEntity, class_2350> pair = entry.getKey();
            failedTransferrals += insertIntoTunnel(pair.getFirst(), pair.getSecond(), entry.getValue(), false).method_7947();
        }

        toDistribute.method_7933(failedTransferrals);
        stackToDistribute = stackToDistribute.method_46651(toDistribute.method_7947());
        if (stackToDistribute.method_7960())
            stackEnteredFrom = null;
        previousOutputIndex++;
        previousOutputIndex %= amountTargets;
        notifyUpdate();
    }

    public void setStackToDistribute(class_1799 stack, @Nullable class_2350 enteredFrom) {
        stackToDistribute = stack;
        stackEnteredFrom = enteredFrom;
        distributionProgress = -1;
        if (!stack.method_7960())
            newItemArrived = true;
        sendData();
        method_5431();
    }

    public class_1799 getStackToDistribute() {
        return stackToDistribute;
    }

    public List<class_1799> grabAllStacksOfGroup(boolean simulate) {
        List<class_1799> list = new ArrayList<>();

        class_1799 own = getStackToDistribute();
        if (!own.method_7960()) {
            list.add(own);
            if (!simulate)
                setStackToDistribute(class_1799.field_8037, null);
        }

        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelBlockEntity adjacent = this;
            while (adjacent != null) {
                if (!field_11863.method_8477(adjacent.method_11016()))
                    return null;
                adjacent = adjacent.getAdjacent(left);
                if (adjacent == null)
                    continue;
                class_1799 other = adjacent.getStackToDistribute();
                if (other.method_7960())
                    continue;
                list.add(other);
                if (!simulate)
                    adjacent.setStackToDistribute(class_1799.field_8037, null);
            }
        }

        return list;
    }

    @Nullable
    protected class_1799 insertIntoTunnel(BrassTunnelBlockEntity tunnel, class_2350 side, class_1799 stack, boolean simulate) {
        if (stack.method_7960())
            return stack;
        if (!tunnel.testFlapFilter(side, stack))
            return null;

        BeltBlockEntity below = BeltHelper.getSegmentBE(field_11863, tunnel.field_11867.method_10074());
        if (below == null)
            return null;
        class_2338 offset = tunnel.method_11016().method_10074().method_10093(side);
        DirectBeltInputBehaviour sideOutput = BlockEntityBehaviour.get(field_11863, offset, DirectBeltInputBehaviour.TYPE);
        if (sideOutput != null) {
            if (!sideOutput.canInsertFromSide(side))
                return null;
            class_1799 result = sideOutput.handleInsertion(stack, side, simulate);
            if (result.method_7960() && !simulate)
                tunnel.flap(side, false);
            return result;
        }

        class_2350 movementFacing = below.getMovementFacing();
        if (side == movementFacing)
            if (!BlockHelper.hasBlockSolidSide(field_11863.method_8320(offset), field_11863, offset, side.method_10153())) {
                BeltBlockEntity controllerBE = below.getControllerBE();
                if (controllerBE == null)
                    return null;

                if (!simulate) {
                    tunnel.flap(side, true);
                    class_1799 ejected = stack;
                    float beltMovementSpeed = below.getDirectionAwareBeltMovementSpeed();
                    float movementSpeed = Math.max(Math.abs(beltMovementSpeed), 1 / 8f);
                    int additionalOffset = beltMovementSpeed > 0 ? 1 : 0;
                    class_243 outPos = BeltHelper.getVectorForOffset(controllerBE, below.index + additionalOffset);
                    class_243 outMotion = class_243.method_24954(side.method_62675()).method_1021(movementSpeed).method_1031(0, 1 / 8f, 0);
                    outPos.method_1019(outMotion.method_1029());
                    class_1542 entity = new class_1542(field_11863, outPos.field_1352, outPos.field_1351 + 6 / 16f, outPos.field_1350, ejected);
                    entity.method_18799(outMotion);
                    entity.method_6988();
                    entity.field_6037 = true;
                    field_11863.method_8649(entity);
                }

                return class_1799.field_8037;
            }

        return null;
    }

    public boolean testFlapFilter(class_2350 side, class_1799 stack) {
        if (filtering == null)
            return false;
        if (filtering.get(side) == null) {
            ServerFilteringBehaviour adjacentFilter = BlockEntityBehaviour.get(field_11863, field_11867.method_10093(side), ServerFilteringBehaviour.TYPE);
            if (adjacentFilter == null)
                return true;
            return adjacentFilter.test(stack);
        }
        return filtering.test(side, stack);
    }

    public boolean flapFilterEmpty(class_2350 side) {
        if (filtering == null)
            return false;
        if (filtering.get(side) == null) {
            ServerFilteringBehaviour adjacentFilter = BlockEntityBehaviour.get(field_11863, field_11867.method_10093(side), ServerFilteringBehaviour.TYPE);
            if (adjacentFilter == null)
                return true;
            return adjacentFilter.getFilter().method_7960();
        }
        return filtering.getFilter(side).method_7960();
    }

    @Override
    public void initialize() {
        if (filtering == null) {
            filtering = createSidedFilter();
            attachBehaviourLate(filtering);
        }
        super.initialize();
    }

    public boolean canInsert(class_2350 side, class_1799 stack) {
        if (filtering != null && !filtering.test(side, stack))
            return false;
        if (!hasDistributionBehaviour())
            return true;
        return stackToDistribute.method_7960();
    }

    public boolean hasDistributionBehaviour() {
        if (flaps.isEmpty())
            return false;
        if (connectedLeft || connectedRight)
            return true;
        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.BRASS_TUNNEL))
            return false;
        class_2351 axis = blockState.method_11654(BrassTunnelBlock.HORIZONTAL_AXIS);
        for (class_2350 direction : flaps.keySet())
            if (direction.method_10166() != axis)
                return true;
        return false;
    }

    private List<Pair<BrassTunnelBlockEntity, class_2350>> gatherValidOutputs() {
        List<Pair<BrassTunnelBlockEntity, class_2350>> validOutputs = new ArrayList<>();
        boolean synchronize = selectionMode.get() == SelectionMode.SYNCHRONIZE;
        addValidOutputsOf(this, validOutputs);

        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelBlockEntity adjacent = this;
            while (adjacent != null) {
                if (!field_11863.method_8477(adjacent.method_11016()))
                    return null;
                adjacent = adjacent.getAdjacent(left);
                if (adjacent == null)
                    continue;
                addValidOutputsOf(adjacent, validOutputs);
            }
        }

        if (!syncedOutputActive && synchronize)
            return null;
        return validOutputs;
    }

    private void addValidOutputsOf(BrassTunnelBlockEntity tunnelBE, List<Pair<BrassTunnelBlockEntity, class_2350>> validOutputs) {
        syncSet.add(tunnelBE);
        BeltBlockEntity below = BeltHelper.getSegmentBE(field_11863, tunnelBE.field_11867.method_10074());
        if (below == null)
            return;
        class_2350 movementFacing = below.getMovementFacing();
        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.BRASS_TUNNEL))
            return;

        boolean prioritizeSides = tunnelBE == this;

        for (boolean sidePass : Iterate.trueAndFalse) {
            if (!prioritizeSides && sidePass)
                continue;
            for (class_2350 direction : Iterate.horizontalDirections) {
                if (direction == movementFacing && below.getSpeed() == 0)
                    continue;
                if (prioritizeSides && sidePass == (direction.method_10166() == movementFacing.method_10166()))
                    continue;
                if (direction == movementFacing.method_10153())
                    continue;
                if (!tunnelBE.sides.contains(direction))
                    continue;

                class_2338 offset = tunnelBE.field_11867.method_10074().method_10093(direction);

                class_2680 potentialFunnel = field_11863.method_8320(offset.method_10084());
                if (potentialFunnel.method_26204() instanceof BeltFunnelBlock && potentialFunnel.method_11654(BeltFunnelBlock.SHAPE) == Shape.PULLING && FunnelBlock.getFunnelFacing(
                    potentialFunnel) == direction)
                    continue;

                DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get(field_11863, offset, DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null) {
                    if (direction == movementFacing)
                        if (!BlockHelper.hasBlockSolidSide(field_11863.method_8320(offset), field_11863, offset, direction.method_10153()))
                            validOutputs.add(Pair.of(tunnelBE, direction));
                    continue;
                }
                if (inputBehaviour.canInsertFromSide(direction))
                    validOutputs.add(Pair.of(tunnelBE, direction));
            }
        }
    }

    @Override
    public void addBehavioursDeferred(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehavioursDeferred(behaviours);
        filtering = createSidedFilter();
        behaviours.add(filtering);
    }

    protected ServerSidedFilteringBehaviour createSidedFilter() {
        return new ServerSidedFilteringBehaviour(this, this::makeFilter, this::isValidFaceForFilter);
    }

    private ServerFilteringBehaviour makeFilter(class_2350 side, ServerFilteringBehaviour filter) {
        return filter;
    }

    private boolean isValidFaceForFilter(class_2350 side) {
        return sides.contains(side);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("SyncedOutput", syncedOutputActive);
        view.method_71472("ConnectedLeft", connectedLeft);
        view.method_71472("ConnectedRight", connectedRight);

        if (!stackToDistribute.method_7960()) {
            view.method_71468("StackToDistribute", class_1799.field_24671, stackToDistribute);
        }
        if (stackEnteredFrom != null)
            view.method_71468("StackEnteredFrom", class_2350.field_29502, stackEnteredFrom);

        view.method_71464("DistributionProgress", distributionProgress);
        view.method_71465("PreviousIndex", previousOutputIndex);
        view.method_71465("DistanceLeft", distributionDistanceLeft);
        view.method_71465("DistanceRight", distributionDistanceRight);

        view.method_71468("FilteredTargets", CreateCodecs.BLOCK_POS_DIRECTION_LIST_CODEC, distributionTargets.getFirst());
        view.method_71468("Targets", CreateCodecs.BLOCK_POS_DIRECTION_LIST_CODEC, distributionTargets.getSecond());

        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        boolean wasConnectedLeft = connectedLeft;
        boolean wasConnectedRight = connectedRight;

        syncedOutputActive = view.method_71433("SyncedOutput", false);
        connectedLeft = view.method_71433("ConnectedLeft", false);
        connectedRight = view.method_71433("ConnectedRight", false);

        stackToDistribute = view.method_71426("StackToDistribute", class_1799.field_24671).orElse(class_1799.field_8037);
        stackEnteredFrom = view.method_71426("StackEnteredFrom", class_2350.field_29502).orElse(null);

        distributionProgress = view.method_71423("DistributionProgress", 0);
        previousOutputIndex = view.method_71424("PreviousIndex", 0);
        distributionDistanceLeft = view.method_71424("DistanceLeft", 0);
        distributionDistanceRight = view.method_71424("DistanceRight", 0);

        distributionTargets.getFirst().clear();
        view.method_71426("FilteredTargets", CreateCodecs.BLOCK_POS_DIRECTION_LIST_CODEC)
            .ifPresent(targets -> distributionTargets.getFirst().addAll(targets));
        distributionTargets.getSecond().clear();
        view.method_71426("Targets", CreateCodecs.BLOCK_POS_DIRECTION_LIST_CODEC).ifPresent(targets -> distributionTargets.getSecond().addAll(targets));

        super.read(view, clientPacket);

        if (!clientPacket)
            return;
        if (wasConnectedLeft != connectedLeft || wasConnectedRight != connectedRight) {
            if (method_11002())
                field_11863.method_8413(method_11016(), method_11010(), method_11010(), 16);
        }
        filtering.updateFilterPresence();
    }

    public boolean isConnected(boolean leftSide) {
        return leftSide ? connectedLeft : connectedRight;
    }

    @Override
    public void updateTunnelConnections() {
        super.updateTunnelConnections();
        boolean connectivityChanged = false;
        boolean nowConnectedLeft = determineIfConnected(true);
        boolean nowConnectedRight = determineIfConnected(false);

        if (connectedLeft != nowConnectedLeft) {
            connectedLeft = nowConnectedLeft;
            connectivityChanged = true;
            BrassTunnelBlockEntity adjacent = getAdjacent(true);
            if (adjacent != null && !field_11863.field_9236) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(selectionMode.getValue());
            }
        }

        if (connectedRight != nowConnectedRight) {
            connectedRight = nowConnectedRight;
            connectivityChanged = true;
            BrassTunnelBlockEntity adjacent = getAdjacent(false);
            if (adjacent != null && !field_11863.field_9236) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(selectionMode.getValue());
            }
        }

        if (filtering != null)
            filtering.updateFilterPresence();
        if (connectivityChanged)
            sendData();
    }

    protected boolean determineIfConnected(boolean leftSide) {
        if (flaps.isEmpty())
            return false;
        BrassTunnelBlockEntity adjacentTunnelBE = getAdjacent(leftSide);
        return adjacentTunnelBE != null && !adjacentTunnelBE.flaps.isEmpty();
    }

    @Nullable
    protected BrassTunnelBlockEntity getAdjacent(boolean leftSide) {
        if (!method_11002())
            return null;

        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.BRASS_TUNNEL))
            return null;

        class_2351 axis = blockState.method_11654(BrassTunnelBlock.HORIZONTAL_AXIS);
        class_2350 baseDirection = class_2350.method_10156(class_2352.field_11056, axis);
        class_2350 direction = leftSide ? baseDirection.method_10160() : baseDirection.method_10170();
        class_2338 adjacentPos = field_11867.method_10093(direction);
        class_2680 adjacentBlockState = field_11863.method_8320(adjacentPos);

        if (!adjacentBlockState.method_27852(AllBlocks.BRASS_TUNNEL))
            return null;
        if (adjacentBlockState.method_11654(BrassTunnelBlock.HORIZONTAL_AXIS) != axis)
            return null;
        class_2586 adjacentBE = field_11863.method_8321(adjacentPos);
        if (adjacentBE.method_11015())
            return null;
        if (!(adjacentBE instanceof BrassTunnelBlockEntity))
            return null;
        return (BrassTunnelBlockEntity) adjacentBE;
    }

    @Override
    public void destroy() {
        super.destroy();
        class_2248.method_9577(field_11863, field_11867, stackToDistribute);
        stackEnteredFrom = null;
    }

    public class_1263 getBeltCapability() {
        if (beltCapability == null) {
            class_2338 down = field_11867.method_10074();
            class_2586 blockEntity = field_11863.method_8321(down);
            if (blockEntity != null) {
                beltCapability = ItemHelper.getInventory(field_11863, down, null, blockEntity, class_2350.field_11036);
            }
        }
        return beltCapability;
    }

    public enum SelectionMode {
        SPLIT,
        FORCED_SPLIT,
        ROUND_ROBIN,
        FORCED_ROUND_ROBIN,
        PREFER_NEAREST,
        RANDOMIZE,
        SYNCHRONIZE;
    }

    public boolean canTakeItems() {
        return stackToDistribute.method_7960() && !syncedOutputActive;
    }
}
